/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_5;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.TreeModel;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class UpgradeGroup
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeGroup.class);

    protected void doUpgrade() throws Exception {
        this.updateParentGroup();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateParentGroup() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            StringBundler sb = new StringBundler(7);
            sb.append("select stagingGroup_.groupId, ");
            sb.append("liveGroup_.parentGroupId from Group_ stagingGroup_ ");
            sb.append("inner join Group_ liveGroup_ on (liveGroup_.groupId = ");
            sb.append("stagingGroup_.liveGroupId) where ");
            sb.append("(stagingGroup_.remoteStagingGroupCount = 0) and ");
            sb.append("(liveGroup_.parentGroupId != ");
            sb.append("stagingGroup_.parentGroupId)");
            try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(sb.toString());
                 PreparedStatement preparedStatement2 = this.connection.prepareStatement("select treePath from Group_ where groupId = ?");
                 PreparedStatement preparedStatement3 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update Group_ set parentGroupId = ?, treePath = ? where groupId = ?");
                 ResultSet resultSet1 = preparedStatement1.executeQuery();){
                while (resultSet1.next()) {
                    ResultSet resultSet2;
                    block73: {
                        long groupId = resultSet1.getLong(1);
                        long parentGroupId = resultSet1.getLong(2);
                        preparedStatement2.setLong(1, parentGroupId);
                        resultSet2 = preparedStatement2.executeQuery();
                        Throwable throwable = null;
                        try {
                            String treePath = null;
                            if (resultSet2.next()) {
                                treePath = resultSet2.getString("treePath");
                                treePath = treePath.concat(String.valueOf(groupId));
                                treePath = treePath.concat("/");
                            } else {
                                if (_log.isWarnEnabled()) {
                                    _log.warn((Object)("Unable to find group " + parentGroupId));
                                }
                                StringBundler treePathSB = new StringBundler(5);
                                treePathSB.append("/");
                                treePathSB.append(parentGroupId);
                                treePathSB.append("/");
                                treePathSB.append(groupId);
                                treePathSB.append("/");
                                treePath = treePathSB.toString();
                            }
                            preparedStatement3.setLong(1, parentGroupId);
                            preparedStatement3.setString(2, treePath);
                            preparedStatement3.setLong(3, groupId);
                            preparedStatement3.addBatch();
                            if (resultSet2 == null) continue;
                            if (throwable == null) break block73;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (resultSet2 == null) throw throwable3;
                                if (throwable == null) {
                                    resultSet2.close();
                                    throw throwable3;
                                }
                                try {
                                    resultSet2.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                        }
                        try {
                            resultSet2.close();
                            continue;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            continue;
                        }
                    }
                    resultSet2.close();
                }
                preparedStatement3.executeBatch();
                return;
            }
        }
    }

    private class GroupTreeModel
    implements TreeModel {
        private long _groupId;
        private final PreparedStatement _preparedStatement;

        public GroupTreeModel(PreparedStatement preparedStatement) {
            this._preparedStatement = preparedStatement;
        }

        public String buildTreePath() throws PortalException {
            return null;
        }

        public Serializable getPrimaryKeyObj() {
            return Long.valueOf(this._groupId);
        }

        public String getTreePath() {
            return null;
        }

        public void setPrimaryKeyObj(Serializable primaryKeyObj) {
            this._groupId = (Long)primaryKeyObj;
        }

        public void updateTreePath(String treePath) {
            try {
                this._preparedStatement.setString(1, treePath);
                this._preparedStatement.setLong(2, this._groupId);
                this._preparedStatement.addBatch();
            }
            catch (SQLException sqlException) {
                _log.error((Object)("Unable to update tree path: " + treePath), (Throwable)sqlException);
            }
        }
    }
}

