/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_4_x;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.upgrade.v7_4_x.util.DLFileEntryTable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeDLFileEntry
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        if (!this.hasColumn("DLFileEntry", "externalReferenceCode")) {
            this.alter(DLFileEntryTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, "externalReferenceCode", "VARCHAR(75)")});
            this._populateExternalReferenceCode();
        }
        if (!this.hasColumn("DLFileEntry", "expirationDate")) {
            this.alter(DLFileEntryTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, "expirationDate", "DATE null")});
        }
        if (!this.hasColumn("DLFileEntry", "reviewDate")) {
            this.alter(DLFileEntryTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, "reviewDate", "DATE null")});
        }
    }

    private void _populateExternalReferenceCode() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select fileEntryId from DLFileEntry where externalReferenceCode is null or externalReferenceCode = ''");
             ResultSet resultSet = preparedStatement1.executeQuery();
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)this.connection.prepareStatement("update DLFileEntry set externalReferenceCode = ? where fileEntryId = ?"));){
            while (resultSet.next()) {
                long fileEntryId = resultSet.getLong(1);
                preparedStatement2.setString(1, String.valueOf(fileEntryId));
                preparedStatement2.setLong(2, fileEntryId);
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }
}

