/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_4_x;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.model.PortletPreferenceValue;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.upgrade.v7_4_x.util.PortletPreferencesTable;
import com.liferay.portlet.PortletPreferencesFactoryImpl;
import com.liferay.portlet.Preference;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;

public class UpgradePortletPreferences
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.runSQL(StringBundler.concat((String[])new String[]{"create table PortletPreferenceValue (mvccVersion LONG ", "default 0 not null, ctCollectionId LONG default 0 not null, ", "portletPreferenceValueId LONG not null, companyId LONG, ", "portletPreferencesId LONG, index_ INTEGER, largeValue TEXT ", "null, name VARCHAR(255) null, readOnly BOOLEAN, smallValue ", "VARCHAR(255) null, primary key (portletPreferenceValueId, ", "ctCollectionId))"}));
        try (PreparedStatement selectPreparedStatement = this.connection.prepareStatement(SQLTransformer.transform(StringBundler.concat((String[])new String[]{"select ctCollectionId, portletPreferencesId, ", "companyId, preferences from PortletPreferences ", "where CAST_CLOB_TEXT(preferences) != '", "<portlet-preferences />", "' and preferences is not null"})));
             PreparedStatement insertPreparedStatement = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"insert into PortletPreferenceValue (mvccVersion, ", "ctCollectionId, portletPreferenceValueId, ", "companyId, portletPreferencesId, index_, ", "largeValue, name, readOnly, smallValue) values ", "(0, ?, ?, ?, ?, ?, ?, ?, ?, ?)"})));
             ResultSet resultSet = selectPreparedStatement.executeQuery();){
            while (resultSet.next()) {
                Map<String, Preference> preferenceMap;
                String preferences = resultSet.getString("preferences");
                if (preferences.isEmpty() || (preferenceMap = PortletPreferencesFactoryImpl.createPreferencesMap(preferences)).isEmpty()) continue;
                long ctCollectionId = resultSet.getLong("ctCollectionId");
                long companyId = resultSet.getLong("companyId");
                long portletPreferencesId = resultSet.getLong("portletPreferencesId");
                for (Preference preference : preferenceMap.values()) {
                    String[] values = preference.getValues();
                    for (int i = 0; i < values.length; ++i) {
                        String value = values[i];
                        String largeValue = null;
                        String smallValue = null;
                        if (value.length() > 255) {
                            largeValue = value;
                        } else {
                            smallValue = value;
                        }
                        insertPreparedStatement.setLong(1, ctCollectionId);
                        insertPreparedStatement.setLong(2, this.increment(PortletPreferenceValue.class.getName()));
                        insertPreparedStatement.setLong(3, companyId);
                        insertPreparedStatement.setLong(4, portletPreferencesId);
                        insertPreparedStatement.setInt(5, i);
                        insertPreparedStatement.setString(6, largeValue);
                        insertPreparedStatement.setString(7, preference.getName());
                        insertPreparedStatement.setBoolean(8, preference.isReadOnly());
                        insertPreparedStatement.setString(9, smallValue);
                        insertPreparedStatement.addBatch();
                    }
                }
            }
            insertPreparedStatement.executeBatch();
        }
        this.alter(PortletPreferencesTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableDropColumn((UpgradeProcess)this, "preferences")});
    }
}

