/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tika.detect.DefaultDetector;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.mime.MimeTypesReaderMetKeys;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class MimeTypesImpl
implements com.liferay.portal.kernel.util.MimeTypes,
MimeTypesReaderMetKeys {
    private static final Log _log = LogFactoryUtil.getLog(MimeTypesImpl.class);
    private final Map<String, Set<String>> _customExtensionsMap = new HashMap<String, Set<String>>();
    private final Detector _detector;
    private final Map<String, Set<String>> _extensionsMap = new HashMap<String, Set<String>>();
    private final Set<String> _webImageMimeTypes;

    public MimeTypesImpl() {
        this._detector = new DefaultDetector(MimeTypes.getDefaultMimeTypes());
        this._webImageMimeTypes = SetUtil.fromArray((Object[])PropsValues.MIME_TYPES_WEB_IMAGES);
    }

    public void afterPropertiesSet() {
        URL url = MimeTypes.class.getResource("tika-mimetypes.xml");
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        URL customMimeTypesURL = classLoader.getResource("tika/custom-mimetypes.xml");
        try {
            this.read(url.openStream(), this._extensionsMap);
            this.read(customMimeTypesURL.openStream(), this._customExtensionsMap);
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to populate extensions map", (Throwable)exception);
        }
    }

    public String getContentType(File file) {
        return this.getContentType(file, file.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getContentType(File file, String fileName) {
        if (file == null) return this.getContentType(fileName);
        if (!file.exists()) {
            return this.getContentType(fileName);
        }
        try (TikaInputStream inputStream = TikaInputStream.get((File)file);){
            String string = this.getContentType((InputStream)inputStream, fileName);
            return string;
        }
        catch (IOException ioException) {
            if (!_log.isWarnEnabled()) return this.getContentType(fileName);
            _log.warn((Object)ioException, (Throwable)ioException);
            return this.getContentType(fileName);
        }
    }

    public String getContentType(InputStream inputStream, String fileName) {
        if (inputStream == null) {
            return this.getContentType(fileName);
        }
        String contentType = null;
        try (TikaInputStream tikaInputStream = TikaInputStream.get((InputStream)new CloseShieldInputStream(inputStream));){
            contentType = this.getCustomContentType(FileUtil.getExtension((String)fileName));
            if ("application/octet-stream".equals(contentType)) {
                Metadata metadata = new Metadata();
                metadata.set("resourceName", HtmlUtil.escapeURL((String)fileName));
                contentType = String.valueOf(this._detector.detect((InputStream)tikaInputStream, metadata));
            }
            if (contentType.contains("tika")) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Retrieved invalid content type " + contentType));
                }
                contentType = this.getContentType(fileName);
            }
            if (contentType.contains("tika")) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Retrieved invalid content type " + contentType));
                }
                contentType = "application/octet-stream";
            }
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            contentType = "application/octet-stream";
        }
        return contentType;
    }

    public String getContentType(String fileName) {
        if (Validator.isNull((String)fileName)) {
            return "application/octet-stream";
        }
        String contentType = null;
        try {
            contentType = this.getCustomContentType(FileUtil.getExtension((String)fileName));
            if ("application/octet-stream".equals(contentType)) {
                Metadata metadata = new Metadata();
                metadata.set("resourceName", HtmlUtil.escapeURL((String)fileName));
                contentType = String.valueOf(this._detector.detect(null, metadata));
            }
            if (!contentType.contains("tika")) {
                return contentType;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Retrieved invalid content type " + contentType));
            }
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
        return "application/octet-stream";
    }

    public String getExtensionContentType(String extension) {
        if (Validator.isNull((String)extension)) {
            return "application/octet-stream";
        }
        return this.getContentType("A.".concat(extension));
    }

    public Set<String> getExtensions(String contentType) {
        Set<String> extensions = this._extensionsMap.get(contentType);
        if (extensions == null) {
            extensions = Collections.emptySet();
        }
        return extensions;
    }

    public boolean isWebImage(String mimeType) {
        return this._webImageMimeTypes.contains(mimeType);
    }

    protected String getCustomContentType(String extension) {
        if (Validator.isNull((String)extension)) {
            return "application/octet-stream";
        }
        for (Map.Entry<String, Set<String>> entry : this._customExtensionsMap.entrySet()) {
            Set<String> set = entry.getValue();
            if (!set.contains(".".concat(extension))) continue;
            return entry.getKey();
        }
        return "application/octet-stream";
    }

    protected void read(InputStream inputStream, Map<String, Set<String>> extensionsMap) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(inputStream));
        Element element = document.getDocumentElement();
        if (element == null || !"mime-info".equals(element.getTagName())) {
            throw new SystemException("Invalid configuration file");
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element childElement;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !"mime-type".equals((childElement = (Element)node).getTagName())) continue;
            this.readMimeType(childElement, extensionsMap);
        }
    }

    protected void readMimeType(Element element, Map<String, Set<String>> extensionsMap) {
        HashSet<String> mimeTypes = new HashSet<String>();
        Set<String> extensions = new HashSet();
        String name = element.getAttribute("type");
        mimeTypes.add(name);
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String extension;
            String pattern;
            boolean regex;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            if ("alias".equals(childElement.getTagName())) {
                String alias = childElement.getAttribute("type");
                mimeTypes.add(alias);
                continue;
            }
            if (!"glob".equals(childElement.getTagName()) || (regex = GetterUtil.getBoolean((String)childElement.getAttribute("isregex"))) || !(pattern = childElement.getAttribute("pattern")).startsWith("*") || (extension = pattern.substring(1)).contains("*") || extension.contains("?") || extension.contains("[")) continue;
            extensions.add(extension);
        }
        if (extensions.isEmpty()) {
            return;
        }
        if (extensions.size() == 1) {
            Iterator iterator = extensions.iterator();
            extensions = Collections.singleton(iterator.next());
        }
        for (String mimeType : mimeTypes) {
            extensionsMap.put(mimeType, extensions);
        }
    }
}

