/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.servlet.DynamicServletRequest;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.spring.context.PortalContextLoaderListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class AsyncPortletServletRequest
extends HttpServletRequestWrapper {
    private static final Set<String> _portalServletURLPatterns = new HashSet<String>(){
        {
            ServletContext servletContext = ServletContextPool.get((String)PortalContextLoaderListener.getPortalServletContextName());
            if (servletContext == null) {
                throw new ExceptionInInitializerError("Portal servlet context is not initialized");
            }
            Map servletRegistrations = servletContext.getServletRegistrations();
            for (ServletRegistration servletRegistration : servletRegistrations.values()) {
                Collection mappings = servletRegistration.getMappings();
                if (mappings == null) continue;
                this.addAll(mappings);
            }
        }
    };
    private String _contextPath;
    private String _pathInfo;
    private String _queryString;
    private String _requestURI;
    private String _servletPath;

    public static AsyncPortletServletRequest getAsyncPortletServletRequest(HttpServletRequest httpServletRequest) {
        while (httpServletRequest instanceof HttpServletRequestWrapper) {
            if (httpServletRequest instanceof AsyncPortletServletRequest) {
                return (AsyncPortletServletRequest)httpServletRequest;
            }
            HttpServletRequestWrapper httpServletRequestWrapper = (HttpServletRequestWrapper)httpServletRequest;
            httpServletRequest = (HttpServletRequest)httpServletRequestWrapper.getRequest();
        }
        return null;
    }

    public AsyncPortletServletRequest(HttpServletRequest httpServletRequest) {
        super(httpServletRequest);
        this._contextPath = httpServletRequest.getContextPath();
        this._pathInfo = httpServletRequest.getPathInfo();
        this._queryString = httpServletRequest.getQueryString();
        this._requestURI = httpServletRequest.getRequestURI();
        this._servletPath = httpServletRequest.getServletPath();
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public DispatcherType getDispatcherType() {
        return DispatcherType.ASYNC;
    }

    public String getPathInfo() {
        return this._pathInfo;
    }

    public String getQueryString() {
        return this._queryString;
    }

    public String getRequestURI() {
        return this._requestURI;
    }

    public String getServletPath() {
        return this._servletPath;
    }

    public void setContextPath(String contextPath) {
        this._contextPath = contextPath;
    }

    public void setPathInfo(String pathInfo) {
        this._pathInfo = pathInfo;
    }

    public void setQueryString(String queryString) {
        this._queryString = queryString;
        this.setRequest((ServletRequest)DynamicServletRequest.addQueryString((HttpServletRequest)((HttpServletRequest)this.getRequest()), (String)queryString, (boolean)true));
    }

    public void setRequestURI(String requestUri) {
        this._requestURI = requestUri;
    }

    public void setServletPath(String servletPath) {
        this._servletPath = servletPath;
    }

    public void update(String contextPath, String path) {
        String pathInfo = null;
        String queryString = null;
        String requestURI = null;
        String servletPath = null;
        if (path != null) {
            if (!contextPath.isEmpty() && path.startsWith(contextPath)) {
                path = path.substring(contextPath.length());
            }
            String pathNoQueryString = path;
            int pos = path.indexOf(63);
            if (pos != -1) {
                pathNoQueryString = path.substring(0, pos);
                queryString = path.substring(pos + 1);
            }
            for (String urlPattern : _portalServletURLPatterns) {
                if (!urlPattern.endsWith("/*")) continue;
                int length = urlPattern.length() - 2;
                if (pathNoQueryString.length() <= length || !pathNoQueryString.regionMatches(0, urlPattern, 0, length) || pathNoQueryString.charAt(length) != '/') continue;
                pathInfo = pathNoQueryString.substring(length);
                servletPath = urlPattern.substring(0, length);
                break;
            }
            if (servletPath == null) {
                servletPath = pathNoQueryString;
            }
            requestURI = contextPath.equals("/") ? pathNoQueryString : contextPath + pathNoQueryString;
        }
        this.setContextPath(contextPath);
        this.setPathInfo(pathInfo);
        this.setQueryString(queryString);
        this.setRequestURI(requestURI);
        this.setServletPath(servletPath);
    }
}

