/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.model.DLVersionNumberIncrease;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.repository.InvalidRepositoryIdException;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.RepositoryProvider;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.model.RepositoryEntry;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEventHierarchyEntryThreadLocal;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.repository.liferayrepository.model.LiferayFolder;
import com.liferay.portal.util.RepositoryUtil;
import com.liferay.portlet.documentlibrary.service.base.DLAppLocalServiceBaseImpl;
import com.liferay.portlet.documentlibrary.util.DLAppUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;

public class DLAppLocalServiceImpl
extends DLAppLocalServiceBaseImpl {
    @BeanReference(type=RepositoryProvider.class)
    protected RepositoryProvider repositoryProvider;
    private static final Log _log = LogFactoryUtil.getLog(DLAppLocalServiceImpl.class);

    @Deprecated
    public FileEntry addFileEntry(long userId, long repositoryId, long folderId, String sourceFileName, String mimeType, byte[] bytes, ServiceContext serviceContext) throws PortalException {
        return this.addFileEntry(null, userId, repositoryId, folderId, sourceFileName, mimeType, sourceFileName, "", "", bytes, null, null, serviceContext);
    }

    @Deprecated
    public FileEntry addFileEntry(long userId, long repositoryId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, byte[] bytes, ServiceContext serviceContext) throws PortalException {
        return this.addFileEntry(null, userId, repositoryId, folderId, sourceFileName, mimeType, title, description, changeLog, bytes, null, null, serviceContext);
    }

    @Deprecated
    public FileEntry addFileEntry(long userId, long repositoryId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, File file, ServiceContext serviceContext) throws PortalException {
        return this.addFileEntry(null, userId, repositoryId, folderId, sourceFileName, mimeType, title, description, changeLog, file, null, null, serviceContext);
    }

    @Deprecated
    public FileEntry addFileEntry(long userId, long repositoryId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, InputStream inputStream, long size, ServiceContext serviceContext) throws PortalException {
        return this.addFileEntry(null, userId, repositoryId, folderId, sourceFileName, mimeType, title, description, changeLog, inputStream, size, null, null, serviceContext);
    }

    public FileEntry addFileEntry(String externalReferenceCode, long userId, long repositoryId, long folderId, String sourceFileName, String mimeType, byte[] bytes, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        return this.addFileEntry(externalReferenceCode, userId, repositoryId, folderId, sourceFileName, mimeType, sourceFileName, "", "", bytes, expirationDate, reviewDate, serviceContext);
    }

    public FileEntry addFileEntry(String externalReferenceCode, long userId, long repositoryId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, byte[] bytes, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        FileEntry fileEntry;
        File file = null;
        try {
            if (ArrayUtil.isNotEmpty((byte[])bytes)) {
                file = FileUtil.createTempFile((byte[])bytes);
            }
            fileEntry = this.addFileEntry(externalReferenceCode, userId, repositoryId, folderId, sourceFileName, mimeType, title, description, changeLog, file, expirationDate, reviewDate, serviceContext);
        }
        catch (IOException ioException) {
            try {
                throw new SystemException("Unable to write temporary file", (Throwable)ioException);
            }
            catch (Throwable throwable) {
                FileUtil.delete(file);
                throw throwable;
            }
        }
        FileUtil.delete((File)file);
        return fileEntry;
    }

    public FileEntry addFileEntry(String externalReferenceCode, long userId, long repositoryId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, File file, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        if (file == null || !file.exists() || file.length() == 0L) {
            return this.addFileEntry(externalReferenceCode, userId, repositoryId, folderId, sourceFileName, mimeType, title, description, changeLog, null, 0L, expirationDate, reviewDate, serviceContext);
        }
        mimeType = DLAppUtil.getMimeType(sourceFileName, mimeType, title, file);
        LocalRepository localRepository = this.getLocalRepository(repositoryId);
        return localRepository.addFileEntry(externalReferenceCode, userId, folderId, sourceFileName, mimeType, title, description, changeLog, file, expirationDate, reviewDate, serviceContext);
    }

    public FileEntry addFileEntry(String externalReferenceCode, long userId, long repositoryId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, InputStream inputStream, long size, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        if (inputStream == null) {
            inputStream = new UnsyncByteArrayInputStream(new byte[0]);
            size = 0L;
        }
        if (Validator.isNull((String)mimeType) || mimeType.equals("application/octet-stream")) {
            if (size == 0L) {
                String extension = DLAppUtil.getExtension(title, sourceFileName);
                mimeType = MimeTypesUtil.getExtensionContentType((String)extension);
            } else {
                File file = null;
                try {
                    file = FileUtil.createTempFile((InputStream)inputStream);
                    FileEntry fileEntry = this.addFileEntry(externalReferenceCode, userId, repositoryId, folderId, sourceFileName, mimeType, title, description, changeLog, file, expirationDate, reviewDate, serviceContext);
                    return fileEntry;
                }
                catch (IOException ioException) {
                    throw new SystemException("Unable to write temporary file", (Throwable)ioException);
                }
                finally {
                    FileUtil.delete((File)file);
                }
            }
        }
        LocalRepository localRepository = this.getLocalRepository(repositoryId);
        return localRepository.addFileEntry(externalReferenceCode, userId, folderId, sourceFileName, mimeType, title, description, changeLog, inputStream, size, expirationDate, reviewDate, serviceContext);
    }

    public FileShortcut addFileShortcut(long userId, long repositoryId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException {
        LocalRepository localRepository = this.getLocalRepository(repositoryId);
        return localRepository.addFileShortcut(userId, folderId, toFileEntryId, serviceContext);
    }

    public Folder addFolder(long userId, long repositoryId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        LocalRepository localRepository = this.getLocalRepository(repositoryId);
        Folder folder = localRepository.addFolder(userId, parentFolderId, name, description, serviceContext);
        this.dlAppHelperLocalService.addFolder(userId, folder, serviceContext);
        return folder;
    }

    public void deleteAll(long repositoryId) throws PortalException {
        this.deleteRepository(this.getLocalRepository(repositoryId));
    }

    public void deleteAllRepositories(long groupId) throws PortalException {
        LocalRepository groupLocalRepository = this.repositoryProvider.getLocalRepository(groupId);
        this.deleteRepository(groupLocalRepository);
        List localRepositories = this.repositoryProvider.getGroupLocalRepositories(groupId);
        for (LocalRepository localRepository : localRepositories) {
            if (localRepository.getRepositoryId() == groupLocalRepository.getRepositoryId()) continue;
            this.deleteRepository(localRepository);
        }
    }

    public void deleteFileEntry(long fileEntryId) throws PortalException {
        LocalRepository localRepository = this.repositoryProvider.getFileEntryLocalRepository(fileEntryId);
        this.dlAppHelperLocalService.deleteFileEntry(localRepository.getFileEntry(fileEntryId));
        localRepository.deleteFileEntry(fileEntryId);
    }

    public void deleteFileShortcut(FileShortcut fileShortcut) throws PortalException {
        this.deleteFileShortcut(fileShortcut.getFileShortcutId());
    }

    public void deleteFileShortcut(long fileShortcutId) throws PortalException {
        LocalRepository localRepository = this.repositoryProvider.getFileShortcutLocalRepository(fileShortcutId);
        localRepository.deleteFileShortcut(fileShortcutId);
    }

    public void deleteFileShortcuts(long toFileEntryId) throws PortalException {
        LocalRepository localRepository = this.repositoryProvider.getFileEntryLocalRepository(toFileEntryId);
        localRepository.deleteFileShortcuts(toFileEntryId);
    }

    public void deleteFileVersion(long fileVersionId) throws PortalException {
        LocalRepository localRepository = this.repositoryProvider.getFileVersionLocalRepository(fileVersionId);
        localRepository.deleteFileVersion(fileVersionId);
    }

    public void deleteFolder(long folderId) throws PortalException {
        LocalRepository localRepository = this.repositoryProvider.getFolderLocalRepository(folderId);
        List fileEntries = localRepository.getRepositoryFileEntries(0L, folderId, -1, -1, null);
        for (FileEntry fileEntry : fileEntries) {
            this.dlAppHelperLocalService.deleteFileEntry(fileEntry);
        }
        Folder folder = this.getFolder(folderId);
        localRepository.deleteFolder(folderId);
        this.dlAppHelperLocalService.deleteFolder(folder);
    }

    public FileEntry getFileEntry(long fileEntryId) throws PortalException {
        LocalRepository localRepository = this.repositoryProvider.getFileEntryLocalRepository(fileEntryId);
        return localRepository.getFileEntry(fileEntryId);
    }

    public FileEntry getFileEntry(long groupId, long folderId, String title) throws PortalException {
        try {
            LocalRepository localRepository = this.getLocalRepository(groupId);
            return localRepository.getFileEntry(folderId, title);
        }
        catch (NoSuchFileEntryException noSuchFileEntryException) {
            if (folderId == 0L) {
                throw noSuchFileEntryException;
            }
            LocalRepository localRepository = this.repositoryProvider.getFolderLocalRepository(folderId);
            return localRepository.getFileEntry(folderId, title);
        }
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public FileEntry getFileEntryByExternalReferenceCode(long groupId, String externalReferenceCode) throws PortalException {
        LocalRepository localRepository = this.getLocalRepository(groupId);
        return localRepository.getFileEntryByExternalReferenceCode(externalReferenceCode);
    }

    public FileEntry getFileEntryByFileName(long groupId, long folderId, String fileName) throws PortalException {
        try {
            LocalRepository localRepository = this.getLocalRepository(groupId);
            return localRepository.getFileEntryByFileName(folderId, fileName);
        }
        catch (NoSuchFileEntryException noSuchFileEntryException) {
            if (folderId == 0L) {
                throw noSuchFileEntryException;
            }
            LocalRepository localRepository = this.repositoryProvider.getFolderLocalRepository(folderId);
            return localRepository.getFileEntryByFileName(folderId, fileName);
        }
    }

    public FileEntry getFileEntryByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        try {
            LocalRepository localRepository = this.getLocalRepository(groupId);
            return localRepository.getFileEntryByUuid(uuid);
        }
        catch (NoSuchFileEntryException noSuchFileEntryException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)noSuchFileEntryException, (Throwable)noSuchFileEntryException);
            }
            List repositories = this.repositoryPersistence.findByGroupId(groupId);
            for (Repository repository : repositories) {
                try {
                    LocalRepository localRepository = this.getLocalRepository(repository.getRepositoryId());
                    return localRepository.getFileEntryByUuid(uuid);
                }
                catch (NoSuchFileEntryException noSuchFileEntryException2) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Object)noSuchFileEntryException2, (Throwable)noSuchFileEntryException2);
                }
            }
            StringBundler sb = new StringBundler(5);
            sb.append("No DLFileEntry exists with the key {uuid=");
            sb.append(uuid);
            sb.append(", groupId=");
            sb.append(groupId);
            sb.append("}");
            throw new NoSuchFileEntryException(sb.toString());
        }
    }

    public FileShortcut getFileShortcut(long fileShortcutId) throws PortalException {
        LocalRepository localRepository = this.repositoryProvider.getFileShortcutLocalRepository(fileShortcutId);
        return localRepository.getFileShortcut(fileShortcutId);
    }

    public FileVersion getFileVersion(long fileVersionId) throws PortalException {
        LocalRepository localRepository = this.repositoryProvider.getFileVersionLocalRepository(fileVersionId);
        return localRepository.getFileVersion(fileVersionId);
    }

    public Folder getFolder(long folderId) throws PortalException {
        LocalRepository localRepository = this.repositoryProvider.getFolderLocalRepository(folderId);
        return localRepository.getFolder(folderId);
    }

    public Folder getFolder(long repositoryId, long parentFolderId, String name) throws PortalException {
        LocalRepository localRepository = this.getLocalRepository(repositoryId);
        return localRepository.getFolder(parentFolderId, name);
    }

    public Folder getMountFolder(long repositoryId) throws PortalException {
        DLFolder dlFolder = this.dlFolderLocalService.getMountFolder(repositoryId);
        return new LiferayFolder(dlFolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileEntry moveFileEntry(long userId, long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException {
        SystemEventHierarchyEntryThreadLocal.push(FileEntry.class);
        try {
            LocalRepository fromLocalRepository = this.repositoryProvider.getFileEntryLocalRepository(fileEntryId);
            LocalRepository toLocalRepository = this.getFolderLocalRepository(newFolderId, serviceContext.getScopeGroupId());
            if (fromLocalRepository.getRepositoryId() == toLocalRepository.getRepositoryId()) {
                FileEntry fileEntry = fromLocalRepository.moveFileEntry(userId, fileEntryId, newFolderId, serviceContext);
                return fileEntry;
            }
            FileEntry fileEntry = this.moveFileEntry(userId, fileEntryId, newFolderId, fromLocalRepository, toLocalRepository, serviceContext);
            return fileEntry;
        }
        finally {
            SystemEventHierarchyEntryThreadLocal.pop(FileEntry.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Folder moveFolder(long userId, long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        SystemEventHierarchyEntryThreadLocal.push(Folder.class);
        try {
            Folder folder;
            Folder toFolder;
            LocalRepository fromLocalRepository = this.repositoryProvider.getFolderLocalRepository(folderId);
            LocalRepository toLocalRepository = this.getFolderLocalRepository(parentFolderId, serviceContext.getScopeGroupId());
            if (parentFolderId != 0L && (toFolder = toLocalRepository.getFolder(parentFolderId)).isMountPoint()) {
                toLocalRepository = this.getLocalRepository(toFolder.getRepositoryId());
            }
            if (fromLocalRepository.getRepositoryId() == toLocalRepository.getRepositoryId()) {
                folder = fromLocalRepository.moveFolder(userId, folderId, parentFolderId, serviceContext);
                return folder;
            }
            folder = this.moveFolder(userId, folderId, parentFolderId, fromLocalRepository, toLocalRepository, serviceContext);
            return folder;
        }
        finally {
            SystemEventHierarchyEntryThreadLocal.pop(Folder.class);
        }
    }

    public void subscribeFileEntryType(long userId, long groupId, long fileEntryTypeId) throws PortalException {
    }

    public void subscribeFolder(long userId, long groupId, long folderId) throws PortalException {
    }

    public void unsubscribeFileEntryType(long userId, long groupId, long fileEntryTypeId) throws PortalException {
    }

    public void unsubscribeFolder(long userId, long groupId, long folderId) throws PortalException {
    }

    public void updateAsset(long userId, FileEntry fileEntry, FileVersion fileVersion, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds) throws PortalException {
        this.dlAppHelperLocalService.updateAsset(userId, fileEntry, fileVersion, assetCategoryIds, assetTagNames, assetLinkEntryIds);
    }

    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, byte[] bytes, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        FileEntry fileEntry;
        File file = null;
        try {
            if (ArrayUtil.isNotEmpty((byte[])bytes)) {
                file = FileUtil.createTempFile((byte[])bytes);
            }
            fileEntry = this.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, dlVersionNumberIncrease, file, expirationDate, reviewDate, serviceContext);
        }
        catch (IOException ioException) {
            try {
                throw new SystemException("Unable to write temporary file", (Throwable)ioException);
            }
            catch (Throwable throwable) {
                FileUtil.delete(file);
                throw throwable;
            }
        }
        FileUtil.delete((File)file);
        return fileEntry;
    }

    @Deprecated
    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, byte[] bytes, ServiceContext serviceContext) throws PortalException {
        return this.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, dlVersionNumberIncrease, bytes, null, null, serviceContext);
    }

    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, File file, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        if (file == null || !file.exists() || file.length() == 0L) {
            return this.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, dlVersionNumberIncrease, null, 0L, expirationDate, reviewDate, serviceContext);
        }
        mimeType = DLAppUtil.getMimeType(sourceFileName, mimeType, title, file);
        LocalRepository localRepository = this.repositoryProvider.getFileEntryLocalRepository(fileEntryId);
        FileEntry fileEntry = localRepository.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, dlVersionNumberIncrease, file, expirationDate, reviewDate, serviceContext);
        this.dlAppHelperLocalService.updateFileEntry(userId, fileEntry, null, fileEntry.getFileVersion(), serviceContext);
        return fileEntry;
    }

    @Deprecated
    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, File file, ServiceContext serviceContext) throws PortalException {
        return this.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, dlVersionNumberIncrease, file, null, null, serviceContext);
    }

    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, InputStream inputStream, long size, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        if (Validator.isNull((String)mimeType) || mimeType.equals("application/octet-stream")) {
            if (size == 0L) {
                String extension = DLAppUtil.getExtension(title, sourceFileName);
                mimeType = MimeTypesUtil.getExtensionContentType((String)extension);
            } else {
                File file = null;
                try {
                    file = FileUtil.createTempFile((InputStream)inputStream);
                    FileEntry fileEntry = this.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, dlVersionNumberIncrease, file, expirationDate, reviewDate, serviceContext);
                    return fileEntry;
                }
                catch (IOException ioException) {
                    throw new SystemException("Unable to write temporary file", (Throwable)ioException);
                }
                finally {
                    FileUtil.delete((File)file);
                }
            }
        }
        LocalRepository localRepository = this.repositoryProvider.getFileEntryLocalRepository(fileEntryId);
        FileEntry fileEntry = localRepository.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, dlVersionNumberIncrease, inputStream, size, expirationDate, reviewDate, serviceContext);
        this.dlAppHelperLocalService.updateFileEntry(userId, fileEntry, null, fileEntry.getFileVersion(), serviceContext);
        return fileEntry;
    }

    @Deprecated
    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, InputStream inputStream, long size, ServiceContext serviceContext) throws PortalException {
        return this.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, dlVersionNumberIncrease, inputStream, size, null, null, serviceContext);
    }

    public FileShortcut updateFileShortcut(long userId, long fileShortcutId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException {
        LocalRepository localRepository = this.repositoryProvider.getFileShortcutLocalRepository(fileShortcutId);
        return localRepository.updateFileShortcut(userId, fileShortcutId, folderId, toFileEntryId, serviceContext);
    }

    public void updateFileShortcuts(long oldToFileEntryId, long newToFileEntryId) throws PortalException {
        LocalRepository localRepository = this.repositoryProvider.getFileEntryLocalRepository(newToFileEntryId);
        localRepository.updateFileShortcuts(oldToFileEntryId, newToFileEntryId);
    }

    public Folder updateFolder(long folderId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        LocalRepository localRepository = this.repositoryProvider.getFolderLocalRepository(folderId);
        Folder folder = localRepository.updateFolder(folderId, parentFolderId, name, description, serviceContext);
        if (folderId != 0L) {
            this.dlAppHelperLocalService.updateFolder(serviceContext.getUserId(), folder, serviceContext);
        }
        return folder;
    }

    protected FileEntry copyFileEntry(long userId, LocalRepository toLocalRepository, FileEntry fileEntry, long newFolderId, ServiceContext serviceContext) throws PortalException {
        List fileVersions = fileEntry.getFileVersions(-1);
        FileVersion latestFileVersion = (FileVersion)fileVersions.get(fileVersions.size() - 1);
        String sourceFileName = DLAppUtil.getSourceFileName(latestFileVersion);
        FileEntry destinationFileEntry = toLocalRepository.addFileEntry(null, userId, newFolderId, sourceFileName, latestFileVersion.getMimeType(), latestFileVersion.getTitle(), latestFileVersion.getDescription(), "", latestFileVersion.getContentStream(false), latestFileVersion.getSize(), latestFileVersion.getExpirationDate(), latestFileVersion.getReviewDate(), serviceContext);
        for (int i = fileVersions.size() - 2; i >= 0; --i) {
            FileVersion fileVersion = (FileVersion)fileVersions.get(i);
            sourceFileName = DLAppUtil.getSourceFileName(fileVersion);
            FileVersion previousFileVersion = (FileVersion)fileVersions.get(i + 1);
            try {
                destinationFileEntry = toLocalRepository.updateFileEntry(userId, destinationFileEntry.getFileEntryId(), sourceFileName, destinationFileEntry.getMimeType(), destinationFileEntry.getTitle(), destinationFileEntry.getDescription(), "", DLVersionNumberIncrease.fromMajorVersion((boolean)DLAppUtil.isMajorVersion(fileVersion, previousFileVersion)), fileVersion.getContentStream(false), fileVersion.getSize(), fileVersion.getExpirationDate(), fileVersion.getReviewDate(), serviceContext);
                continue;
            }
            catch (PortalException portalException) {
                toLocalRepository.deleteFileEntry(destinationFileEntry.getFileEntryId());
                throw portalException;
            }
        }
        return destinationFileEntry;
    }

    protected Folder copyFolder(long userId, long folderId, long parentFolderId, LocalRepository fromLocalRepository, LocalRepository toLocalRepository, ServiceContext serviceContext) throws PortalException {
        Folder newFolder = null;
        try {
            Folder folder = fromLocalRepository.getFolder(folderId);
            newFolder = toLocalRepository.addFolder(userId, parentFolderId, folder.getName(), folder.getDescription(), serviceContext);
            this.dlAppHelperLocalService.addFolder(userId, newFolder, serviceContext);
            this.copyFolderDependencies(userId, folder, newFolder, fromLocalRepository, toLocalRepository, serviceContext);
            return newFolder;
        }
        catch (PortalException portalException) {
            if (newFolder != null) {
                toLocalRepository.deleteFolder(newFolder.getFolderId());
            }
            throw portalException;
        }
    }

    protected void copyFolderDependencies(long userId, Folder sourceFolder, Folder destinationFolder, LocalRepository fromLocalRepository, LocalRepository toLocalRepository, ServiceContext serviceContext) throws PortalException {
        List repositoryEntries = fromLocalRepository.getFoldersAndFileEntriesAndFileShortcuts(sourceFolder.getFolderId(), -1, true, -1, -1, null);
        for (RepositoryEntry repositoryEntry : repositoryEntries) {
            if (repositoryEntry instanceof FileEntry) {
                FileEntry fileEntry = (FileEntry)repositoryEntry;
                this.copyFileEntry(userId, toLocalRepository, fileEntry, destinationFolder.getFolderId(), serviceContext);
                continue;
            }
            if (repositoryEntry instanceof FileShortcut) {
                if (!destinationFolder.isSupportsShortcuts()) continue;
                FileShortcut fileShortcut = (FileShortcut)repositoryEntry;
                toLocalRepository.addFileShortcut(userId, destinationFolder.getFolderId(), fileShortcut.getToFileEntryId(), serviceContext);
                continue;
            }
            if (!(repositoryEntry instanceof Folder)) continue;
            Folder currentFolder = (Folder)repositoryEntry;
            Folder newFolder = toLocalRepository.addFolder(userId, destinationFolder.getFolderId(), currentFolder.getName(), currentFolder.getDescription(), serviceContext);
            this.dlAppHelperLocalService.addFolder(userId, newFolder, serviceContext);
            this.copyFolderDependencies(userId, currentFolder, newFolder, fromLocalRepository, toLocalRepository, serviceContext);
        }
    }

    protected void deleteFileEntry(long oldFileEntryId, long newFileEntryId, LocalRepository fromLocalRepository, LocalRepository toLocalRepository) throws PortalException {
        try {
            FileEntry fileEntry = fromLocalRepository.getFileEntry(oldFileEntryId);
            fromLocalRepository.deleteFileEntry(oldFileEntryId);
            this.dlAppHelperLocalService.deleteFileEntry(fileEntry);
        }
        catch (PortalException portalException) {
            FileEntry fileEntry = toLocalRepository.getFileEntry(newFileEntryId);
            toLocalRepository.deleteFileEntry(newFileEntryId);
            this.dlAppHelperLocalService.deleteFileEntry(fileEntry);
            throw portalException;
        }
    }

    protected void deleteRepository(LocalRepository localRepository) throws PortalException {
        long repositoryId = localRepository.getRepositoryId();
        if (!RepositoryUtil.isExternalRepository(localRepository.getRepositoryId())) {
            this.dlAppHelperLocalService.deleteRepositoryFileEntries(repositoryId);
            localRepository.deleteAll();
        }
        this.repositoryLocalService.deleteRepository(repositoryId);
    }

    protected LocalRepository getFolderLocalRepository(long folderId, long groupId) throws PortalException {
        if (folderId == 0L) {
            return this.getLocalRepository(groupId);
        }
        return this.repositoryProvider.getFolderLocalRepository(folderId);
    }

    protected LocalRepository getLocalRepository(long repositoryId) throws PortalException {
        try {
            return this.repositoryProvider.getLocalRepository(repositoryId);
        }
        catch (InvalidRepositoryIdException invalidRepositoryIdException) {
            StringBundler sb = new StringBundler(3);
            sb.append("No Group exists with the key {repositoryId=");
            sb.append(repositoryId);
            sb.append("}");
            throw new NoSuchGroupException(sb.toString(), (Throwable)invalidRepositoryIdException);
        }
    }

    protected FileEntry moveFileEntry(long userId, long fileEntryId, long newFolderId, LocalRepository fromLocalRepository, LocalRepository toLocalRepository, ServiceContext serviceContext) throws PortalException {
        FileEntry sourceFileEntry = fromLocalRepository.getFileEntry(fileEntryId);
        FileEntry destinationFileEntry = this.copyFileEntry(userId, toLocalRepository, sourceFileEntry, newFolderId, serviceContext);
        this.deleteFileEntry(fileEntryId, destinationFileEntry.getFileEntryId(), fromLocalRepository, toLocalRepository);
        return destinationFileEntry;
    }

    protected Folder moveFolder(long userId, long folderId, long parentFolderId, LocalRepository fromLocalRepository, LocalRepository toLocalRepository, ServiceContext serviceContext) throws PortalException {
        Folder newFolder = this.copyFolder(userId, folderId, parentFolderId, fromLocalRepository, toLocalRepository, serviceContext);
        fromLocalRepository.deleteFolder(folderId);
        return newFolder;
    }
}

