/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.store;

import com.liferay.document.library.kernel.antivirus.AntivirusScannerUtil;
import com.liferay.document.library.kernel.exception.AccessDeniedException;
import com.liferay.document.library.kernel.exception.DirectoryNameException;
import com.liferay.document.library.kernel.store.DLStore;
import com.liferay.document.library.kernel.store.Store;
import com.liferay.document.library.kernel.util.DLValidatorUtil;
import com.liferay.petra.io.StreamUtil;
import com.liferay.petra.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.ByteArrayFileInputStream;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.store.StoreFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class DLStoreImpl
implements DLStore {
    @Deprecated
    protected GroupLocalService groupLocalService;
    private final StoreFactory _storeFactory = StoreFactory.getInstance();

    public void addFile(long companyId, long repositoryId, String fileName, boolean validateFileExtension, byte[] bytes) throws PortalException {
        this.validate(fileName, validateFileExtension);
        if (PropsValues.DL_STORE_ANTIVIRUS_ENABLED) {
            AntivirusScannerUtil.scan((byte[])bytes);
        }
        Store store = this._storeFactory.getStore();
        store.addFile(companyId, repositoryId, fileName, "1.0", (InputStream)new UnsyncByteArrayInputStream(bytes));
    }

    public void addFile(long companyId, long repositoryId, String fileName, boolean validateFileExtension, File file) throws PortalException {
        this.validate(fileName, validateFileExtension);
        if (PropsValues.DL_STORE_ANTIVIRUS_ENABLED) {
            AntivirusScannerUtil.scan((File)file);
        }
        Store store = this._storeFactory.getStore();
        try (FileInputStream inputStream = new FileInputStream(file);){
            store.addFile(companyId, repositoryId, fileName, "1.0", (InputStream)inputStream);
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
    }

    public void addFile(long companyId, long repositoryId, String fileName, boolean validateFileExtension, InputStream inputStream1) throws PortalException {
        block22: {
            if (inputStream1 instanceof ByteArrayFileInputStream) {
                ByteArrayFileInputStream byteArrayFileInputStream = (ByteArrayFileInputStream)inputStream1;
                this.addFile(companyId, repositoryId, fileName, validateFileExtension, byteArrayFileInputStream.getFile());
                return;
            }
            this.validate(fileName, validateFileExtension);
            Store store = this._storeFactory.getStore();
            if (PropsValues.DL_STORE_ANTIVIRUS_ENABLED && AntivirusScannerUtil.isActive()) {
                File tempFile = null;
                try {
                    tempFile = FileUtil.createTempFile();
                    FileUtil.write((File)tempFile, (InputStream)inputStream1);
                    AntivirusScannerUtil.scan((File)tempFile);
                    try (FileInputStream inputStream2 = new FileInputStream(tempFile);){
                        store.addFile(companyId, repositoryId, fileName, "1.0", (InputStream)inputStream2);
                        break block22;
                    }
                }
                catch (IOException ioException) {
                    throw new SystemException("Unable to scan file " + fileName, (Throwable)ioException);
                }
                finally {
                    if (tempFile != null) {
                        tempFile.delete();
                    }
                }
            }
            try {
                store.addFile(companyId, repositoryId, fileName, "1.0", inputStream1);
            }
            catch (AccessDeniedException accessDeniedException) {
                throw new PrincipalException((Throwable)accessDeniedException);
            }
        }
    }

    public void addFile(long companyId, long repositoryId, String fileName, byte[] bytes) throws PortalException {
        this.addFile(companyId, repositoryId, fileName, true, bytes);
    }

    public void addFile(long companyId, long repositoryId, String fileName, File file) throws PortalException {
        this.addFile(companyId, repositoryId, fileName, true, file);
    }

    public void addFile(long companyId, long repositoryId, String fileName, InputStream inputStream) throws PortalException {
        this.addFile(companyId, repositoryId, fileName, true, inputStream);
    }

    public void copyFileVersion(long companyId, long repositoryId, String fileName, String fromVersionLabel, String toVersionLabel) throws PortalException {
        Store store = this._storeFactory.getStore();
        InputStream inputStream = store.getFileAsStream(companyId, repositoryId, fileName, fromVersionLabel);
        if (inputStream == null) {
            inputStream = new UnsyncByteArrayInputStream(new byte[0]);
        }
        store.addFile(companyId, repositoryId, fileName, toVersionLabel, inputStream);
    }

    public void deleteDirectory(long companyId, long repositoryId, String dirName) {
        Store store = this._storeFactory.getStore();
        store.deleteDirectory(companyId, repositoryId, dirName);
    }

    public void deleteFile(long companyId, long repositoryId, String fileName) throws PortalException {
        this.validate(fileName, false);
        Store store = this._storeFactory.getStore();
        for (String versionLabel : store.getFileVersions(companyId, repositoryId, fileName)) {
            store.deleteFile(companyId, repositoryId, fileName, versionLabel);
        }
    }

    public void deleteFile(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        this.validate(fileName, false, versionLabel);
        Store store = this._storeFactory.getStore();
        try {
            store.deleteFile(companyId, repositoryId, fileName, versionLabel);
        }
        catch (AccessDeniedException accessDeniedException) {
            throw new PrincipalException((Throwable)accessDeniedException);
        }
    }

    public byte[] getFileAsBytes(long companyId, long repositoryId, String fileName) throws PortalException {
        this.validate(fileName, false);
        Store store = this._storeFactory.getStore();
        try {
            return StreamUtil.toByteArray((InputStream)store.getFileAsStream(companyId, repositoryId, fileName, ""));
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
    }

    public byte[] getFileAsBytes(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        this.validate(fileName, false, versionLabel);
        Store store = this._storeFactory.getStore();
        try {
            return StreamUtil.toByteArray((InputStream)store.getFileAsStream(companyId, repositoryId, fileName, versionLabel));
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName) throws PortalException {
        this.validate(fileName, false);
        Store store = this._storeFactory.getStore();
        return store.getFileAsStream(companyId, repositoryId, fileName, "");
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        this.validate(fileName, false, versionLabel);
        Store store = this._storeFactory.getStore();
        return store.getFileAsStream(companyId, repositoryId, fileName, versionLabel);
    }

    public String[] getFileNames(long companyId, long repositoryId, String dirName) throws PortalException {
        if (!DLValidatorUtil.isValidName((String)dirName)) {
            throw new DirectoryNameException(dirName);
        }
        Store store = this._storeFactory.getStore();
        return store.getFileNames(companyId, repositoryId, dirName);
    }

    public long getFileSize(long companyId, long repositoryId, String fileName) throws PortalException {
        this.validate(fileName, false);
        Store store = this._storeFactory.getStore();
        return store.getFileSize(companyId, repositoryId, fileName, "");
    }

    public boolean hasFile(long companyId, long repositoryId, String fileName) throws PortalException {
        this.validate(fileName, false);
        Store store = this._storeFactory.getStore();
        return store.hasFile(companyId, repositoryId, fileName, "1.0");
    }

    public boolean hasFile(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        this.validate(fileName, false, versionLabel);
        Store store = this._storeFactory.getStore();
        return store.hasFile(companyId, repositoryId, fileName, versionLabel);
    }

    public void updateFile(long companyId, long repositoryId, long newRepositoryId, String fileName) throws PortalException {
        Store store = this._storeFactory.getStore();
        for (String versionLabel : store.getFileVersions(companyId, repositoryId, fileName)) {
            store.addFile(companyId, newRepositoryId, fileName, versionLabel, store.getFileAsStream(companyId, repositoryId, fileName, versionLabel));
            store.deleteFile(companyId, repositoryId, fileName, versionLabel);
        }
    }

    public void updateFile(long companyId, long repositoryId, String fileName, String fileExtension, boolean validateFileExtension, String versionLabel, String sourceFileName, File file) throws PortalException {
        this.validate(fileName, fileExtension, sourceFileName, validateFileExtension);
        DLValidatorUtil.validateVersionLabel((String)versionLabel);
        if (PropsValues.DL_STORE_ANTIVIRUS_ENABLED) {
            AntivirusScannerUtil.scan((File)file);
        }
        Store store = this._storeFactory.getStore();
        try (FileInputStream inputStream = new FileInputStream(file);){
            store.addFile(companyId, repositoryId, fileName, versionLabel, (InputStream)inputStream);
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
    }

    public void updateFile(long companyId, long repositoryId, String fileName, String fileExtension, boolean validateFileExtension, String versionLabel, String sourceFileName, InputStream inputStream1) throws PortalException {
        block23: {
            this.validate(fileName, fileExtension, sourceFileName, validateFileExtension);
            if (inputStream1 instanceof ByteArrayFileInputStream) {
                ByteArrayFileInputStream byteArrayFileInputStream = (ByteArrayFileInputStream)inputStream1;
                File file = byteArrayFileInputStream.getFile();
                DLValidatorUtil.validateVersionLabel((String)versionLabel);
                if (PropsValues.DL_STORE_ANTIVIRUS_ENABLED) {
                    AntivirusScannerUtil.scan((File)file);
                }
                Store store = this._storeFactory.getStore();
                store.addFile(companyId, repositoryId, fileName, versionLabel, inputStream1);
                return;
            }
            DLValidatorUtil.validateVersionLabel((String)versionLabel);
            Store store = this._storeFactory.getStore();
            if (PropsValues.DL_STORE_ANTIVIRUS_ENABLED && AntivirusScannerUtil.isActive()) {
                File tempFile = null;
                try {
                    tempFile = FileUtil.createTempFile();
                    FileUtil.write((File)tempFile, (InputStream)inputStream1);
                    AntivirusScannerUtil.scan((File)tempFile);
                    try (FileInputStream inputStream = new FileInputStream(tempFile);){
                        store.addFile(companyId, repositoryId, fileName, versionLabel, (InputStream)inputStream);
                        break block23;
                    }
                }
                catch (IOException ioException) {
                    throw new SystemException("Unable to scan file " + fileName, (Throwable)ioException);
                }
                finally {
                    if (tempFile != null) {
                        tempFile.delete();
                    }
                }
            }
            try {
                store.addFile(companyId, repositoryId, fileName, versionLabel, inputStream1);
            }
            catch (AccessDeniedException accessDeniedException) {
                throw new PrincipalException((Throwable)accessDeniedException);
            }
        }
    }

    public void updateFileVersion(long companyId, long repositoryId, String fileName, String fromVersionLabel, String toVersionLabel) throws PortalException {
        Store store = this._storeFactory.getStore();
        InputStream inputStream = store.getFileAsStream(companyId, repositoryId, fileName, fromVersionLabel);
        if (inputStream == null) {
            inputStream = new UnsyncByteArrayInputStream(new byte[0]);
        }
        store.addFile(companyId, repositoryId, fileName, toVersionLabel, inputStream);
        store.deleteFile(companyId, repositoryId, fileName, fromVersionLabel);
    }

    public void validate(String fileName, boolean validateFileExtension) throws PortalException {
        DLValidatorUtil.validateFileName((String)fileName);
        if (validateFileExtension) {
            DLValidatorUtil.validateFileExtension((String)fileName);
        }
    }

    public void validate(String fileName, boolean validateFileExtension, byte[] bytes) throws PortalException {
        this.validate(fileName, validateFileExtension);
        DLValidatorUtil.validateFileSize((String)fileName, (byte[])bytes);
    }

    public void validate(String fileName, boolean validateFileExtension, File file) throws PortalException {
        this.validate(fileName, validateFileExtension);
        DLValidatorUtil.validateFileSize((String)fileName, (File)file);
    }

    public void validate(String fileName, boolean validateFileExtension, InputStream inputStream) throws PortalException {
        this.validate(fileName, validateFileExtension);
        DLValidatorUtil.validateFileSize((String)fileName, (InputStream)inputStream);
    }

    public void validate(String fileName, String fileExtension, String sourceFileName, boolean validateFileExtension) throws PortalException {
        this.validate(fileName, validateFileExtension);
        DLValidatorUtil.validateSourceFileExtension((String)fileExtension, (String)sourceFileName);
    }

    public void validate(String fileName, String fileExtension, String sourceFileName, boolean validateFileExtension, File file) throws PortalException {
        this.validate(fileName, fileExtension, sourceFileName, validateFileExtension);
        DLValidatorUtil.validateFileSize((String)fileName, (File)file);
    }

    public void validate(String fileName, String fileExtension, String sourceFileName, boolean validateFileExtension, InputStream inputStream) throws PortalException {
        this.validate(fileName, fileExtension, sourceFileName, validateFileExtension);
        DLValidatorUtil.validateFileSize((String)fileName, (InputStream)inputStream);
    }

    protected void validate(String fileName, boolean validateFileExtension, String versionLabel) throws PortalException {
        this.validate(fileName, validateFileExtension);
        DLValidatorUtil.validateVersionLabel((String)versionLabel);
    }

    protected void validate(String fileName, String fileExtension, String sourceFileName, boolean validateFileExtension, File file, String versionLabel) throws PortalException {
        this.validate(fileName, fileExtension, sourceFileName, validateFileExtension, file);
        DLValidatorUtil.validateVersionLabel((String)versionLabel);
    }

    protected void validate(String fileName, String fileExtension, String sourceFileName, boolean validateFileExtension, InputStream inputStream, String versionLabel) throws PortalException {
        this.validate(fileName, fileExtension, sourceFileName, validateFileExtension, inputStream);
        DLValidatorUtil.validateVersionLabel((String)versionLabel);
    }
}

