/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.ratings.service.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portlet.ratings.service.base.RatingsStatsLocalServiceBaseImpl;
import com.liferay.ratings.kernel.exception.NoSuchStatsException;
import com.liferay.ratings.kernel.model.RatingsStats;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class RatingsStatsLocalServiceImpl
extends RatingsStatsLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(RatingsStatsLocalServiceImpl.class);

    public RatingsStats addStats(long classNameId, long classPK) {
        RatingsStats stats;
        block3: {
            long statsId = this.counterLocalService.increment();
            stats = this.ratingsStatsPersistence.create(statsId);
            Date now = new Date();
            stats.setCreateDate(now);
            stats.setModifiedDate(now);
            stats.setClassNameId(classNameId);
            stats.setClassPK(classPK);
            stats.setTotalEntries(0);
            stats.setTotalScore(0.0);
            stats.setAverageScore(0.0);
            try {
                stats = (RatingsStats)this.ratingsStatsPersistence.update((BaseModel)stats);
            }
            catch (SystemException systemException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Add failed, fetch {classNameId=", classNameId, ", classPK=", classPK, "}"}));
                }
                if ((stats = this.ratingsStatsPersistence.fetchByC_C(classNameId, classPK, false)) != null) break block3;
                throw systemException;
            }
        }
        return stats;
    }

    public void deleteStats(String className, long classPK) {
        long classNameId;
        block2: {
            classNameId = this.classNameLocalService.getClassNameId(className);
            try {
                this.ratingsStatsPersistence.removeByC_C(classNameId, classPK);
            }
            catch (NoSuchStatsException noSuchStatsException) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)noSuchStatsException, (Throwable)noSuchStatsException);
            }
        }
        this.ratingsEntryPersistence.removeByC_C(classNameId, classPK);
    }

    public RatingsStats fetchStats(String className, long classPK) {
        return this.ratingsStatsPersistence.fetchByC_C(this.classNameLocalService.getClassNameId(className), classPK);
    }

    public RatingsStats getStats(long statsId) throws PortalException {
        return this.ratingsStatsPersistence.findByPrimaryKey(statsId);
    }

    public RatingsStats getStats(String className, long classPK) throws PortalException {
        return this.ratingsStatsPersistence.findByC_C(this.classNameLocalService.getClassNameId(className), classPK);
    }

    public Map<Long, RatingsStats> getStats(String className, long[] classPKs) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        HashMap<Long, RatingsStats> ratingsStats = new HashMap<Long, RatingsStats>();
        for (RatingsStats stats : this.ratingsStatsPersistence.findByC_C(classNameId, classPKs)) {
            ratingsStats.put(stats.getClassPK(), stats);
        }
        return ratingsStats;
    }
}

