/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.usersadmin.search;

import com.liferay.portal.kernel.dao.search.DisplayTerms;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.comparator.GroupDescriptiveNameComparator;
import com.liferay.portal.kernel.util.comparator.GroupNameComparator;
import com.liferay.portal.kernel.util.comparator.GroupTypeComparator;
import com.liferay.portlet.usersadmin.search.GroupDisplayTerms;
import com.liferay.portlet.usersadmin.search.GroupSearchTerms;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;

public class GroupSearch
extends SearchContainer<Group> {
    public static final String EMPTY_RESULTS_MESSAGE = "no-sites-were-found";
    public static List<String> headerNames = new ArrayList<String>(){
        {
            this.add("name");
            this.add("type");
        }
    };
    public static Map<String, String> orderableHeaders = HashMapBuilder.put((Object)"name", (Object)"name").put((Object)"type", (Object)"type").build();
    private static final Log _log = LogFactoryUtil.getLog(GroupSearch.class);

    public GroupSearch(PortletRequest portletRequest, PortletURL iteratorURL) {
        super(portletRequest, (DisplayTerms)new GroupDisplayTerms(portletRequest), (DisplayTerms)new GroupSearchTerms(portletRequest), "cur", DEFAULT_DELTA, iteratorURL, headerNames, EMPTY_RESULTS_MESSAGE);
        GroupDisplayTerms displayTerms = (GroupDisplayTerms)this.getDisplayTerms();
        iteratorURL.setParameter("description", displayTerms.getDescription());
        iteratorURL.setParameter("name", displayTerms.getName());
        try {
            PortalPreferences preferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)portletRequest);
            String portletId = PortletProviderUtil.getPortletId((String)User.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
            String orderByCol = ParamUtil.getString((PortletRequest)portletRequest, (String)"orderByCol");
            String orderByType = ParamUtil.getString((PortletRequest)portletRequest, (String)"orderByType");
            if (Validator.isNotNull((String)orderByCol) && Validator.isNotNull((String)orderByType)) {
                preferences.setValue(portletId, "groups-order-by-col", orderByCol);
                preferences.setValue(portletId, "groups-order-by-type", orderByType);
            } else {
                orderByCol = preferences.getValue(portletId, "groups-order-by-col", "name");
                orderByType = preferences.getValue(portletId, "groups-order-by-type", "asc");
            }
            Locale locale = LocaleUtil.getDefault();
            ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            if (themeDisplay != null) {
                locale = themeDisplay.getLocale();
            }
            OrderByComparator<Group> orderByComparator = this._getGroupOrderByComparator(orderByCol, orderByType, locale);
            this.setOrderableHeaders(orderableHeaders);
            this.setOrderByCol(orderByCol);
            this.setOrderByType(orderByType);
            this.setOrderByComparator(orderByComparator);
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to initialize group search", (Throwable)exception);
        }
    }

    private OrderByComparator<Group> _getGroupOrderByComparator(String orderByCol, String orderByType, Locale locale) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        if (orderByCol.equals("descriptive-name")) {
            return new GroupDescriptiveNameComparator(orderByAsc, locale);
        }
        if (orderByCol.equals("name")) {
            return new GroupNameComparator(orderByAsc, locale);
        }
        if (orderByCol.equals("type")) {
            return new GroupTypeComparator(orderByAsc);
        }
        return new GroupNameComparator(orderByAsc, locale);
    }
}

