/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.license.util.LicenseManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.struts.Action;
import com.liferay.portal.struts.model.ActionForward;
import com.liferay.portal.struts.model.ActionMapping;
import com.liferay.portal.util.LicenseUtil;
import com.liferay.portlet.admin.util.OmniadminUtil;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UpdateLicenseAction
implements Action {
    private static final Log _log = LogFactoryUtil.getLog(UpdateLicenseAction.class);

    @Override
    public ActionForward execute(ActionMapping actionMapping, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (this._isValidRequest(httpServletRequest)) {
            String cmd = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"cmd");
            String clusterNodeId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"clusterNodeId");
            if (cmd.equals("licenseProperties")) {
                String licenseProperties = this._getLicenseProperties(clusterNodeId);
                httpServletResponse.setContentType("application/json");
                ServletResponseUtil.write((HttpServletResponse)httpServletResponse, (String)licenseProperties);
                return null;
            }
            if (cmd.equals("serverInfo")) {
                String serverInfo = this._getServerInfo(clusterNodeId);
                httpServletResponse.setContentType("application/json");
                ServletResponseUtil.write((HttpServletResponse)httpServletResponse, (String)serverInfo);
                return null;
            }
            return actionMapping.getActionForward("portal.license");
        }
        httpServletResponse.sendRedirect(PortalUtil.getPathContext() + "/c/portal/layout");
        return null;
    }

    private String _getLicenseProperties(String clusterNodeId) {
        List licenseProperties = LicenseManagerUtil.getClusterLicenseProperties((String)clusterNodeId);
        if (licenseProperties == null) {
            return "";
        }
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (Map propertiesMap : licenseProperties) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            for (Map.Entry entry : propertiesMap.entrySet()) {
                jsonObject.put((String)entry.getKey(), (String)entry.getValue());
            }
            jsonArray.put(jsonObject);
        }
        return jsonArray.toString();
    }

    private String _getServerInfo(String clusterNodeId) throws Exception {
        Map<String, String> serverInfo = LicenseUtil.getClusterServerInfo(clusterNodeId);
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        if (serverInfo != null) {
            for (Map.Entry<String, String> entry : serverInfo.entrySet()) {
                jsonObject.put(entry.getKey(), entry.getValue());
            }
        }
        return jsonObject.toString();
    }

    private boolean _isOmniAdmin(HttpServletRequest httpServletRequest) {
        User user;
        block2: {
            user = null;
            try {
                user = PortalUtil.getUser((HttpServletRequest)httpServletRequest);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)exception, (Throwable)exception);
            }
        }
        return user != null && OmniadminUtil.isOmniadmin(user);
    }

    private boolean _isValidRequest(HttpServletRequest httpServletRequest) {
        if (this._isOmniAdmin(httpServletRequest)) {
            LicenseUtil.registerOrder(httpServletRequest);
            return true;
        }
        return false;
    }
}

