/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.atom;

import com.liferay.portal.atom.AtomCollectionAdapterWrapper;
import com.liferay.portal.atom.AtomTargetBuilder;
import com.liferay.portal.kernel.atom.AtomCollectionAdapter;
import java.util.Collection;
import org.apache.abdera.protocol.Resolver;
import org.apache.abdera.protocol.server.CollectionAdapter;
import org.apache.abdera.protocol.server.CollectionInfo;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.TargetType;
import org.apache.abdera.protocol.server.WorkspaceInfo;
import org.apache.abdera.protocol.server.impl.AbstractWorkspaceProvider;
import org.apache.abdera.protocol.server.impl.RegexTargetResolver;
import org.apache.abdera.protocol.server.impl.SimpleWorkspaceInfo;

public class AtomProvider
extends AbstractWorkspaceProvider {
    private static final String _COLLECTION_ENTRY_REGEXP = "/api/atom/([^/#?]+)/([^/#?:]+)(\\?[^#]*)?";
    private static final String _COLLECTION_MEDIA_REGEXP = "/api/atom/([^/#?]+)/([^/#?]+):media(\\?[^#]*)?";
    private static final String _COLLECTION_REGEXP = "/api/atom/([^/#?;]+)(\\?[^#]*)?";
    private static final String _SERVICE_REGEXP = "/api/atom?(\\?[^#]*)?";
    private SimpleWorkspaceInfo _workspace;

    public AtomProvider() {
        this._initWorkspace();
        this._initTargetResolver();
        this._initTargetBuilder();
    }

    public <E> void addCollection(AtomCollectionAdapter<E> atomCollectionAdapter) {
        this._workspace.addCollection(new AtomCollectionAdapterWrapper<E>(atomCollectionAdapter));
    }

    public CollectionAdapter getCollectionAdapter(RequestContext request) {
        String path = request.getTargetPath();
        int index = path.indexOf(63);
        if (index != -1) {
            path = path.substring(0, index);
        }
        String baseUriString = String.valueOf(request.getBaseUri());
        for (WorkspaceInfo workspaceInfo : this.workspaces) {
            Collection collections = workspaceInfo.getCollections(request);
            for (CollectionInfo collectionInfo : collections) {
                String href = collectionInfo.getHref(request);
                if (href == null) continue;
                if (href.startsWith(baseUriString)) {
                    href = href.substring(baseUriString.length() - 1);
                }
                if ((index = href.indexOf(63)) != -1) {
                    href = href.substring(0, index);
                }
                if (!path.startsWith(href)) continue;
                return (CollectionAdapter)collectionInfo;
            }
        }
        return null;
    }

    private void _initTargetBuilder() {
        this.setTargetBuilder(new AtomTargetBuilder());
    }

    private void _initTargetResolver() {
        RegexTargetResolver targetResolver = new RegexTargetResolver();
        targetResolver.setPattern(_COLLECTION_ENTRY_REGEXP, TargetType.TYPE_ENTRY, new String[]{"collection", "entry"});
        targetResolver.setPattern(_COLLECTION_MEDIA_REGEXP, TargetType.TYPE_MEDIA, new String[]{"collection", "media"});
        targetResolver.setPattern(_COLLECTION_REGEXP, TargetType.TYPE_COLLECTION, new String[]{"collection"});
        targetResolver.setPattern(_SERVICE_REGEXP, TargetType.TYPE_SERVICE);
        this.setTargetResolver((Resolver)targetResolver);
    }

    private void _initWorkspace() {
        this._workspace = new SimpleWorkspaceInfo();
        this._workspace.setTitle("Liferay Workspace");
        this.addWorkspace((WorkspaceInfo)this._workspace);
    }
}

