/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.sql.transformer;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.sql.transformer.BaseSQLTransformerLogic;
import com.liferay.portal.internal.dao.sql.transformer.SQLFunctionTransformer;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.util.ArrayUtil;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DB2SQLTransformerLogic
extends BaseSQLTransformerLogic {
    private static final Pattern _likePattern = Pattern.compile("LIKE \\?", 2);

    public DB2SQLTransformerLogic(DB db) {
        super(db);
        Object[] functions = new Function[]{this.getBooleanFunction(), this.getCastClobTextFunction(), this.getCastLongFunction(), this.getCastTextFunction(), this.getConcatFunction(), this.getDropTableIfExistsTextFunction(), this.getIntegerDivisionFunction(), this.getNullDateFunction(), this._getLikeFunction()};
        if (!db.isSupportsStringCaseSensitiveQuery()) {
            functions = (Function[])ArrayUtil.append((Object[])functions, this.getLowerFunction());
        }
        this.setFunctions((Function[])functions);
    }

    @Override
    protected Function<String, String> getConcatFunction() {
        SQLFunctionTransformer sqlFunctionTransformer = new SQLFunctionTransformer("CONCAT(", "", " CONCAT ", "");
        return sqlFunctionTransformer::transform;
    }

    @Override
    protected String replaceCastText(Matcher matcher) {
        return matcher.replaceAll("CAST($1 AS VARCHAR(32672))");
    }

    @Override
    protected String replaceDropTableIfExistsText(Matcher matcher) {
        StringBundler sb = new StringBundler(5);
        sb.append("BEGIN\n");
        sb.append("DECLARE CONTINUE HANDLER FOR SQLSTATE '42704'\n");
        sb.append("BEGIN END;\n");
        sb.append("EXECUTE IMMEDIATE 'DROP TABLE $1';\n");
        sb.append("END");
        String dropTableIfExists = sb.toString();
        return matcher.replaceAll(dropTableIfExists);
    }

    private Function<String, String> _getLikeFunction() {
        return sql -> {
            Matcher matcher = _likePattern.matcher((CharSequence)sql);
            return matcher.replaceAll("LIKE COALESCE(CAST(? AS VARCHAR(32672)),'')");
        };
    }
}

