/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.kernel.events.SessionAction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.notifications.ChannelException;
import com.liferay.portal.kernel.notifications.ChannelHubManagerUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import javax.servlet.http.HttpSession;

public class ChannelSessionDestroyAction
extends SessionAction {
    private static final Log _log = LogFactoryUtil.getLog(ChannelSessionDestroyAction.class);

    public void run(HttpSession session) {
        User user = null;
        try {
            user = (User)session.getAttribute("USER");
        }
        catch (IllegalStateException illegalStateException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)illegalStateException, (Throwable)illegalStateException);
            }
            return;
        }
        try {
            Long userId;
            if (user == null && (userId = (Long)session.getAttribute("USER_ID")) != null) {
                user = UserLocalServiceUtil.getUser((long)userId);
            }
            if (user == null || user.isDefaultUser()) {
                return;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Destroying channel " + user.getUserId()));
            }
            try {
                ChannelHubManagerUtil.destroyChannel((long)user.getCompanyId(), (long)user.getUserId());
            }
            catch (ChannelException channelException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("User channel " + user.getUserId() + " is already unregistered"), (Throwable)channelException);
                }
            }
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
    }
}

