/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.fabric.netty.client;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.fabric.netty.fileserver.CompressionLevel;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Properties;

public class NettyFabricClientConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String _id;
    private final Properties _properties;
    private final File _repositoryFolder;

    public NettyFabricClientConfig(String id, Properties properties) {
        this._id = id;
        this._properties = properties;
        this._repositoryFolder = new File(SystemProperties.get((String)"java.io.tmpdir"), "NettyFabricClient-repository-" + id);
    }

    public int getEventLoopGroupThreadCount() {
        return GetterUtil.getInteger((String)this._properties.getProperty("portal.fabric.client.event.loop.group.thread.count"), (int)1);
    }

    public int getExecutionGroupThreadCount() {
        return GetterUtil.getInteger((String)this._properties.getProperty("portal.fabric.client.execution.group.thread.count"), (int)1);
    }

    public int getExecutionTimeout() {
        return GetterUtil.getInteger((String)this._properties.getProperty("portal.fabric.client.execution.timeout"), (int)600000);
    }

    public CompressionLevel getFileServerFolderCompressionLevel() {
        return CompressionLevel.getCompressionLevel(GetterUtil.getInteger((String)this._properties.getProperty("portal.fabric.client.file.server.folder.compression.level"), (int)1));
    }

    public int getFileServerGroupThreadCount() {
        return GetterUtil.getInteger((String)this._properties.getProperty("portal.fabric.client.file.server.group.thread.count"), (int)1);
    }

    public String getNettyFabricServerHost() {
        return GetterUtil.getString((String)this._properties.getProperty("portal.fabric.server.host"), (String)"localhost");
    }

    public int getNettyFabricServerPort() {
        return GetterUtil.getInteger((String)this._properties.getProperty("portal.fabric.server.port"), (int)8923);
    }

    public int getReconnectCount() {
        return GetterUtil.getInteger((String)this._properties.getProperty("portal.fabric.client.reconnect.count"), (int)3);
    }

    public long getReconnectInterval() {
        return GetterUtil.getInteger((String)this._properties.getProperty("portal.fabric.client.reconnect.interval"), (int)10000);
    }

    public long getRepositoryGetFileTimeout() {
        return GetterUtil.getLong((String)this._properties.getProperty("portal.fabric.client.repository.get.file.timeout"), (long)600000L);
    }

    public Path getRepositoryPath() {
        return this._repositoryFolder.toPath();
    }

    public int getRPCGroupThreadCount() {
        return GetterUtil.getInteger((String)this._properties.getProperty("portal.fabric.client.rpc.group.thread.count"), (int)1);
    }

    public long getShutdownQuietPeriod() {
        return GetterUtil.getLong((String)this._properties.getProperty("portal.fabric.shutdown.quiet.period"), (long)1L);
    }

    public long getShutdownTimeout() {
        return GetterUtil.getLong((String)this._properties.getProperty("portal.fabric.shutdown.timeout"), (long)1L);
    }

    public String toString() {
        StringBundler sb = new StringBundler(31);
        sb.append("{eventLoopGroupThreadCount=");
        sb.append(this.getEventLoopGroupThreadCount());
        sb.append(", executionGroupThreadCount=");
        sb.append(this.getExecutionGroupThreadCount());
        sb.append(", executionTimeout=");
        sb.append(this.getExecutionTimeout());
        sb.append(", fileServerFolderCompressionLevel=");
        sb.append((Object)this.getFileServerFolderCompressionLevel());
        sb.append(", fileServerGroupThreadCount=");
        sb.append(this.getFileServerGroupThreadCount());
        sb.append(", id=");
        sb.append(this._id);
        sb.append(", nettyFabricServetHost=");
        sb.append(this.getNettyFabricServerHost());
        sb.append(", nettyFabricServerPort=");
        sb.append(this.getNettyFabricServerPort());
        sb.append(", reconnectCount=");
        sb.append(this.getReconnectCount());
        sb.append(", reconnectInterval=");
        sb.append(this.getReconnectInterval());
        sb.append(", repositoryGetFileTimeout=");
        sb.append(this.getRepositoryGetFileTimeout());
        sb.append(", repositoryPath=");
        sb.append((Object)this.getRepositoryPath());
        sb.append(", rpcGroupThreadCount=");
        sb.append(this.getRPCGroupThreadCount());
        sb.append(", shutdownQuietPeriod=");
        sb.append(this.getShutdownQuietPeriod());
        sb.append(", shutdownTimeout=");
        sb.append(this.getShutdownTimeout());
        sb.append("}");
        return sb.toString();
    }
}

