/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.fabric.netty.fileserver.handlers;

import com.liferay.portal.fabric.netty.fileserver.CompressionLevel;
import com.liferay.portal.fabric.netty.fileserver.FileHelperUtil;
import com.liferay.portal.fabric.netty.fileserver.FileRequest;
import com.liferay.portal.fabric.netty.fileserver.FileResponse;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.SimpleChannelInboundHandler;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;

public class FileRequestChannelHandler
extends SimpleChannelInboundHandler<FileRequest> {
    public static final String NAME = FileRequestChannelHandler.class.getName();
    private final CompressionLevel _compressionLevel;

    public FileRequestChannelHandler(CompressionLevel compressionLevel) {
        this._compressionLevel = compressionLevel;
    }

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, FileRequest fileRequest) throws IOException {
        Path path = fileRequest.getPath();
        BasicFileAttributes basicFileAttributes = null;
        try {
            basicFileAttributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (NoSuchFileException noSuchFileException) {
            channelHandlerContext.writeAndFlush((Object)new FileResponse(path, 0L, -1L, false));
            return;
        }
        FileTime fileTime = basicFileAttributes.lastModifiedTime();
        if (fileTime.toMillis() <= fileRequest.getLastModifiedTime()) {
            channelHandlerContext.writeAndFlush((Object)new FileResponse(path, -1L, -1L, false));
            return;
        }
        FileChannel fileChannel = null;
        if (basicFileAttributes.isDirectory()) {
            fileChannel = FileChannel.open(FileHelperUtil.zip(path, FileHelperUtil.TEMP_DIR_PATH, this._compressionLevel), StandardOpenOption.DELETE_ON_CLOSE);
            if (fileRequest.isDeleteAfterFetch()) {
                FileHelperUtil.delete(path);
            }
        } else {
            fileChannel = fileRequest.isDeleteAfterFetch() ? FileChannel.open(path, StandardOpenOption.DELETE_ON_CLOSE) : FileChannel.open(path, new OpenOption[0]);
        }
        channelHandlerContext.write((Object)new FileResponse(path, fileChannel.size(), fileTime.toMillis(), basicFileAttributes.isDirectory()));
        channelHandlerContext.writeAndFlush((Object)new DefaultFileRegion(fileChannel, 0L, fileChannel.size()));
    }
}

