/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.fabric.netty.rpc;

import com.liferay.petra.concurrent.BaseFutureListener;
import com.liferay.petra.concurrent.FutureListener;
import com.liferay.petra.concurrent.NoticeableFuture;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.fabric.netty.rpc.ChannelThreadLocal;
import com.liferay.portal.fabric.netty.rpc.RPCCallable;
import com.liferay.portal.fabric.netty.rpc.RPCResponse;
import com.liferay.portal.fabric.netty.rpc.RPCSerializable;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Serializable;
import java.util.concurrent.Future;

public class RPCRequest<T extends Serializable>
extends RPCSerializable {
    private static final Log _log = LogFactoryUtil.getLog(RPCRequest.class);
    private static final long serialVersionUID = 1L;
    private final RPCCallable<T> _rpcCallable;

    public RPCRequest(long id, RPCCallable<T> rpcCallable) {
        super(id);
        this._rpcCallable = rpcCallable;
    }

    @Override
    public void execute(final Channel channel) {
        ChannelThreadLocal.setChannel(channel);
        try {
            NoticeableFuture<T> noticeableFuture = this._rpcCallable.call();
            noticeableFuture.addFutureListener((FutureListener)new BaseFutureListener<T>(){

                public void completeWithCancel(Future<T> future) {
                    RPCRequest.this.sendRPCResponse(channel, new RPCResponse<Object>(RPCRequest.this.id, true, null, null));
                }

                public void completeWithException(Future<T> future, Throwable throwable) {
                    RPCRequest.this.sendRPCResponse(channel, new RPCResponse<Object>(RPCRequest.this.id, false, null, throwable));
                }

                public void completeWithResult(Future<T> future, T result) {
                    RPCRequest.this.sendRPCResponse(channel, new RPCResponse(RPCRequest.this.id, false, result, null));
                }
            });
        }
        catch (Throwable throwable) {
            this.sendRPCResponse(channel, new RPCResponse<Object>(this.id, false, null, throwable));
        }
        finally {
            ChannelThreadLocal.removeChannel();
        }
    }

    public String toString() {
        StringBundler sb = new StringBundler(5);
        sb.append("{id=");
        sb.append(this.id);
        sb.append(", rpcCallable=");
        sb.append(this._rpcCallable);
        sb.append("}");
        return sb.toString();
    }

    protected void sendRPCResponse(Channel channel, RPCResponse<T> rpcResponse) {
        ChannelFuture channelFuture = channel.writeAndFlush(rpcResponse);
        channelFuture.addListener((GenericFutureListener)new LogErrorFutureListener(rpcResponse));
    }

    protected static class LogErrorFutureListener
    implements ChannelFutureListener {
        private final RPCResponse<?> _rpcResponse;

        public void operationComplete(ChannelFuture channelFuture) {
            if (channelFuture.isSuccess()) {
                return;
            }
            if (channelFuture.isCancelled()) {
                _log.error((Object)("Cancelled on sending RPC response: " + this._rpcResponse));
                return;
            }
            _log.error((Object)("Unable to send RPC response: " + this._rpcResponse), channelFuture.cause());
        }

        protected LogErrorFutureListener(RPCResponse<?> rpcResponse) {
            this._rpcResponse = rpcResponse;
        }
    }
}

