/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.language;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheHelperUtil;
import com.liferay.portal.kernel.cache.PortalCacheMapSynchronizeUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.language.LanguageWrapper;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LanguageImpl
implements Language,
Serializable {
    private static final String _COMPANY_LOCALES_PORTAL_CACHE_NAME = LanguageImpl.class.getName() + "._companyLocalesPortalCache";
    private static final String _GROUP_LOCALES_PORTAL_CACHE_NAME = LanguageImpl.class.getName() + "._groupLocalesPortalCache";
    private static final double _STORAGE_SIZE_DENOMINATOR = 1024.0;
    private static final Log _log = LogFactoryUtil.getLog(LanguageImpl.class);
    private static final Map<Long, CompanyLocalesBag> _companyLocalesBags = new ConcurrentHashMap<Long, CompanyLocalesBag>();
    private static PortalCache<Long, Serializable> _companyLocalesPortalCache;
    private static PortalCache<Long, Serializable> _groupLocalesPortalCache;
    private static volatile long _lastModified;
    private static final Pattern _pattern;
    private static final PortalCacheMapSynchronizeUtil.Synchronizer<Long, Serializable> _removeSynchronizer;
    private final Map<Long, HashMap<String, Locale>> _groupLanguageCodeLocalesMapMap = new ConcurrentHashMap<Long, HashMap<String, Locale>>();
    private final Map<Long, HashMap<String, Locale>> _groupLanguageIdLocalesMap = new ConcurrentHashMap<Long, HashMap<String, Locale>>();

    public void afterPropertiesSet() {
        _companyLocalesPortalCache = PortalCacheHelperUtil.getPortalCache((String)"MULTI_VM_PORTAL_CACHE_MANAGER", (String)_COMPANY_LOCALES_PORTAL_CACHE_NAME);
        PortalCacheMapSynchronizeUtil.synchronize(_companyLocalesPortalCache, _companyLocalesBags, _removeSynchronizer);
        _groupLocalesPortalCache = PortalCacheHelperUtil.getPortalCache((String)"MULTI_VM_PORTAL_CACHE_MANAGER", (String)_GROUP_LOCALES_PORTAL_CACHE_NAME);
        PortalCacheMapSynchronizeUtil.synchronize(_groupLocalesPortalCache, this._groupLanguageCodeLocalesMapMap, _removeSynchronizer);
        PortalCacheMapSynchronizeUtil.synchronize(_groupLocalesPortalCache, this._groupLanguageIdLocalesMap, _removeSynchronizer);
    }

    public String format(HttpServletRequest httpServletRequest, String pattern, LanguageWrapper argument) {
        return this.format(httpServletRequest, pattern, new LanguageWrapper[]{argument}, true);
    }

    public String format(HttpServletRequest httpServletRequest, String pattern, LanguageWrapper argument, boolean translateArguments) {
        return this.format(httpServletRequest, pattern, new LanguageWrapper[]{argument}, translateArguments);
    }

    public String format(HttpServletRequest httpServletRequest, String pattern, LanguageWrapper[] arguments) {
        return this.format(httpServletRequest, pattern, arguments, true);
    }

    public String format(HttpServletRequest httpServletRequest, String pattern, LanguageWrapper[] arguments, boolean translateArguments) {
        String value;
        block6: {
            if (PropsValues.TRANSLATIONS_DISABLED) {
                return pattern;
            }
            value = null;
            try {
                pattern = this.get(httpServletRequest, pattern);
                if (ArrayUtil.isNotEmpty((Object[])arguments)) {
                    Object[] formattedArguments = new Object[arguments.length];
                    for (int i = 0; i < arguments.length; ++i) {
                        formattedArguments[i] = translateArguments ? StringBundler.concat((String[])new String[]{arguments[i].getBefore(), this.get(httpServletRequest, arguments[i].getText()), arguments[i].getAfter()}) : StringBundler.concat((String[])new String[]{arguments[i].getBefore(), arguments[i].getText(), arguments[i].getAfter()});
                    }
                    value = this._decorateMessageFormat(httpServletRequest, pattern, formattedArguments);
                } else {
                    value = pattern;
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Object)exception, (Throwable)exception);
            }
        }
        return value;
    }

    public String format(HttpServletRequest httpServletRequest, String pattern, Object argument) {
        return this.format(httpServletRequest, pattern, new Object[]{argument}, true);
    }

    public String format(HttpServletRequest httpServletRequest, String pattern, Object argument, boolean translateArguments) {
        return this.format(httpServletRequest, pattern, new Object[]{argument}, translateArguments);
    }

    public String format(HttpServletRequest httpServletRequest, String pattern, Object[] arguments) {
        return this.format(httpServletRequest, pattern, arguments, true);
    }

    public String format(HttpServletRequest httpServletRequest, String pattern, Object[] arguments, boolean translateArguments) {
        String value;
        block6: {
            if (PropsValues.TRANSLATIONS_DISABLED) {
                return pattern;
            }
            value = null;
            try {
                pattern = this.get(httpServletRequest, pattern);
                if (ArrayUtil.isNotEmpty((Object[])arguments)) {
                    for (int i = 0; i < arguments.length; ++i) {
                        if (!translateArguments) continue;
                        arguments[i] = this.get(httpServletRequest, arguments[i].toString());
                    }
                    value = this._decorateMessageFormat(httpServletRequest, pattern, arguments);
                } else {
                    value = pattern;
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Object)exception, (Throwable)exception);
            }
        }
        return value;
    }

    public String format(Locale locale, String pattern, List<Object> arguments) {
        return this.format(locale, pattern, arguments.toArray(), true);
    }

    public String format(Locale locale, String pattern, Object argument) {
        return this.format(locale, pattern, new Object[]{argument}, true);
    }

    public String format(Locale locale, String pattern, Object argument, boolean translateArguments) {
        return this.format(locale, pattern, new Object[]{argument}, translateArguments);
    }

    public String format(Locale locale, String pattern, Object[] arguments) {
        return this.format(locale, pattern, arguments, true);
    }

    public String format(Locale locale, String pattern, Object[] arguments, boolean translateArguments) {
        String value;
        block6: {
            if (PropsValues.TRANSLATIONS_DISABLED) {
                return pattern;
            }
            value = null;
            try {
                pattern = this.get(locale, pattern);
                if (ArrayUtil.isNotEmpty((Object[])arguments)) {
                    for (int i = 0; i < arguments.length; ++i) {
                        if (!translateArguments) continue;
                        arguments[i] = this.get(locale, arguments[i].toString());
                    }
                    value = this._decorateMessageFormat(locale, pattern, arguments);
                } else {
                    value = pattern;
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Object)exception, (Throwable)exception);
            }
        }
        return value;
    }

    public String format(ResourceBundle resourceBundle, String pattern, Object argument) {
        return this.format(resourceBundle, pattern, new Object[]{argument}, true);
    }

    public String format(ResourceBundle resourceBundle, String pattern, Object argument, boolean translateArguments) {
        return this.format(resourceBundle, pattern, new Object[]{argument}, translateArguments);
    }

    public String format(ResourceBundle resourceBundle, String pattern, Object[] arguments) {
        return this.format(resourceBundle, pattern, arguments, true);
    }

    public String format(ResourceBundle resourceBundle, String pattern, Object[] arguments, boolean translateArguments) {
        String value;
        block6: {
            if (PropsValues.TRANSLATIONS_DISABLED) {
                return pattern;
            }
            value = null;
            try {
                pattern = this.get(resourceBundle, pattern);
                if (ArrayUtil.isNotEmpty((Object[])arguments)) {
                    for (int i = 0; i < arguments.length; ++i) {
                        if (!translateArguments) continue;
                        arguments[i] = this.get(resourceBundle, arguments[i].toString());
                    }
                    value = this._decorateMessageFormat(resourceBundle.getLocale(), pattern, arguments);
                } else {
                    value = pattern;
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Object)exception, (Throwable)exception);
            }
        }
        return value;
    }

    public String formatStorageSize(double size, Locale locale) {
        NumberFormat numberFormat = NumberFormat.getInstance(locale);
        numberFormat.setMaximumFractionDigits(0);
        numberFormat.setMinimumFractionDigits(0);
        String suffix = "storage.size.suffix.b";
        if (size >= 1024.0) {
            suffix = "storage.size.suffix.kb";
            size /= 1024.0;
        }
        if (size >= 1024.0) {
            suffix = "storage.size.suffix.mb";
            size /= 1024.0;
            numberFormat.setMaximumFractionDigits(1);
        }
        if (size >= 1024.0) {
            suffix = "storage.size.suffix.gb";
            size /= 1024.0;
        }
        suffix = this.get(locale, suffix);
        return StringBundler.concat((String[])new String[]{numberFormat.format(size), " ", suffix});
    }

    public String get(HttpServletRequest httpServletRequest, ResourceBundle resourceBundle, String key) {
        return this.get(httpServletRequest, resourceBundle, key, key);
    }

    public String get(HttpServletRequest httpServletRequest, ResourceBundle resourceBundle, String key, String defaultValue) {
        String value = this._get(resourceBundle, key);
        if (value != null) {
            return value;
        }
        return this.get(httpServletRequest, key, defaultValue);
    }

    public String get(HttpServletRequest httpServletRequest, String key) {
        return this.get(httpServletRequest, key, key);
    }

    public String get(HttpServletRequest httpServletRequest, String key, String defaultValue) {
        if (httpServletRequest == null || key == null) {
            return defaultValue;
        }
        PortletConfig portletConfig = (PortletConfig)httpServletRequest.getAttribute("javax.portlet.config");
        Locale locale = this._getLocale(httpServletRequest);
        if (portletConfig == null) {
            return this.get(locale, key, defaultValue);
        }
        ResourceBundle resourceBundle = portletConfig.getResourceBundle(locale);
        if (resourceBundle.containsKey(key)) {
            return this._get(resourceBundle, key);
        }
        return this.get(locale, key, defaultValue);
    }

    public String get(Locale locale, String key) {
        return this.get(locale, key, key);
    }

    public String get(Locale locale, String key, String defaultValue) {
        int pos;
        if (PropsValues.TRANSLATIONS_DISABLED) {
            return key;
        }
        if (locale == null || key == null) {
            return defaultValue;
        }
        String value = LanguageResources.getMessage(locale, key);
        if (value != null) {
            return value;
        }
        if (key.length() > 0 && key.charAt(key.length() - 1) == ']' && (pos = key.lastIndexOf(91)) != -1) {
            key = key.substring(0, pos);
            return this.get(locale, key, defaultValue);
        }
        return defaultValue;
    }

    public String get(ResourceBundle resourceBundle, String key) {
        return this.get(resourceBundle, key, key);
    }

    public String get(ResourceBundle resourceBundle, String key, String defaultValue) {
        String value = this._get(resourceBundle, key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public Set<Locale> getAvailableLocales() {
        CompanyLocalesBag companyLocalesBag = LanguageImpl._getCompanyLocalesBag();
        return companyLocalesBag.getAvailableLocales();
    }

    public Set<Locale> getAvailableLocales(long groupId) {
        block4: {
            if (groupId <= 0L) {
                return this.getAvailableLocales();
            }
            try {
                if (this.isInheritLocales(groupId)) {
                    Group group = GroupLocalServiceUtil.getGroup((long)groupId);
                    CompanyLocalesBag companyLocalesBag = LanguageImpl._getCompanyLocalesBag(group.getCompanyId());
                    return companyLocalesBag.getAvailableLocales();
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Object)exception, (Throwable)exception);
            }
        }
        Map<String, Locale> groupLanguageIdLocalesMap = this._getGroupLanguageIdLocalesMap(groupId);
        return new LinkedHashSet<Locale>(groupLanguageIdLocalesMap.values());
    }

    public String getBCP47LanguageId(HttpServletRequest httpServletRequest) {
        return this.getBCP47LanguageId(PortalUtil.getLocale((HttpServletRequest)httpServletRequest));
    }

    public String getBCP47LanguageId(Locale locale) {
        return LocaleUtil.toBCP47LanguageId((Locale)locale);
    }

    public String getBCP47LanguageId(PortletRequest portletRequest) {
        return this.getBCP47LanguageId(PortalUtil.getLocale((PortletRequest)portletRequest));
    }

    public Set<Locale> getCompanyAvailableLocales(long companyId) {
        CompanyLocalesBag companyLocalesBag = LanguageImpl._getCompanyLocalesBag(companyId);
        return companyLocalesBag.getAvailableLocales();
    }

    public String getLanguageId(HttpServletRequest httpServletRequest) {
        CompanyLocalesBag companyLocalesBag;
        String languageId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"languageId");
        if (Validator.isNotNull((String)languageId) && ((companyLocalesBag = LanguageImpl._getCompanyLocalesBag()).containsLanguageCode(languageId) || companyLocalesBag.containsLanguageId(languageId))) {
            return languageId;
        }
        return this.getLanguageId(PortalUtil.getLocale((HttpServletRequest)httpServletRequest, null, (boolean)false));
    }

    public String getLanguageId(Locale locale) {
        return LocaleUtil.toLanguageId((Locale)locale);
    }

    public String getLanguageId(PortletRequest portletRequest) {
        return this.getLanguageId(PortalUtil.getHttpServletRequest((PortletRequest)portletRequest));
    }

    public long getLastModified() {
        return _lastModified;
    }

    public Locale getLocale(long groupId, String languageCode) {
        block3: {
            try {
                if (this.isInheritLocales(groupId)) {
                    return this.getLocale(languageCode);
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)"Unable to check if group inherits locales", (Throwable)exception);
            }
        }
        Map<String, Locale> groupLanguageCodeLocalesMap = this._getGroupLanguageCodeLocalesMap(groupId);
        return groupLanguageCodeLocalesMap.get(languageCode);
    }

    public Locale getLocale(String languageCode) {
        CompanyLocalesBag companyLocalesBag = LanguageImpl._getCompanyLocalesBag();
        return companyLocalesBag.getByLanguageCode(languageCode);
    }

    @Deprecated
    public ResourceBundleLoader getPortalResourceBundleLoader() {
        com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader resourceBundleLoader = this.getResourceBundleLoader();
        return locale -> resourceBundleLoader.loadResourceBundle(locale);
    }

    public com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader getResourceBundleLoader() {
        return LanguageResources.PORTAL_RESOURCE_BUNDLE_LOADER;
    }

    public Set<Locale> getSupportedLocales() {
        CompanyLocalesBag companyLocalesBag = LanguageImpl._getCompanyLocalesBag();
        return companyLocalesBag._supportedLocalesSet;
    }

    public String getTimeDescription(HttpServletRequest httpServletRequest, long milliseconds) {
        return this.getTimeDescription(httpServletRequest, milliseconds, false);
    }

    public String getTimeDescription(HttpServletRequest httpServletRequest, long milliseconds, boolean approximate) {
        String value;
        block3: {
            String description = Time.getDescription((long)milliseconds, (boolean)approximate);
            value = null;
            try {
                String[] parts = description.split(" ", 2);
                String unit = StringUtil.toLowerCase((String)parts[1]);
                if (unit.equals("second")) {
                    unit = unit + "[time]";
                }
                value = this.format(httpServletRequest, "x-" + unit, (Object)parts[0]);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)exception, (Throwable)exception);
            }
        }
        return value;
    }

    public String getTimeDescription(HttpServletRequest httpServletRequest, Long milliseconds) {
        return this.getTimeDescription(httpServletRequest, (long)milliseconds);
    }

    public String getTimeDescription(Locale locale, long milliseconds) {
        return this.getTimeDescription(locale, milliseconds, false);
    }

    public String getTimeDescription(Locale locale, long milliseconds, boolean approximate) {
        String value;
        block3: {
            String description = Time.getDescription((long)milliseconds, (boolean)approximate);
            value = null;
            try {
                String[] parts = description.split(" ", 2);
                String unit = StringUtil.toLowerCase((String)parts[1]);
                if (unit.equals("second")) {
                    unit = unit + "[time]";
                }
                value = this.format(locale, "x-" + unit, (Object)parts[0]);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)exception, (Throwable)exception);
            }
        }
        return value;
    }

    public String getTimeDescription(Locale locale, Long milliseconds) {
        return this.getTimeDescription(locale, (long)milliseconds);
    }

    public void init() {
        _companyLocalesBags.clear();
    }

    public boolean isAvailableLanguageCode(String languageCode) {
        CompanyLocalesBag companyLocalesBag = LanguageImpl._getCompanyLocalesBag();
        return companyLocalesBag.containsLanguageCode(languageCode);
    }

    public boolean isAvailableLocale(Locale locale) {
        if (locale == null) {
            return false;
        }
        return this.isAvailableLocale(LocaleUtil.toLanguageId((Locale)locale));
    }

    public boolean isAvailableLocale(long groupId, Locale locale) {
        if (locale == null) {
            return false;
        }
        return this.isAvailableLocale(groupId, LocaleUtil.toLanguageId((Locale)locale));
    }

    public boolean isAvailableLocale(long groupId, String languageId) {
        block4: {
            if (groupId <= 0L) {
                return this.isAvailableLocale(languageId);
            }
            try {
                if (this.isInheritLocales(groupId)) {
                    Group group = GroupLocalServiceUtil.getGroup((long)groupId);
                    CompanyLocalesBag companyLocalesBag = LanguageImpl._getCompanyLocalesBag(group.getCompanyId());
                    return companyLocalesBag.containsLanguageId(languageId);
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Object)exception, (Throwable)exception);
            }
        }
        Map<String, Locale> groupLanguageIdLocalesMap = this._getGroupLanguageIdLocalesMap(groupId);
        return groupLanguageIdLocalesMap.containsKey(languageId);
    }

    public boolean isAvailableLocale(String languageId) {
        CompanyLocalesBag companyLocalesBag = LanguageImpl._getCompanyLocalesBag();
        return companyLocalesBag.containsLanguageId(languageId);
    }

    public boolean isBetaLocale(Locale locale) {
        CompanyLocalesBag companyLocalesBag = LanguageImpl._getCompanyLocalesBag();
        return companyLocalesBag.isBetaLocale(locale);
    }

    public boolean isDuplicateLanguageCode(String languageCode) {
        CompanyLocalesBag companyLocalesBag = LanguageImpl._getCompanyLocalesBag();
        return companyLocalesBag.isDuplicateLanguageCode(languageCode);
    }

    public boolean isInheritLocales(long groupId) throws PortalException {
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        if (group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        if (!group.isSite() && !group.isDepot() || group.isCompany()) {
            return true;
        }
        return GetterUtil.getBoolean((String)group.getTypeSettingsProperty("inheritLocales"), (boolean)true);
    }

    public boolean isSameLanguage(Locale locale1, Locale locale2) {
        if (locale1 == null || locale2 == null) {
            return false;
        }
        String language1 = locale1.getLanguage();
        String language2 = locale2.getLanguage();
        return language1.equals(language2);
    }

    public String process(Supplier<ResourceBundle> resourceBundleSupplier, Locale locale, String content) {
        StringBundler sb = null;
        ResourceBundle resourceBundle = null;
        Matcher matcher = _pattern.matcher(content);
        int x = 0;
        while (matcher.find()) {
            int y = matcher.start(0);
            String key = matcher.group(1);
            if (sb == null) {
                sb = new StringBundler();
            }
            sb.append(content.substring(x, y));
            sb.append("'");
            if (resourceBundle == null) {
                resourceBundle = resourceBundleSupplier.get();
            }
            String value = this.get(resourceBundle, key);
            sb.append(HtmlUtil.escapeJS((String)value));
            sb.append("'");
            x = matcher.end(0);
        }
        if (sb == null) {
            return content;
        }
        sb.append(content.substring(x));
        return sb.toString();
    }

    public void resetAvailableGroupLocales(long groupId) {
        this._resetAvailableGroupLocales(groupId);
    }

    public void resetAvailableLocales(long companyId) {
        this._resetAvailableLocales(companyId);
    }

    public void updateCookie(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Locale locale) {
        String languageId = LocaleUtil.toLanguageId((Locale)locale);
        Cookie languageIdCookie = new Cookie("GUEST_LANGUAGE_ID", languageId);
        String domain = CookieKeys.getDomain((HttpServletRequest)httpServletRequest);
        if (Validator.isNotNull((String)domain)) {
            languageIdCookie.setDomain(domain);
        }
        languageIdCookie.setMaxAge(31536000);
        languageIdCookie.setPath("/");
        CookieKeys.addCookie((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (Cookie)languageIdCookie);
    }

    private static CompanyLocalesBag _getCompanyLocalesBag() {
        return LanguageImpl._getCompanyLocalesBag(CompanyThreadLocal.getCompanyId());
    }

    private static CompanyLocalesBag _getCompanyLocalesBag(long companyId) {
        CompanyLocalesBag companyLocalesBag = _companyLocalesBags.get(companyId);
        if (companyLocalesBag == null) {
            companyLocalesBag = new CompanyLocalesBag(companyId);
            _companyLocalesBags.put(companyId, companyLocalesBag);
        }
        return companyLocalesBag;
    }

    private ObjectValuePair<HashMap<String, Locale>, HashMap<String, Locale>> _createGroupLocales(long groupId) {
        Locale defaultLocale;
        String[] languageIds;
        block6: {
            languageIds = PropsValues.LOCALES_ENABLED;
            defaultLocale = LocaleUtil.getDefault();
            try {
                Group group = GroupLocalServiceUtil.getGroup((long)groupId);
                defaultLocale = PortalUtil.getSiteDefaultLocale((Group)group);
                UnicodeProperties typeSettingsUnicodeProperties = group.getTypeSettingsProperties();
                String groupLanguageIds = typeSettingsUnicodeProperties.getProperty("locales");
                if (groupLanguageIds != null) {
                    languageIds = StringUtil.split((String)groupLanguageIds);
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block6;
                _log.debug((Object)exception, (Throwable)exception);
            }
        }
        LinkedHashMap<String, Locale> groupLanguageIdLocalesMap = new LinkedHashMap<String, Locale>();
        HashMap groupLanguageCodeLocalesMap = HashMapBuilder.put((Object)defaultLocale.getLanguage(), (Object)defaultLocale).build();
        for (String languageId : languageIds) {
            Locale locale = LocaleUtil.fromLanguageId((String)languageId, (boolean)false);
            String languageCode = languageId;
            int pos = languageId.indexOf(95);
            if (pos > 0) {
                languageCode = languageId.substring(0, pos);
            }
            if (!groupLanguageCodeLocalesMap.containsKey(languageCode)) {
                groupLanguageCodeLocalesMap.put(languageCode, locale);
            }
            groupLanguageIdLocalesMap.put(languageId, locale);
        }
        this._groupLanguageCodeLocalesMapMap.put(groupId, groupLanguageCodeLocalesMap);
        this._groupLanguageIdLocalesMap.put(groupId, groupLanguageIdLocalesMap);
        this._updateLastModified();
        return new ObjectValuePair((Object)groupLanguageCodeLocalesMap, groupLanguageIdLocalesMap);
    }

    private String _decorateMessageFormat(HttpServletRequest httpServletRequest, String pattern, Object[] formattedArguments) {
        return this._decorateMessageFormat(this._getLocale(httpServletRequest), pattern, formattedArguments);
    }

    private String _decorateMessageFormat(Locale locale, String pattern, Object[] formattedArguments) {
        String value;
        if (locale == null) {
            locale = LocaleUtil.getDefault();
        }
        if ((value = this._getFastFormattedMessage(locale, pattern, formattedArguments)) != null) {
            return value;
        }
        pattern = this._escapePattern(pattern);
        MessageFormat messageFormat = new MessageFormat(pattern, locale);
        for (int i = 0; i < formattedArguments.length; ++i) {
            Object formattedArgument = formattedArguments[i];
            if (!(formattedArgument instanceof Number)) continue;
            messageFormat.setFormat(i, NumberFormat.getInstance(locale));
        }
        return messageFormat.format(formattedArguments);
    }

    private String _escapePattern(String pattern) {
        return StringUtil.replace((String)pattern, (char)'\'', (String)"''");
    }

    private String _get(ResourceBundle resourceBundle, String key) {
        int pos;
        if (PropsValues.TRANSLATIONS_DISABLED) {
            return key;
        }
        if (resourceBundle == null || key == null) {
            return null;
        }
        String value = ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)key);
        if (value != null) {
            return value;
        }
        if (key.length() > 0 && key.charAt(key.length() - 1) == ']' && (pos = key.lastIndexOf(91)) != -1) {
            key = key.substring(0, pos);
            return this._get(resourceBundle, key);
        }
        return null;
    }

    private String _getFastFormattedMessage(Locale locale, String pattern, Object[] arguments) {
        Format dateFormat = null;
        NumberFormat numberFormat = null;
        int pos = 0;
        StringBuilder sb = new StringBuilder(16 * arguments.length + pattern.length());
        int start = pattern.indexOf(123);
        while (start != -1) {
            int endIndex = start + 2;
            if (endIndex > pattern.length() || pattern.charAt(endIndex) != '}') {
                return null;
            }
            int argumentIndex = pattern.charAt(start + 1) - 48;
            if (argumentIndex < 0 || arguments.length <= argumentIndex) {
                return null;
            }
            sb.append(pattern, pos, start);
            Object argument = arguments[argumentIndex];
            if (argument instanceof Number) {
                if (numberFormat == null) {
                    numberFormat = NumberFormat.getNumberInstance(locale);
                }
                sb.append(numberFormat.format(argument));
            } else if (argument instanceof Date) {
                if (dateFormat == null) {
                    dateFormat = FastDateFormatFactoryUtil.getDateTime((int)3, (int)1, (Locale)locale, null);
                }
                sb.append(dateFormat.format(argument));
            } else {
                sb.append(argument);
            }
            pos = endIndex + 1;
            start = pattern.indexOf(123, pos);
        }
        if (pos < pattern.length()) {
            sb.append(pattern, pos, pattern.length());
        }
        return sb.toString();
    }

    private Map<String, Locale> _getGroupLanguageCodeLocalesMap(long groupId) {
        Map groupLanguageCodeLocalesMap = this._groupLanguageCodeLocalesMapMap.get(groupId);
        if (groupLanguageCodeLocalesMap == null) {
            ObjectValuePair<HashMap<String, Locale>, HashMap<String, Locale>> objectValuePair = this._createGroupLocales(groupId);
            groupLanguageCodeLocalesMap = (Map)objectValuePair.getKey();
        }
        return groupLanguageCodeLocalesMap;
    }

    private Map<String, Locale> _getGroupLanguageIdLocalesMap(long groupId) {
        Map groupLanguageIdLocalesMap = this._groupLanguageIdLocalesMap.get(groupId);
        if (groupLanguageIdLocalesMap == null) {
            ObjectValuePair<HashMap<String, Locale>, HashMap<String, Locale>> objectValuePair = this._createGroupLocales(groupId);
            groupLanguageIdLocalesMap = (Map)objectValuePair.getValue();
        }
        return groupLanguageIdLocalesMap;
    }

    private Locale _getLocale(HttpServletRequest httpServletRequest) {
        Locale locale = null;
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay != null) {
            locale = themeDisplay.getLocale();
        } else {
            locale = httpServletRequest.getLocale();
            if (!this.isAvailableLocale(locale)) {
                locale = LocaleUtil.getDefault();
            }
        }
        return locale;
    }

    private void _resetAvailableGroupLocales(long groupId) {
        _groupLocalesPortalCache.remove((Serializable)Long.valueOf(groupId));
        this._updateLastModified();
    }

    private void _resetAvailableLocales(long companyId) {
        _companyLocalesPortalCache.remove((Serializable)Long.valueOf(companyId));
        this._updateLastModified();
    }

    private void _updateLastModified() {
        _lastModified = System.currentTimeMillis();
    }

    static {
        _lastModified = System.currentTimeMillis();
        _pattern = Pattern.compile("Liferay\\s*\\.\\s*Language\\s*\\.\\s*get\\s*\\(\\s*[\"']([^)]+)[\"']\\s*\\)", 8);
        _removeSynchronizer = new PortalCacheMapSynchronizeUtil.Synchronizer<Long, Serializable>(){

            public void onSynchronize(Map<? extends Long, ? extends Serializable> map, Long key, Serializable value, int timeToLive) {
                map.remove(key);
            }
        };
    }

    private static class CompanyLocalesBag
    implements Serializable {
        private final Set<Locale> _availableLocales;
        private final Set<String> _duplicateLanguageCodes;
        private final Map<String, Locale> _languageCodeLocalesMap = new HashMap<String, Locale>();
        private final Map<String, Locale> _languageIdLocalesMap = new LinkedHashMap<String, Locale>();
        private final Set<Locale> _localesBetaSet = new HashSet<Locale>();
        private final Set<Locale> _supportedLocalesSet;

        public boolean containsLanguageCode(String languageCode) {
            return this._languageCodeLocalesMap.containsKey(languageCode);
        }

        public boolean containsLanguageId(String languageId) {
            return this._languageIdLocalesMap.containsKey(languageId);
        }

        public Set<Locale> getAvailableLocales() {
            return this._availableLocales;
        }

        public Locale getByLanguageCode(String languageCode) {
            return this._languageCodeLocalesMap.get(languageCode);
        }

        public boolean isBetaLocale(Locale locale) {
            return this._localesBetaSet.contains(locale);
        }

        public boolean isDuplicateLanguageCode(String languageCode) {
            return this._duplicateLanguageCodes.contains(languageCode);
        }

        private CompanyLocalesBag(long companyId) {
            User defaultUser;
            Locale defaultLocale;
            String defaultLanguageId;
            Object[] languageIds = PropsValues.LOCALES;
            if (companyId != 0L) {
                try {
                    languageIds = PrefsPropsUtil.getStringArray(companyId, "locales", ",", PropsValues.LOCALES_ENABLED);
                }
                catch (SystemException systemException) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)systemException, (Throwable)systemException);
                    }
                    languageIds = PropsValues.LOCALES_ENABLED;
                }
            }
            if (!ArrayUtil.contains((Object[])languageIds, (Object)(defaultLanguageId = LocaleUtil.toLanguageId((Locale)(defaultLocale = LocaleUtil.getDefault())))) && (defaultUser = UserLocalServiceUtil.fetchDefaultUser((long)companyId)).getLocale() != null) {
                defaultLocale = defaultUser.getLocale();
                defaultLanguageId = LocaleUtil.toLanguageId((Locale)defaultLocale);
            }
            this._languageCodeLocalesMap.put(defaultLocale.getLanguage(), defaultLocale);
            this._languageIdLocalesMap.put(defaultLanguageId, defaultLocale);
            languageIds = ArrayUtil.remove((String[])languageIds, (String)defaultLanguageId);
            HashSet<String> duplicateLanguageCodes = new HashSet<String>();
            for (Object object : languageIds) {
                Locale locale = LocaleUtil.fromLanguageId((String)object, (boolean)false);
                Object languageCode = object;
                int pos = ((String)object).indexOf(95);
                if (pos > 0) {
                    languageCode = ((String)object).substring(0, pos);
                }
                if (this._languageCodeLocalesMap.containsKey(languageCode)) {
                    duplicateLanguageCodes.add((String)languageCode);
                } else {
                    this._languageCodeLocalesMap.put((String)languageCode, locale);
                }
                this._languageIdLocalesMap.put((String)object, locale);
            }
            this._duplicateLanguageCodes = duplicateLanguageCodes.isEmpty() ? Collections.emptySet() : duplicateLanguageCodes;
            for (String string : PropsValues.LOCALES_BETA) {
                this._localesBetaSet.add(LocaleUtil.fromLanguageId((String)string, (boolean)false));
            }
            this._availableLocales = Collections.unmodifiableSet(new LinkedHashSet<Locale>(this._languageIdLocalesMap.values()));
            HashSet<Locale> supportedLocalesSet = new HashSet<Locale>(this._languageIdLocalesMap.values());
            supportedLocalesSet.removeAll(this._localesBetaSet);
            this._supportedLocalesSet = Collections.unmodifiableSet(supportedLocalesSet);
        }
    }
}

