/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.language;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.language.LanguageBuilderUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.language.ResourceBundleEnumeration;
import com.liferay.registry.Filter;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class LanguageResources {
    public static ResourceBundleLoader PORTAL_RESOURCE_BUNDLE_LOADER = new ResourceBundleLoader(){

        public ResourceBundle loadResourceBundle(Locale locale) {
            return LanguageResources.getResourceBundle(locale);
        }
    };
    @Deprecated
    public static com.liferay.portal.kernel.util.ResourceBundleLoader RESOURCE_BUNDLE_LOADER = new com.liferay.portal.kernel.util.ResourceBundleLoader(){

        public ResourceBundle loadResourceBundle(Locale locale) {
            return LanguageResources.getResourceBundle(locale);
        }
    };
    private static final Log _log = LogFactoryUtil.getLog(LanguageResources.class);
    private static final Locale _blankLocale = new Locale("");
    private static String[] _configNames;
    private static final Map<Locale, Map<String, String>> _languageMaps;
    private static final Locale _nullLocale;
    private static final Map<Locale, Locale> _superLocales;
    private ServiceTracker<ResourceBundle, ResourceBundle> _serviceTracker;

    @Deprecated
    public static String fixValue(String value) {
        return LanguageBuilderUtil.fixValue((String)value);
    }

    @Deprecated
    public static void fixValues(Map<String, String> languageMap, Properties properties) {
        LanguageResources._fixValues(languageMap, properties);
    }

    public static String getMessage(Locale locale, String key) {
        String value;
        if (locale == null) {
            return null;
        }
        Map<String, String> languageMap = _languageMaps.get(locale);
        if (languageMap == null) {
            languageMap = LanguageResources._loadLocale(locale);
        }
        if ((value = languageMap.get(key)) == null) {
            return LanguageResources.getMessage(LanguageResources.getSuperLocale(locale), key);
        }
        return value;
    }

    public static ResourceBundle getResourceBundle(Locale locale) {
        return new LanguageResourcesBundle(locale);
    }

    public static Locale getSuperLocale(Locale locale) {
        Locale superLocale = _superLocales.get(locale);
        if (superLocale != null) {
            if (superLocale == _nullLocale) {
                return null;
            }
            return superLocale;
        }
        superLocale = LanguageResources._getSuperLocale(locale);
        if (superLocale == null) {
            _superLocales.put(locale, _nullLocale);
        } else {
            _superLocales.put(locale, superLocale);
        }
        return superLocale;
    }

    public void afterPropertiesSet() {
        Registry registry = RegistryUtil.getRegistry();
        Filter languageResourceFilter = registry.getFilter("(&(!(javax.portlet.name=*))(language.id=*)(objectClass=" + ResourceBundle.class.getName() + "))");
        this._serviceTracker = registry.trackServices(languageResourceFilter, (ServiceTrackerCustomizer)new LanguageResourceServiceTrackerCustomizer());
        this._serviceTracker.open();
        ResourceBundleLoaderUtil.setPortalResourceBundleLoader((ResourceBundleLoader)PORTAL_RESOURCE_BUNDLE_LOADER);
    }

    public void setConfig(String config) {
        _configNames = StringUtil.split((String)StringUtil.replace((String)config, (char)'.', (char)'/'));
    }

    private static void _fixValues(Map<String, String> languageMap, Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            value = LanguageBuilderUtil.fixValue((String)value);
            languageMap.put(key, value);
        }
    }

    private static Locale _getSuperLocale(Locale locale) {
        String variant = locale.getVariant();
        if (variant.length() > 0) {
            return new Locale(locale.getLanguage(), locale.getCountry());
        }
        String country = locale.getCountry();
        if (country.length() > 0) {
            Locale priorityLocale = LanguageUtil.getLocale((String)locale.getLanguage());
            if (priorityLocale != null) {
                variant = priorityLocale.getVariant();
            }
            if (priorityLocale != null && !locale.equals(priorityLocale) && variant.length() <= 0) {
                return new Locale(priorityLocale.getLanguage(), priorityLocale.getCountry());
            }
            return LocaleUtil.fromLanguageId((String)locale.getLanguage(), (boolean)false, (boolean)true);
        }
        String language = locale.getLanguage();
        if (language.length() > 0) {
            return _blankLocale;
        }
        return null;
    }

    private static Map<String, String> _loadLocale(Locale locale) {
        Map<String, String> languageMap = null;
        if (_configNames.length > 0) {
            String localeName = locale.toString();
            languageMap = new HashMap();
            for (String name : _configNames) {
                StringBundler sb = new StringBundler(4);
                sb.append(name);
                if (localeName.length() > 0) {
                    sb.append("_");
                    sb.append(localeName);
                }
                sb.append(".properties");
                Properties properties = LanguageResources._loadProperties(sb.toString());
                LanguageResources._fixValues(languageMap, properties);
            }
        } else {
            languageMap = Collections.emptyMap();
        }
        _languageMaps.put(locale, languageMap);
        return languageMap;
    }

    private static Properties _loadProperties(String name) {
        Properties properties;
        block15: {
            properties = new Properties();
            try {
                ClassLoader classLoader = LanguageResources.class.getClassLoader();
                Enumeration<URL> enumeration = classLoader.getResources(name);
                if (_log.isDebugEnabled() && !enumeration.hasMoreElements()) {
                    _log.debug((Object)("No resources found for " + name));
                }
                while (enumeration.hasMoreElements()) {
                    URL url = enumeration.nextElement();
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)StringBundler.concat((Object[])new Object[]{"Loading ", name, " from ", url}));
                    }
                    InputStream inputStream = url.openStream();
                    Throwable throwable = null;
                    try {
                        Properties inputStreamProperties = PropertiesUtil.load((InputStream)inputStream, (String)"UTF-8");
                        properties.putAll((Map<?, ?>)inputStreamProperties);
                        if (!_log.isInfoEnabled()) continue;
                        _log.info((Object)StringBundler.concat((Object[])new Object[]{"Loading ", url, " with ", inputStreamProperties.size(), " values"}));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block15;
                _log.warn((Object)exception, (Throwable)exception);
            }
        }
        return properties;
    }

    private static Map<String, String> _putLanguageMap(Locale locale, Map<String, String> languageMap) {
        Map<String, String> oldLanguageMap = _languageMaps.get(locale);
        if (oldLanguageMap == null) {
            LanguageResources._loadLocale(locale);
            oldLanguageMap = _languageMaps.get(locale);
        }
        HashMap<String, String> newLanguageMap = new HashMap<String, String>();
        if (oldLanguageMap != null) {
            newLanguageMap.putAll(oldLanguageMap);
        }
        HashMap<String, String> diffLanguageMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : languageMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            String oldValue = null;
            oldValue = value == null ? (String)newLanguageMap.remove(key) : newLanguageMap.put(key, value);
            diffLanguageMap.put(entry.getKey(), oldValue);
        }
        _languageMaps.put(locale, newLanguageMap);
        return diffLanguageMap;
    }

    static {
        _languageMaps = new ConcurrentHashMap<Locale, Map<String, String>>(64);
        _nullLocale = new Locale("");
        _superLocales = new ConcurrentHashMap<Locale, Locale>();
    }

    private static class LanguageResourceServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<ResourceBundle, ResourceBundle> {
        private final Map<ServiceReference<?>, Map<String, String>> _diffLanguageMap = new HashMap();

        private LanguageResourceServiceTrackerCustomizer() {
        }

        public ResourceBundle addingService(ServiceReference<ResourceBundle> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            ResourceBundle resourceBundle = (ResourceBundle)registry.getService(serviceReference);
            String languageId = GetterUtil.getString((Object)serviceReference.getProperty("language.id"));
            HashMap<String, String> languageMap = new HashMap<String, String>();
            Locale locale = null;
            locale = Validator.isNotNull((String)languageId) ? LocaleUtil.fromLanguageId((String)languageId, (boolean)true) : new Locale("");
            Enumeration<String> enumeration = resourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String key = enumeration.nextElement();
                String value = ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)key);
                languageMap.put(key, value);
            }
            Map diffLanguageMap = LanguageResources._putLanguageMap(locale, languageMap);
            this._diffLanguageMap.put(serviceReference, diffLanguageMap);
            return resourceBundle;
        }

        public void modifiedService(ServiceReference<ResourceBundle> serviceReference, ResourceBundle resourceBundle) {
        }

        public void removedService(ServiceReference<ResourceBundle> serviceReference, ResourceBundle resourceBundle) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            String languageId = GetterUtil.getString((Object)serviceReference.getProperty("language.id"));
            Locale locale = null;
            locale = Validator.isNotNull((String)languageId) ? LocaleUtil.fromLanguageId((String)languageId, (boolean)true) : new Locale("");
            Map<String, String> languageMap = this._diffLanguageMap.remove(serviceReference);
            LanguageResources._putLanguageMap(locale, languageMap);
        }
    }

    private static class LanguageResourcesBundle
    extends ResourceBundle {
        private final Map<String, String> _languageMap;
        private final Locale _locale;

        @Override
        public Enumeration<String> getKeys() {
            Set<String> keySet = this._languageMap.keySet();
            if (this.parent == null) {
                return Collections.enumeration(keySet);
            }
            return new ResourceBundleEnumeration(keySet, this.parent.getKeys());
        }

        @Override
        public Locale getLocale() {
            return this._locale;
        }

        @Override
        protected Object handleGetObject(String key) {
            return this._languageMap.get(key);
        }

        @Override
        protected Set<String> handleKeySet() {
            return this._languageMap.keySet();
        }

        private LanguageResourcesBundle(Locale locale) {
            this._locale = locale;
            Map languageMap = (Map)_languageMaps.get(locale);
            if (languageMap == null) {
                languageMap = LanguageResources._loadLocale(locale);
            }
            this._languageMap = languageMap;
            Locale superLocale = LanguageResources.getSuperLocale(locale);
            if (superLocale != null) {
                this.setParent(new LanguageResourcesBundle(superLocale));
            }
        }
    }
}

