/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.layoutconfiguration.util;

import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.PortletContainerException;
import com.liferay.portal.kernel.portlet.PortletContainerUtil;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.util.StringBundler;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PortletRenderer {
    private static final String _RENDER_PATH = "/html/portal/load_render_portlet.jsp";
    private final Integer _columnCount;
    private final String _columnId;
    private final Integer _columnPos;
    private final Portlet _portlet;

    public PortletRenderer(Portlet portlet, String columnId, Integer columnCount, Integer columnPos) {
        this._portlet = portlet;
        this._columnId = columnId;
        this._columnCount = columnCount;
        this._columnPos = columnPos;
    }

    public Portlet getPortlet() {
        return this._portlet;
    }

    public StringBundler render(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map<String, Object> headerRequestAttributes) throws PortletContainerException {
        httpServletRequest = PortletContainerUtil.setupOptionalRenderParameters((HttpServletRequest)httpServletRequest, null, (String)this._columnId, (Integer)this._columnPos, (Integer)this._columnCount);
        this._copyHeaderRequestAttributes(headerRequestAttributes, httpServletRequest);
        return this._render(httpServletRequest, httpServletResponse);
    }

    public StringBundler renderAjax(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortletContainerException {
        httpServletRequest = PortletContainerUtil.setupOptionalRenderParameters((HttpServletRequest)httpServletRequest, (String)_RENDER_PATH, (String)this._columnId, (Integer)this._columnPos, (Integer)this._columnCount);
        return this._render(httpServletRequest, httpServletResponse);
    }

    public Map<String, Object> renderHeaders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, List<String> attributePrefixes) throws PortletContainerException {
        httpServletRequest = PortletContainerUtil.setupOptionalRenderParameters((HttpServletRequest)httpServletRequest, null, (String)this._columnId, (Integer)this._columnPos, (Integer)this._columnCount);
        BufferCacheServletResponse bufferCacheServletResponse = new BufferCacheServletResponse(httpServletResponse);
        PortletContainerUtil.renderHeaders((HttpServletRequest)httpServletRequest, (HttpServletResponse)bufferCacheServletResponse, (Portlet)this._portlet);
        HashMap<String, Object> headerRequestAttributes = new HashMap<String, Object>();
        Enumeration enumeration = httpServletRequest.getAttributeNames();
        block0: while (enumeration.hasMoreElements()) {
            String attributeName = (String)enumeration.nextElement();
            if (attributeName.contains("javax.portlet.faces.renderResponseOutput")) {
                headerRequestAttributes.put(attributeName, httpServletRequest.getAttribute(attributeName));
                continue;
            }
            if (attributePrefixes == null) continue;
            for (String attributePrefix : attributePrefixes) {
                if (!attributeName.contains(attributePrefix)) continue;
                headerRequestAttributes.put(attributeName, httpServletRequest.getAttribute(attributeName));
                continue block0;
            }
        }
        return headerRequestAttributes;
    }

    private void _copyHeaderRequestAttributes(Map<String, Object> headerRequestAttributes, HttpServletRequest httpServletRequest) {
        if (headerRequestAttributes != null) {
            for (Map.Entry<String, Object> entry : headerRequestAttributes.entrySet()) {
                httpServletRequest.setAttribute(entry.getKey(), entry.getValue());
            }
        }
    }

    private StringBundler _render(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortletContainerException {
        BufferCacheServletResponse bufferCacheServletResponse = new BufferCacheServletResponse(httpServletResponse);
        try {
            PortletContainerUtil.render((HttpServletRequest)httpServletRequest, (HttpServletResponse)bufferCacheServletResponse, (Portlet)this._portlet);
            return bufferCacheServletResponse.getStringBundler();
        }
        catch (IOException ioException) {
            throw new PortletContainerException((Throwable)ioException);
        }
    }
}

