/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.license.util;

import com.liferay.portal.json.JSONObjectImpl;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.license.LicenseInfo;
import com.liferay.portal.kernel.license.util.LicenseManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.SecureRandomUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.LicenseUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class DefaultLicenseManagerImpl
implements LicenseManager {
    private static final Log _log = LogFactoryUtil.getLog(DefaultLicenseManagerImpl.class);

    public void checkLicense(String productId) {
    }

    public List<Map<String, String>> getClusterLicenseProperties(String clusterNodeId) {
        return null;
    }

    public String getHostName() {
        return PortalUtil.getComputerName();
    }

    public Set<String> getIpAddresses() {
        return LicenseUtil.getIpAddresses();
    }

    public LicenseInfo getLicenseInfo(String productId) {
        return null;
    }

    public List<Map<String, String>> getLicenseProperties() {
        return null;
    }

    public Map<String, String> getLicenseProperties(String productId) {
        return null;
    }

    public int getLicenseState(Map<String, String> licenseProperties) {
        String productId = licenseProperties.get("productId");
        if (Validator.isNull((String)productId)) {
            return 0;
        }
        try {
            JSONObjectImpl jsonObject = new JSONObjectImpl();
            byte[] serverIdBytes = LicenseUtil.getServerIdBytes();
            jsonObject.put("cmd", "GET_LICENSE_STATE").put("hostName", this.getHostName()).put("ipAddresses", StringUtil.merge(this.getIpAddresses())).put("macAddresses", StringUtil.merge(this.getMacAddresses())).put("productId", productId);
            String productVersion = licenseProperties.get("productVersion");
            jsonObject.put("productVersion", productVersion);
            String randomUuid = String.valueOf(new UUID(SecureRandomUtil.nextLong(), SecureRandomUtil.nextLong()));
            jsonObject.put("randomUuid", randomUuid).put("serverId", Arrays.toString(serverIdBytes));
            String userCount = licenseProperties.get("userCount");
            jsonObject.put("userCount", userCount).put("version", 2);
            String response = LicenseUtil.sendRequest(jsonObject.toString());
            JSONObjectImpl responseJSONObject = new JSONObjectImpl(response);
            String errorMessage = responseJSONObject.getString("errorMessage");
            if (Validator.isNotNull((String)errorMessage)) {
                throw new Exception(errorMessage);
            }
            String responseRandomUuid = responseJSONObject.getString("randomUuid");
            if (responseRandomUuid.equals(randomUuid)) {
                return responseJSONObject.getInt("licenseState");
            }
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
        return 0;
    }

    public int getLicenseState(String productId) {
        return this.getLicenseState(HashMapBuilder.put((Object)"productId", (Object)productId).build());
    }

    public Set<String> getMacAddresses() {
        return LicenseUtil.getMacAddresses();
    }

    public void registerLicense(JSONObject jsonObject) throws Exception {
        String serverId = jsonObject.getString("serverId");
        if (Validator.isNotNull((String)serverId) && serverId.length() <= 2) {
            return;
        }
        serverId = serverId.substring(1, serverId.length() - 1);
        String[] serverIdArray = StringUtil.split((String)serverId);
        byte[] bytes = new byte[serverIdArray.length];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = Byte.valueOf(serverIdArray[i].trim());
        }
        LicenseUtil.writeServerProperties(bytes);
    }
}

