/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model;

import com.liferay.asset.kernel.util.NotifiedAssetEntryThreadLocal;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetPrototypeLocalServiceUtil;
import com.liferay.portal.kernel.service.persistence.LayoutRevisionUtil;
import com.liferay.portal.kernel.service.persistence.LayoutUtil;
import com.liferay.portal.servlet.filters.cache.CacheUtil;
import java.util.Date;

public class PortletPreferencesModelListener
extends BaseModelListener<PortletPreferences> {
    private static final Log _log = LogFactoryUtil.getLog(PortletPreferencesModelListener.class);

    public void onAfterRemove(PortletPreferences portletPreferences) {
        this.clearCache(portletPreferences);
    }

    public void onAfterUpdate(PortletPreferences portletPreferences) {
        this.clearCache(portletPreferences);
        this.updateLayout(portletPreferences);
    }

    protected void clearCache(PortletPreferences portletPreferences) {
        if (portletPreferences == null) {
            return;
        }
        try {
            long companyId = 0L;
            Layout layout = LayoutUtil.fetchByPrimaryKey((long)portletPreferences.getPlid());
            if (layout != null && !layout.isPrivateLayout()) {
                companyId = layout.getCompanyId();
            } else {
                LayoutRevision layoutRevision = LayoutRevisionUtil.fetchByPrimaryKey((long)portletPreferences.getPlid());
                if (layoutRevision != null && !layoutRevision.isPrivateLayout()) {
                    companyId = layoutRevision.getCompanyId();
                }
            }
            if (companyId > 0L) {
                CacheUtil.clearCache(companyId);
            }
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)exception, (Throwable)exception);
            }
            CacheUtil.clearCache();
        }
    }

    protected void updateLayout(PortletPreferences portletPreferences) {
        try {
            if (portletPreferences.getOwnerType() == 2 && portletPreferences.getOwnerId() > 0L) {
                Group group = GroupLocalServiceUtil.fetchGroup((long)portletPreferences.getOwnerId());
                if (group == null) {
                    return;
                }
                String className = group.getClassName();
                if (!className.equals(LayoutSetPrototype.class.getName())) {
                    return;
                }
                LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.fetchLayoutSetPrototype((long)group.getClassPK());
                if (layoutSetPrototype == null) {
                    return;
                }
                layoutSetPrototype.setModifiedDate(new Date());
                LayoutSetPrototypeLocalServiceUtil.updateLayoutSetPrototype((LayoutSetPrototype)layoutSetPrototype);
            } else if (portletPreferences.getOwnerType() == 3 && portletPreferences.getPlid() > 0L) {
                Layout layout = LayoutLocalServiceUtil.fetchLayout((long)portletPreferences.getPlid());
                if (layout == null || NotifiedAssetEntryThreadLocal.isNotifiedAssetEntryIdsModified()) {
                    return;
                }
                layout.setModifiedDate(new Date());
                LayoutLocalServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layout.getTypeSettings());
            }
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to update the layout's modified date", (Throwable)exception);
        }
    }
}

