/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ColorScheme;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutBranch;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.service.LayoutBranchLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutRevisionLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.ThemeLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.LayoutRevisionBaseImpl;
import com.liferay.portal.model.impl.ThemeSettingImpl;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class LayoutRevisionImpl
extends LayoutRevisionBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(LayoutRevisionImpl.class);
    private UnicodeProperties _typeSettingsUnicodeProperties;

    public List<LayoutRevision> getChildren() {
        return LayoutRevisionLocalServiceUtil.getChildLayoutRevisions((long)this.getLayoutSetBranchId(), (long)this.getLayoutRevisionId(), (long)this.getPlid());
    }

    public ColorScheme getColorScheme() throws PortalException {
        if (this.isInheritLookAndFeel()) {
            return this.getLayoutSet().getColorScheme();
        }
        return ThemeLocalServiceUtil.getColorScheme((long)this.getCompanyId(), (String)this.getTheme().getThemeId(), (String)this.getColorSchemeId());
    }

    public String getCssText() throws PortalException {
        if (this.isInheritLookAndFeel()) {
            return this.getLayoutSet().getCss();
        }
        return this.getCss();
    }

    public String getHTMLTitle(Locale locale) {
        String localeLanguageId = LocaleUtil.toLanguageId((Locale)locale);
        return this.getHTMLTitle(localeLanguageId);
    }

    public String getHTMLTitle(String localeLanguageId) {
        String htmlTitle = this.getTitle(localeLanguageId);
        if (Validator.isNull((String)htmlTitle)) {
            htmlTitle = this.getName(localeLanguageId);
        }
        return htmlTitle;
    }

    public boolean getIconImage() {
        return this.getIconImageId() > 0L;
    }

    public LayoutBranch getLayoutBranch() throws PortalException {
        return LayoutBranchLocalServiceUtil.getLayoutBranch((long)this.getLayoutBranchId());
    }

    public LayoutSet getLayoutSet() throws PortalException {
        return LayoutSetLocalServiceUtil.getLayoutSet((long)this.getGroupId(), (boolean)this.isPrivateLayout());
    }

    public String getRegularURL(HttpServletRequest httpServletRequest) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String portalURL = PortalUtil.getPortalURL((HttpServletRequest)httpServletRequest);
        String url = PortalUtil.getLayoutURL((Layout)LayoutLocalServiceUtil.getLayout((long)this.getPlid()), (ThemeDisplay)themeDisplay);
        if (!CookieKeys.hasSessionId((HttpServletRequest)httpServletRequest) && (url.startsWith(portalURL) || url.startsWith("/"))) {
            HttpSession session = httpServletRequest.getSession();
            url = PortalUtil.getURLWithSessionId((String)url, (String)session.getId());
        }
        return url;
    }

    public String getTarget() {
        String target = this.getTypeSettingsProperty("target");
        if (Validator.isNull((String)target)) {
            return "";
        }
        return "target=\"" + HtmlUtil.escapeAttribute((String)target) + "\"";
    }

    public Theme getTheme() throws PortalException {
        if (this.isInheritLookAndFeel()) {
            return this.getLayoutSet().getTheme();
        }
        return ThemeLocalServiceUtil.getTheme((long)this.getCompanyId(), (String)this.getThemeId());
    }

    public String getThemeSetting(String key, String device) {
        String value;
        block7: {
            block6: {
                UnicodeProperties typeSettingsUnicodeProperties = this.getTypeSettingsProperties();
                value = typeSettingsUnicodeProperties.getProperty(ThemeSettingImpl.namespaceProperty(device, key));
                if (value != null) {
                    return value;
                }
                if (!this.isInheritLookAndFeel()) {
                    try {
                        Theme theme = this.getTheme();
                        return theme.getSetting(key);
                    }
                    catch (Exception exception) {
                        if (!_log.isDebugEnabled()) break block6;
                        _log.debug((Object)exception, (Throwable)exception);
                    }
                }
            }
            try {
                LayoutSet layoutSet = this.getLayoutSet();
                value = layoutSet.getThemeSetting(key, device);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block7;
                _log.debug((Object)exception, (Throwable)exception);
            }
        }
        return value;
    }

    @Override
    public String getTypeSettings() {
        if (this._typeSettingsUnicodeProperties == null) {
            return super.getTypeSettings();
        }
        return this._typeSettingsUnicodeProperties.toString();
    }

    public UnicodeProperties getTypeSettingsProperties() {
        if (this._typeSettingsUnicodeProperties == null) {
            this._typeSettingsUnicodeProperties = new UnicodeProperties(true);
            this._typeSettingsUnicodeProperties.fastLoad(super.getTypeSettings());
        }
        return this._typeSettingsUnicodeProperties;
    }

    public String getTypeSettingsProperty(String key) {
        UnicodeProperties typeSettingsUnicodeProperties = this.getTypeSettingsProperties();
        return typeSettingsUnicodeProperties.getProperty(key);
    }

    public String getTypeSettingsProperty(String key, String defaultValue) {
        UnicodeProperties typeSettingsUnicodeProperties = this.getTypeSettingsProperties();
        return typeSettingsUnicodeProperties.getProperty(key, defaultValue);
    }

    public boolean hasChildren() {
        return !this.getChildren().isEmpty();
    }

    public boolean isContentDisplayPage() {
        UnicodeProperties typeSettingsUnicodeProperties = this.getTypeSettingsProperties();
        String defaultAssetPublisherPortletId = typeSettingsUnicodeProperties.getProperty("default-asset-publisher-portlet-id");
        return Validator.isNotNull((String)defaultAssetPublisherPortletId);
    }

    public boolean isCustomizable() throws PortalException {
        Layout layout = LayoutLocalServiceUtil.getLayout((long)this.getPlid());
        if (!layout.isTypePortlet()) {
            return false;
        }
        if (GetterUtil.getBoolean((String)this.getTypeSettingsProperty("CUSTOMIZABLE_LAYOUT"))) {
            return true;
        }
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        return layoutTypePortlet.isCustomizable();
    }

    public boolean isIconImage() {
        return this.getIconImage();
    }

    public boolean isInheritLookAndFeel() {
        return Validator.isNull((String)this.getThemeId()) || Validator.isNull((String)this.getColorSchemeId());
    }

    @Override
    public void setTypeSettings(String typeSettings) {
        this._typeSettingsUnicodeProperties = null;
        super.setTypeSettings(typeSettings);
    }

    public void setTypeSettingsProperties(UnicodeProperties typeSettingsUnicodeProperties) {
        this._typeSettingsUnicodeProperties = typeSettingsUnicodeProperties;
        super.setTypeSettings(this._typeSettingsUnicodeProperties.toString());
    }
}

