/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.model.PortletDecorator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

public class PortletDecoratorImpl
implements PortletDecorator {
    private String _cssClass;
    private boolean _defaultPortletDecorator;
    private String _name;
    private final String _portletDecoratorId;
    private String _portletDecoratorThumbnailPath = "${images-path}/portlet_decorators/${portlet-decorator-css-class}";

    public PortletDecoratorImpl() {
        this(null, null, null);
    }

    public PortletDecoratorImpl(String portletDecoratorId) {
        this(portletDecoratorId, null, null);
    }

    public PortletDecoratorImpl(String portletDecoratorId, String name, String cssClass) {
        this._portletDecoratorId = portletDecoratorId;
        this._name = name;
        this._cssClass = cssClass;
    }

    public int compareTo(PortletDecorator portletDecorator) {
        return this.getName().compareTo(portletDecorator.getName());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PortletDecorator)) {
            return false;
        }
        PortletDecorator portletDecorator = (PortletDecorator)object;
        return this.getPortletDecoratorId().equals(portletDecorator.getPortletDecoratorId());
    }

    public String getCssClass() {
        return this._cssClass;
    }

    public String getName() {
        if (Validator.isNull((String)this._name)) {
            return this._portletDecoratorId;
        }
        return this._name;
    }

    public String getPortletDecoratorId() {
        return this._portletDecoratorId;
    }

    public String getPortletDecoratorThumbnailPath() {
        int pos;
        if (Validator.isNotNull((String)this._cssClass) && Validator.isNotNull((String)this._portletDecoratorThumbnailPath) && (pos = this._cssClass.indexOf(32)) > 0 && this._portletDecoratorThumbnailPath.endsWith(this._cssClass.substring(0, pos))) {
            String subclassPath = StringUtil.replace((String)this._cssClass, (char)' ', (char)'/');
            return this._portletDecoratorThumbnailPath + subclassPath.substring(pos);
        }
        return this._portletDecoratorThumbnailPath;
    }

    public int hashCode() {
        return this._portletDecoratorId.hashCode();
    }

    public boolean isDefaultPortletDecorator() {
        return this._defaultPortletDecorator;
    }

    public void setCssClass(String cssClass) {
        this._cssClass = cssClass;
    }

    public void setDefaultPortletDecorator(boolean defaultPortletDecorator) {
        this._defaultPortletDecorator = defaultPortletDecorator;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setPortletDecoratorThumbnailPath(String portletDecoratorThumbnailPath) {
        this._portletDecoratorThumbnailPath = portletDecoratorThumbnailPath;
    }
}

