/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.module.framework;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.module.framework.ModuleFramework;
import com.liferay.portal.module.framework.ModuleFrameworkClassLoader;
import com.liferay.portal.util.FileImpl;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.ServiceLoader;

public class ModuleFrameworkUtil {
    private static final ClassLoader _classLoader;
    private static final ModuleFramework _moduleFramework;

    public static long addBundle(String location) throws PortalException {
        return _moduleFramework.addBundle(location);
    }

    public static long addBundle(String location, InputStream inputStream) throws PortalException {
        return _moduleFramework.addBundle(location, inputStream);
    }

    public static URL getBundleResource(long bundleId, String name) {
        return _moduleFramework.getBundleResource(bundleId, name);
    }

    public static Object getFramework() {
        return _moduleFramework.getFramework();
    }

    public static String getState(long bundleId) throws PortalException {
        return _moduleFramework.getState(bundleId);
    }

    public static void initFramework() throws Exception {
        Thread currentThread = Thread.currentThread();
        ClassLoader classLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(_classLoader);
        try {
            _moduleFramework.initFramework();
        }
        finally {
            currentThread.setContextClassLoader(classLoader);
        }
    }

    public static void registerContext(Object context) {
        _moduleFramework.registerContext(context);
    }

    public static void setBundleStartLevel(long bundleId, int startLevel) throws PortalException {
        _moduleFramework.setBundleStartLevel(bundleId, startLevel);
    }

    public static void startBundle(long bundleId) throws PortalException {
        _moduleFramework.startBundle(bundleId);
    }

    public static void startBundle(long bundleId, int options) throws PortalException {
        _moduleFramework.startBundle(bundleId, options);
    }

    public static void startFramework() throws Exception {
        _moduleFramework.startFramework();
    }

    public static void startRuntime() throws Exception {
        _moduleFramework.startRuntime();
    }

    public static void stopBundle(long bundleId) throws PortalException {
        _moduleFramework.stopBundle(bundleId);
    }

    public static void stopBundle(long bundleId, int options) throws PortalException {
        _moduleFramework.stopBundle(bundleId, options);
    }

    public static void stopFramework(long timeout) throws Exception {
        _moduleFramework.stopFramework(timeout);
    }

    public static void stopRuntime() throws Exception {
        _moduleFramework.stopRuntime();
    }

    public static void uninstallBundle(long bundleId) throws PortalException {
        _moduleFramework.uninstallBundle(bundleId);
    }

    public static void unregisterContext(Object context) {
        _moduleFramework.unregisterContext(context);
    }

    public static void updateBundle(long bundleId) throws PortalException {
        _moduleFramework.updateBundle(bundleId);
    }

    public static void updateBundle(long bundleId, InputStream inputStream) throws PortalException {
        _moduleFramework.updateBundle(bundleId, inputStream);
    }

    static {
        try {
            File coreDir;
            File[] files;
            if (FileUtil.getFile() == null) {
                FileUtil fileUtil = new FileUtil();
                fileUtil.setFile((com.liferay.portal.kernel.util.File)new FileImpl());
            }
            if ((files = (coreDir = new File(PropsValues.MODULE_FRAMEWORK_BASE_DIR, "core")).listFiles()) == null) {
                throw new IllegalStateException("Missing " + coreDir.getCanonicalPath());
            }
            URL[] urls = new URL[files.length];
            Object[] packageNames = new String[files.length + 4];
            for (int i = 0; i < urls.length; ++i) {
                File file = files[i];
                URI uri = file.toURI();
                urls[i] = uri.toURL();
                String name = file.getName();
                if (name.endsWith(".jar")) {
                    name = name.substring(0, name.length() - 3);
                }
                if (name.endsWith(".api.")) {
                    name = name.substring(0, name.length() - 4);
                }
                if (name.endsWith(".impl.")) {
                    name = name.substring(0, name.length() - 5);
                    name = name.concat("internal.");
                }
                packageNames[i] = name;
            }
            packageNames[files.length] = "org.apache.felix.resolver.";
            packageNames[files.length + 1] = "org.eclipse.core.";
            packageNames[files.length + 2] = "org.eclipse.equinox.";
            packageNames[files.length + 3] = "org.osgi.";
            Arrays.sort(packageNames);
            _classLoader = new ModuleFrameworkClassLoader(urls, PortalClassLoaderUtil.getClassLoader(), (String[])packageNames);
        }
        catch (IOException ioException) {
            throw new ExceptionInInitializerError(ioException);
        }
        ServiceLoader<ModuleFramework> serviceLoader = ServiceLoader.load(ModuleFramework.class, _classLoader);
        Iterator<ModuleFramework> iterator = serviceLoader.iterator();
        if (!iterator.hasNext()) {
            throw new ExceptionInInitializerError("Unable to locate module framework implementation");
        }
        _moduleFramework = iterator.next();
    }
}

