/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search;

import com.liferay.portal.kernel.aop.AopMethodInvocation;
import com.liferay.portal.kernel.aop.ChainableMethodAdvice;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.IndexWriterHelperUtil;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;

public class IndexableAdvice
extends ChainableMethodAdvice {
    private static final Log _log = LogFactoryUtil.getLog(IndexableAdvice.class);

    public Object createMethodContext(Class<?> targetClass, Method method, Map<Class<? extends Annotation>, Annotation> annotations) {
        Indexable indexable = (Indexable)annotations.get(Indexable.class);
        if (indexable == null) {
            return null;
        }
        Class<?> returnType = method.getReturnType();
        if (!BaseModel.class.isAssignableFrom(returnType)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)(method + " does not have a valid return type"));
            }
            return null;
        }
        return new IndexableContext(returnType.getName(), indexable.type(), this._getServiceContextParameterIndex(method));
    }

    protected void afterReturning(AopMethodInvocation aopMethodInvocation, Object[] arguments, Object result) throws Throwable {
        ServiceContext serviceContext;
        if (result == null) {
            return;
        }
        if (CompanyThreadLocal.isDeleteInProcess() || IndexWriterHelperUtil.isIndexReadOnly()) {
            if (_log.isDebugEnabled()) {
                if (CompanyThreadLocal.isDeleteInProcess()) {
                    _log.debug((Object)"Skip indexing because company delete is in process");
                } else if (IndexWriterHelperUtil.isIndexReadOnly()) {
                    _log.debug((Object)"Skip indexing because the index is read only");
                }
            }
            return;
        }
        IndexableContext indexableContext = (IndexableContext)aopMethodInvocation.getAdviceMethodContext();
        String name = indexableContext._name;
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)name);
        if (indexer == null) {
            return;
        }
        if (IndexWriterHelperUtil.isIndexReadOnly((String)indexer.getClassName())) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Skipping indexing read only index for " + indexer.getClassName()));
            }
            return;
        }
        int serviceContextIndex = indexableContext._serviceContextIndex;
        if (serviceContextIndex >= 0 && (serviceContext = (ServiceContext)arguments[serviceContextIndex]) != null && !serviceContext.isIndexingEnabled()) {
            return;
        }
        if (indexableContext._indexableType == IndexableType.DELETE) {
            indexer.delete(result);
        } else {
            indexer.reindex(result);
        }
    }

    private int _getServiceContextParameterIndex(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = parameterTypes.length - 1; i >= 0; --i) {
            if (!ServiceContext.class.isAssignableFrom(parameterTypes[i])) continue;
            return i;
        }
        return -1;
    }

    private static class IndexableContext {
        private final IndexableType _indexableType;
        private final String _name;
        private final int _serviceContextIndex;

        private IndexableContext(String name, IndexableType indexableType, int serviceContextIndex) {
            this._name = name;
            this._indexableType = indexableType;
            this._serviceContextIndex = serviceContextIndex;
        }
    }
}

