/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.security.auth.AuthToken;
import com.liferay.portal.kernel.security.auth.AuthTokenWhitelistUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PwdGenerator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.SecurityPortletContainerWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;

public class SessionAuthToken
implements AuthToken {
    private static final String _CSRF = "#CSRF";
    private static final Log _log = LogFactoryUtil.getLog(SessionAuthToken.class);

    public void addCSRFToken(HttpServletRequest httpServletRequest, LiferayPortletURL liferayPortletURL) {
        if (!PropsValues.AUTH_TOKEN_CHECK_ENABLED) {
            return;
        }
        String lifecycle = liferayPortletURL.getLifecycle();
        if (!lifecycle.equals("ACTION_PHASE")) {
            return;
        }
        if (AuthTokenWhitelistUtil.isPortletURLCSRFWhitelisted((LiferayPortletURL)liferayPortletURL)) {
            return;
        }
        liferayPortletURL.setParameter("p_auth", this.getToken(httpServletRequest));
    }

    public void addPortletInvocationToken(HttpServletRequest httpServletRequest, LiferayPortletURL liferayPortletURL) {
        long plid;
        String portletId;
        block7: {
            if (!PropsValues.PORTLET_ADD_DEFAULT_RESOURCE_CHECK_ENABLED) {
                return;
            }
            long companyId = PortalUtil.getCompanyId((HttpServletRequest)httpServletRequest);
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)(portletId = liferayPortletURL.getPortletId()));
            if (portlet == null) {
                return;
            }
            if (!portlet.isAddDefaultResource()) {
                return;
            }
            if (AuthTokenWhitelistUtil.isPortletURLPortletInvocationWhitelisted((LiferayPortletURL)liferayPortletURL)) {
                return;
            }
            plid = liferayPortletURL.getPlid();
            try {
                Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
                LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
                if (layoutTypePortlet.hasPortletId(portletId)) {
                    return;
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block7;
                _log.debug((Object)exception.getMessage(), (Throwable)exception);
            }
        }
        liferayPortletURL.setParameter("p_p_auth", this.getToken(httpServletRequest, plid, portletId));
    }

    public void checkCSRFToken(HttpServletRequest httpServletRequest, String origin) throws PrincipalException {
        String sessionToken;
        String ppid;
        Portlet portlet;
        if (!PropsValues.AUTH_TOKEN_CHECK_ENABLED) {
            return;
        }
        String sharedSecret = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_auth_secret");
        if (AuthTokenWhitelistUtil.isValidSharedSecret((String)sharedSecret)) {
            return;
        }
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)httpServletRequest);
        if (AuthTokenWhitelistUtil.isOriginCSRFWhitelisted((long)companyId, (String)origin)) {
            return;
        }
        if (origin.equals(SecurityPortletContainerWrapper.class.getName()) && AuthTokenWhitelistUtil.isPortletCSRFWhitelisted((HttpServletRequest)httpServletRequest, (Portlet)(portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)(ppid = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_p_id")))))) {
            return;
        }
        String csrfToken = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_auth");
        if (Validator.isNull((String)csrfToken)) {
            csrfToken = GetterUtil.getString((String)httpServletRequest.getHeader("X-CSRF-Token"));
        }
        if (!csrfToken.equals(sessionToken = this.getSessionAuthenticationToken(httpServletRequest, _CSRF, false))) {
            throw new PrincipalException.MustHaveValidCSRFToken(PortalUtil.getUserId((HttpServletRequest)httpServletRequest), origin);
        }
    }

    public String getToken(HttpServletRequest httpServletRequest) {
        return this.getSessionAuthenticationToken(httpServletRequest, _CSRF, true);
    }

    public String getToken(HttpServletRequest httpServletRequest, long plid, String portletId) {
        return this.getSessionAuthenticationToken(httpServletRequest, PortletPermissionUtil.getPrimaryKey((long)plid, (String)portletId), true);
    }

    public boolean isValidPortletInvocationToken(HttpServletRequest httpServletRequest, Layout layout, Portlet portlet) {
        String key;
        String sessionToken;
        if (AuthTokenWhitelistUtil.isPortletInvocationWhitelisted((HttpServletRequest)httpServletRequest, (Portlet)portlet)) {
            return true;
        }
        String portletToken = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_p_auth");
        if (Validator.isNull((String)portletToken)) {
            HttpServletRequest originalHttpServletRequest = PortalUtil.getOriginalServletRequest((HttpServletRequest)httpServletRequest);
            portletToken = ParamUtil.getString((HttpServletRequest)originalHttpServletRequest, (String)"p_p_auth");
        }
        return Validator.isNotNull((String)portletToken) && Validator.isNotNull((String)(sessionToken = this.getSessionAuthenticationToken(httpServletRequest, key = PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portlet.getPortletId()), false))) && sessionToken.equals(portletToken);
    }

    protected String getSessionAuthenticationToken(HttpServletRequest httpServletRequest, String key, boolean createToken) {
        String sessionAuthenticationToken = null;
        HttpServletRequest currentHttpServletRequest = httpServletRequest;
        HttpSession session = null;
        String tokenKey = "LIFERAY_SHARED_AUTHENTICATION_TOKEN".concat(key);
        while (currentHttpServletRequest instanceof HttpServletRequestWrapper && !Validator.isNotNull((String)(sessionAuthenticationToken = (String)(session = currentHttpServletRequest.getSession()).getAttribute(tokenKey)))) {
            HttpServletRequestWrapper httpServletRequestWrapper = (HttpServletRequestWrapper)currentHttpServletRequest;
            currentHttpServletRequest = (HttpServletRequest)httpServletRequestWrapper.getRequest();
        }
        if (Validator.isNull(sessionAuthenticationToken)) {
            session = currentHttpServletRequest.getSession();
            sessionAuthenticationToken = (String)session.getAttribute(tokenKey);
        }
        if (createToken && Validator.isNull(sessionAuthenticationToken)) {
            sessionAuthenticationToken = PwdGenerator.getPassword((int)PropsValues.AUTH_TOKEN_LENGTH);
            session.setAttribute(tokenKey, (Object)sessionAuthenticationToken);
        }
        return sessionAuthenticationToken;
    }
}

