/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Permission;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.security.permission.PermissionConversionFilter;
import com.liferay.portal.kernel.security.permission.PermissionConverter;
import com.liferay.portal.kernel.service.ResourceActionLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.model.impl.PermissionImpl;
import java.util.ArrayList;
import java.util.List;

public class PermissionConverterImpl
implements PermissionConverter {
    public List<Permission> convertPermissions(long roleId) throws PortalException {
        return this.convertPermissions(roleId, null);
    }

    public List<Permission> convertPermissions(long roleId, PermissionConversionFilter permissionConversionFilter) throws PortalException {
        return this.convertPermissions(RoleLocalServiceUtil.getRole((long)roleId), permissionConversionFilter);
    }

    public List<Permission> convertPermissions(Role role) {
        return this.convertPermissions(role, null);
    }

    public List<Permission> convertPermissions(Role role, PermissionConversionFilter permissionConversionFilter) {
        int[] scopes = new int[]{};
        if (role.getType() == 1) {
            scopes = new int[]{1, 2};
        } else if (role.getType() == 6 || role.getType() == 5 || role.getType() == 3 || role.getType() == 4 || role.getType() == 2) {
            scopes = new int[]{3};
        }
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        List resourcePermissions = ResourcePermissionLocalServiceUtil.getRoleResourcePermissions((long)role.getRoleId(), (int[])scopes, (int)-1, (int)-1);
        for (ResourcePermission resourcePermission : resourcePermissions) {
            if (permissionConversionFilter != null && !permissionConversionFilter.accept(role, resourcePermission)) continue;
            List resourceActions = ResourceActionLocalServiceUtil.getResourceActions((String)resourcePermission.getName());
            for (ResourceAction resourceAction : resourceActions) {
                if (!ResourcePermissionLocalServiceUtil.hasActionId((ResourcePermission)resourcePermission, (ResourceAction)resourceAction)) continue;
                PermissionImpl permission = new PermissionImpl();
                permission.setName(resourcePermission.getName());
                permission.setScope(resourcePermission.getScope());
                permission.setPrimKey(resourcePermission.getPrimKey());
                permission.setActionId(resourceAction.getActionId());
                permissions.add(permission);
            }
        }
        return permissions;
    }
}

