/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.ParamSetter;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.RepositoryEntry;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalServiceRegistry;
import com.liferay.portal.kernel.service.RepositoryEntryLocalService;
import com.liferay.portal.kernel.service.RepositoryEntryLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.RepositoryEntryPersistence;
import com.liferay.portal.kernel.service.persistence.UserFinder;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.List;
import javax.sql.DataSource;

public abstract class RepositoryEntryLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements IdentifiableOSGiService,
RepositoryEntryLocalService {
    @BeanReference(type=RepositoryEntryLocalService.class)
    protected RepositoryEntryLocalService repositoryEntryLocalService;
    @BeanReference(type=RepositoryEntryPersistence.class)
    protected RepositoryEntryPersistence repositoryEntryPersistence;
    @BeanReference(type=CounterLocalService.class)
    protected CounterLocalService counterLocalService;
    @BeanReference(type=UserLocalService.class)
    protected UserLocalService userLocalService;
    @BeanReference(type=UserPersistence.class)
    protected UserPersistence userPersistence;
    @BeanReference(type=UserFinder.class)
    protected UserFinder userFinder;
    @BeanReference(type=PersistedModelLocalServiceRegistry.class)
    protected PersistedModelLocalServiceRegistry persistedModelLocalServiceRegistry;

    @Indexable(type=IndexableType.REINDEX)
    public RepositoryEntry addRepositoryEntry(RepositoryEntry repositoryEntry) {
        repositoryEntry.setNew(true);
        return (RepositoryEntry)this.repositoryEntryPersistence.update((BaseModel)repositoryEntry);
    }

    @Transactional(enabled=false)
    public RepositoryEntry createRepositoryEntry(long repositoryEntryId) {
        return this.repositoryEntryPersistence.create(repositoryEntryId);
    }

    @Indexable(type=IndexableType.DELETE)
    public RepositoryEntry deleteRepositoryEntry(long repositoryEntryId) throws PortalException {
        return this.repositoryEntryPersistence.remove(repositoryEntryId);
    }

    @Indexable(type=IndexableType.DELETE)
    public RepositoryEntry deleteRepositoryEntry(RepositoryEntry repositoryEntry) {
        return (RepositoryEntry)this.repositoryEntryPersistence.remove((BaseModel)repositoryEntry);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.repositoryEntryPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(RepositoryEntry.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.repositoryEntryPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.repositoryEntryPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.repositoryEntryPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.repositoryEntryPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.repositoryEntryPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public RepositoryEntry fetchRepositoryEntry(long repositoryEntryId) {
        return this.repositoryEntryPersistence.fetchByPrimaryKey(repositoryEntryId);
    }

    public RepositoryEntry fetchRepositoryEntryByUuidAndGroupId(String uuid, long groupId) {
        return this.repositoryEntryPersistence.fetchByUUID_G(uuid, groupId);
    }

    public RepositoryEntry getRepositoryEntry(long repositoryEntryId) throws PortalException {
        return this.repositoryEntryPersistence.findByPrimaryKey(repositoryEntryId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.repositoryEntryLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(RepositoryEntry.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("repositoryEntryId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.repositoryEntryLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(RepositoryEntry.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("repositoryEntryId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.repositoryEntryLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(RepositoryEntry.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("repositoryEntryId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setGroupId(portletDataContext.getScopeGroupId());
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<RepositoryEntry>(){

            public void performAction(RepositoryEntry repositoryEntry) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)repositoryEntry);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)RepositoryEntry.class.getName())));
        return exportActionableDynamicQuery;
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.repositoryEntryPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        return this.repositoryEntryLocalService.deleteRepositoryEntry((RepositoryEntry)persistedModel);
    }

    public BasePersistence<RepositoryEntry> getBasePersistence() {
        return this.repositoryEntryPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.repositoryEntryPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public List<RepositoryEntry> getRepositoryEntriesByUuidAndCompanyId(String uuid, long companyId) {
        return this.repositoryEntryPersistence.findByUuid_C(uuid, companyId);
    }

    public List<RepositoryEntry> getRepositoryEntriesByUuidAndCompanyId(String uuid, long companyId, int start, int end, OrderByComparator<RepositoryEntry> orderByComparator) {
        return this.repositoryEntryPersistence.findByUuid_C(uuid, companyId, start, end, orderByComparator);
    }

    public RepositoryEntry getRepositoryEntryByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        return this.repositoryEntryPersistence.findByUUID_G(uuid, groupId);
    }

    public List<RepositoryEntry> getRepositoryEntries(int start, int end) {
        return this.repositoryEntryPersistence.findAll(start, end);
    }

    public int getRepositoryEntriesCount() {
        return this.repositoryEntryPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public RepositoryEntry updateRepositoryEntry(RepositoryEntry repositoryEntry) {
        return (RepositoryEntry)this.repositoryEntryPersistence.update((BaseModel)repositoryEntry);
    }

    public RepositoryEntryLocalService getRepositoryEntryLocalService() {
        return this.repositoryEntryLocalService;
    }

    public void setRepositoryEntryLocalService(RepositoryEntryLocalService repositoryEntryLocalService) {
        this.repositoryEntryLocalService = repositoryEntryLocalService;
    }

    public RepositoryEntryPersistence getRepositoryEntryPersistence() {
        return this.repositoryEntryPersistence;
    }

    public void setRepositoryEntryPersistence(RepositoryEntryPersistence repositoryEntryPersistence) {
        this.repositoryEntryPersistence = repositoryEntryPersistence;
    }

    public CounterLocalService getCounterLocalService() {
        return this.counterLocalService;
    }

    public void setCounterLocalService(CounterLocalService counterLocalService) {
        this.counterLocalService = counterLocalService;
    }

    public UserLocalService getUserLocalService() {
        return this.userLocalService;
    }

    public void setUserLocalService(UserLocalService userLocalService) {
        this.userLocalService = userLocalService;
    }

    public UserPersistence getUserPersistence() {
        return this.userPersistence;
    }

    public void setUserPersistence(UserPersistence userPersistence) {
        this.userPersistence = userPersistence;
    }

    public UserFinder getUserFinder() {
        return this.userFinder;
    }

    public void setUserFinder(UserFinder userFinder) {
        this.userFinder = userFinder;
    }

    public void afterPropertiesSet() {
        this.persistedModelLocalServiceRegistry.register("com.liferay.portal.kernel.model.RepositoryEntry", (PersistedModelLocalService)this.repositoryEntryLocalService);
        this._setLocalServiceUtilService(this.repositoryEntryLocalService);
    }

    public void destroy() {
        this.persistedModelLocalServiceRegistry.unregister("com.liferay.portal.kernel.model.RepositoryEntry");
        this._setLocalServiceUtilService(null);
    }

    public String getOSGiServiceIdentifier() {
        return RepositoryEntryLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return RepositoryEntry.class;
    }

    protected String getModelClassName() {
        return RepositoryEntry.class.getName();
    }

    protected void runSQL(String sql) {
        try {
            DataSource dataSource = this.repositoryEntryPersistence.getDataSource();
            DB db = DBManagerUtil.getDB();
            sql = db.buildSQL(sql);
            sql = PortalUtil.transformSQL((String)sql);
            SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate((DataSource)dataSource, (String)sql, (ParamSetter[])new ParamSetter[0]);
            sqlUpdate.update(new Object[0]);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    private void _setLocalServiceUtilService(RepositoryEntryLocalService repositoryEntryLocalService) {
        try {
            Field field = RepositoryEntryLocalServiceUtil.class.getDeclaredField("_service");
            field.setAccessible(true);
            field.set(null, repositoryEntryLocalService);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }
}

