/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.petra.encryptor.Encryptor;
import com.liferay.petra.encryptor.EncryptorException;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.db.partition.DBPartitionUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.AccountNameException;
import com.liferay.portal.kernel.exception.CompanyMxException;
import com.liferay.portal.kernel.exception.CompanyVirtualHostException;
import com.liferay.portal.kernel.exception.CompanyWebIdException;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.NoSuchVirtualHostException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.RequiredCompanyException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.instance.lifecycle.PortalInstanceLifecycleManager;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.async.Async;
import com.liferay.portal.kernel.model.Account;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.CompanyModel;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.GroupTable;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.PasswordPolicy;
import com.liferay.portal.kernel.model.PortalPreferences;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.VirtualHost;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineHelperUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.facet.faceted.searcher.FacetedSearcher;
import com.liferay.portal.kernel.search.facet.faceted.searcher.FacetedSearcherManagerUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.EmailAddressValidator;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.transaction.Isolation;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.kernel.util.TreeMapBuilder;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.liveusers.LiveUsers;
import com.liferay.portal.security.auth.EmailAddressValidatorFactory;
import com.liferay.portal.service.base.CompanyLocalServiceBaseImpl;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.IDN;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;

public class CompanyLocalServiceImpl
extends CompanyLocalServiceBaseImpl {
    private static final String _DEFAULT_VIRTUAL_HOST = "localhost";
    private static final Log _log = LogFactoryUtil.getLog(CompanyLocalServiceImpl.class);
    private final Set<Company> _pendingCompanies = new HashSet<Company>();
    private final ServiceTracker<PortalInstanceLifecycleManager, PortalInstanceLifecycleManager> _serviceTracker;

    public CompanyLocalServiceImpl() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(PortalInstanceLifecycleManager.class, (ServiceTrackerCustomizer)new PortalInstanceLifecycleManagerServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    @Override
    public Company addCompany(Company company) {
        this.companyInfoPersistence.update((BaseModel)company.getCompanyInfo());
        return super.addCompany(company);
    }

    public Company addCompany(Long companyId, String webId, String virtualHostname, String mx, boolean system, int maxUsers, boolean active) throws PortalException {
        virtualHostname = StringUtil.toLowerCase((String)StringUtil.trim((String)virtualHostname));
        this.validateWebId(webId);
        this.validateVirtualHost(webId, virtualHostname);
        this.validateMx(-1L, mx);
        if (companyId == null || companyId == 0L) {
            companyId = this.counterLocalService.increment();
        }
        Company company = this.companyPersistence.create(companyId.longValue());
        if (webId.equals(PropsValues.COMPANY_DEFAULT_WEB_ID)) {
            DBPartitionUtil.setDefaultCompanyId(company.getCompanyId());
        }
        boolean newDBPartitionAdded = DBPartitionUtil.addDBPartition(company.getCompanyId());
        final SafeCloseable safeCloseable = CompanyThreadLocal.setInitializingCompanyIdWithSafeCloseable((long)company.getCompanyId());
        try {
            company.setWebId(webId);
            company.setMx(mx);
            company.setSystem(system);
            company.setMaxUsers(maxUsers);
            company.setActive(active);
            company = (Company)this.companyPersistence.update((BaseModel)company);
            this.updateVirtualHostname(company.getCompanyId(), virtualHostname);
            if (newDBPartitionAdded) {
                this.dlFileEntryTypeLocalService.createBasicDocumentDLFileEntryType();
            }
            String name = webId;
            if (webId.equals(PropsValues.COMPANY_DEFAULT_WEB_ID)) {
                name = PropsValues.COMPANY_DEFAULT_NAME;
            }
            this.updateAccount(company, name, null, null, null, null, null, null, null, null);
            try {
                company.setKey(Encryptor.serializeKey((Key)Encryptor.generateKey()));
            }
            catch (EncryptorException encryptorException) {
                throw new SystemException((Throwable)encryptorException);
            }
            this.companyInfoPersistence.update((BaseModel)company.getCompanyInfo());
            if (webId.equals("liferay.net")) {
                this._addDemoSettings(company);
            }
            this._addDefaultUser(company);
            if (webId.equals(PropsValues.COMPANY_DEFAULT_WEB_ID)) {
                return company;
            }
            company = this._checkCompany(company, mx);
            TransactionCommitCallbackUtil.registerCallback((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    safeCloseable.close();
                    return null;
                }
            });
            return company;
        }
        catch (Exception exception) {
            safeCloseable.close();
            throw exception;
        }
    }

    @Deprecated
    public Company addCompany(String webId, String virtualHostname, String mx, boolean system, int maxUsers, boolean active) throws PortalException {
        return this.addCompany(null, webId, virtualHostname, mx, system, maxUsers, active);
    }

    public Company checkCompany(String webId) throws PortalException {
        String mx = webId;
        return this.companyLocalService.checkCompany(webId, mx);
    }

    @Transactional(isolation=Isolation.PORTAL, rollbackFor={PortalException.class, SystemException.class})
    public Company checkCompany(String webId, String mx) throws PortalException {
        Company company = this.getCompanyByWebId(webId);
        return this._checkCompany(company, mx);
    }

    public void checkCompanyKey(long companyId) throws PortalException {
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        if (company.getKeyObj() != null) {
            return;
        }
        try {
            company.setKey(Encryptor.serializeKey((Key)Encryptor.generateKey()));
        }
        catch (EncryptorException encryptorException) {
            throw new SystemException((Throwable)encryptorException);
        }
        this.companyInfoPersistence.update((BaseModel)company.getCompanyInfo());
    }

    @Override
    public Company deleteCompany(Company company) throws PortalException {
        return this.deleteCompany(company.getCompanyId());
    }

    @Override
    public Company deleteCompany(long companyId) throws PortalException {
        if (companyId == PortalInstances.getDefaultCompanyId()) {
            throw new RequiredCompanyException("Select another default company before deleting company " + companyId);
        }
        boolean deleteInProcess = CompanyThreadLocal.isDeleteInProcess();
        try {
            CompanyThreadLocal.setDeleteInProcess((boolean)true);
            Company company = this.doDeleteCompany(companyId);
            return company;
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)portalException, (Throwable)portalException);
            }
            throw portalException;
        }
        finally {
            CompanyThreadLocal.setDeleteInProcess((boolean)deleteInProcess);
        }
    }

    public Company deleteLogo(long companyId) throws PortalException {
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        PortalUtil.updateImageId((BaseModel)company, (boolean)false, null, (String)"logoId", (long)0L, (int)0, (int)0);
        return company;
    }

    public Company fetchCompanyById(long companyId) {
        return this.companyPersistence.fetchByPrimaryKey(companyId);
    }

    public Company fetchCompanyByVirtualHost(String virtualHostname) {
        VirtualHost virtualHost = this.virtualHostPersistence.fetchByHostname(virtualHostname = StringUtil.toLowerCase((String)StringUtil.trim((String)virtualHostname)));
        if (virtualHost == null && virtualHostname.contains("xn--")) {
            virtualHost = this.virtualHostPersistence.fetchByHostname(IDN.toUnicode(virtualHostname));
        }
        if (virtualHost == null || virtualHost.getLayoutSetId() != 0L) {
            return null;
        }
        return this.companyPersistence.fetchByPrimaryKey(virtualHost.getCompanyId());
    }

    @Transactional(enabled=false)
    public <E extends Exception> void forEachCompany(UnsafeConsumer<Company, E> unsafeConsumer) throws E {
        this.forEachCompany(unsafeConsumer, this.companyLocalService.getCompanies(false));
    }

    @Transactional(enabled=false)
    public <E extends Exception> void forEachCompany(UnsafeConsumer<Company, E> unsafeConsumer, List<Company> companies) throws E {
        for (Company company : companies) {
            SafeCloseable safeCloseable = CompanyThreadLocal.setWithSafeCloseable((Long)company.getCompanyId());
            Throwable throwable = null;
            try {
                unsafeConsumer.accept((Object)company);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (safeCloseable == null) continue;
                if (throwable != null) {
                    try {
                        safeCloseable.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                safeCloseable.close();
            }
        }
    }

    @Transactional(enabled=false)
    public <E extends Exception> void forEachCompanyId(UnsafeConsumer<Long, E> unsafeConsumer) throws E {
        this.forEachCompanyId(unsafeConsumer, ListUtil.toLongArray((List)this.companyLocalService.getCompanies(false), CompanyModel::getCompanyId));
    }

    @Transactional(enabled=false)
    public <E extends Exception> void forEachCompanyId(UnsafeConsumer<Long, E> unsafeConsumer, long[] companyIds) throws E {
        for (long companyId : companyIds) {
            try (SafeCloseable safeCloseable = CompanyThreadLocal.setWithSafeCloseable((Long)companyId);){
                unsafeConsumer.accept((Object)companyId);
            }
        }
    }

    public List<Company> getCompanies() {
        return this.companyPersistence.findAll();
    }

    public List<Company> getCompanies(boolean system) {
        return this.companyPersistence.findBySystem(system);
    }

    public List<Company> getCompanies(boolean system, int start, int end) {
        return this.companyPersistence.findBySystem(system, start, end);
    }

    public int getCompaniesCount(boolean system) {
        return this.companyPersistence.countBySystem(system);
    }

    public Company getCompanyById(long companyId) throws PortalException {
        return this.companyPersistence.findByPrimaryKey(companyId);
    }

    public Company getCompanyByLogoId(long logoId) throws PortalException {
        return this.companyPersistence.findByLogoId(logoId);
    }

    public Company getCompanyByMx(String mx) throws PortalException {
        return this.companyPersistence.findByMx(mx);
    }

    public Company getCompanyByVirtualHost(String virtualHostname) throws PortalException {
        try {
            virtualHostname = StringUtil.toLowerCase((String)StringUtil.trim((String)virtualHostname));
            VirtualHost virtualHost = this.virtualHostLocalService.fetchVirtualHost(virtualHostname);
            if (virtualHost == null && virtualHostname.contains("xn--")) {
                virtualHost = this.virtualHostPersistence.findByHostname(IDN.toUnicode(virtualHostname));
            }
            if (virtualHost.getLayoutSetId() != 0L) {
                throw new CompanyVirtualHostException("Virtual host is associated with layout set " + virtualHost.getLayoutSetId());
            }
            return this.companyPersistence.findByPrimaryKey(virtualHost.getCompanyId());
        }
        catch (NoSuchVirtualHostException noSuchVirtualHostException) {
            throw new CompanyVirtualHostException((Throwable)noSuchVirtualHostException);
        }
    }

    public Company getCompanyByWebId(String webId) throws PortalException {
        return this.companyPersistence.findByWebId(webId);
    }

    public long getCompanyIdByUserId(long userId) throws Exception {
        long companyId;
        block5: {
            long[] companyIds = PortalInstances.getCompanyIds();
            companyId = 0L;
            if (companyIds.length == 1) {
                companyId = companyIds[0];
            } else if (companyIds.length > 1) {
                try {
                    User user = this.userPersistence.findByPrimaryKey(userId);
                    companyId = user.getCompanyId();
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block5;
                    _log.warn((Object)("Unable to get the company ID for user " + userId), (Throwable)exception);
                }
            }
        }
        return companyId;
    }

    public void removePreferences(long companyId, String[] keys) {
        PortletPreferences preferences = PrefsPropsUtil.getPreferences(companyId);
        try {
            for (String key : keys) {
                preferences.reset(key);
            }
            preferences.store();
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public Hits search(long companyId, long userId, String keywords, int start, int end) {
        return this.search(companyId, userId, null, 0L, null, keywords, start, end);
    }

    public Hits search(long companyId, long userId, String portletId, long groupId, String type, String keywords, int start, int end) {
        FacetedSearcher facetedSearcher = FacetedSearcherManagerUtil.createFacetedSearcher();
        SearchContext searchContext = this.createSearchContext(companyId, userId, portletId, groupId, keywords, start, end);
        try {
            return facetedSearcher.search(searchContext);
        }
        catch (SearchException searchException) {
            throw new SystemException((Throwable)searchException);
        }
    }

    @Override
    public Company updateCompany(Company company) {
        this.companyInfoPersistence.update((BaseModel)company.getCompanyInfo());
        return super.updateCompany(company);
    }

    public Company updateCompany(long companyId, String virtualHostname, String mx, int maxUsers, boolean active) throws PortalException {
        virtualHostname = StringUtil.toLowerCase((String)StringUtil.trim((String)virtualHostname));
        if (!active && companyId == PortalInstances.getDefaultCompanyId()) {
            throw new RequiredCompanyException("Select another default company before deactivating company " + companyId);
        }
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        this.validateVirtualHost(company.getWebId(), virtualHostname);
        if (PropsValues.MAIL_MX_UPDATE) {
            this.validateMx(companyId, mx);
            company.setMx(mx);
        }
        company.setMaxUsers(maxUsers);
        company.setActive(active);
        this.companyPersistence.update((BaseModel)company);
        return this.updateVirtualHostname(companyId, virtualHostname);
    }

    public Company updateCompany(long companyId, String virtualHostname, String mx, String homeURL, boolean hasLogo, byte[] logoBytes, String name, String legalName, String legalId, String legalType, String sicCode, String tickerSymbol, String industry, String type, String size) throws PortalException {
        virtualHostname = StringUtil.toLowerCase((String)StringUtil.trim((String)virtualHostname));
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        this.validateVirtualHost(company.getWebId(), virtualHostname);
        if (PropsValues.MAIL_MX_UPDATE) {
            this.validateMx(companyId, mx);
        }
        this.validateName(companyId, name);
        if (PropsValues.MAIL_MX_UPDATE) {
            company.setMx(mx);
        }
        company.setHomeURL(homeURL);
        PortalUtil.updateImageId((BaseModel)company, (boolean)hasLogo, (byte[])logoBytes, (String)"logoId", (long)0L, (int)0, (int)0);
        company = (Company)this.companyPersistence.update((BaseModel)company);
        this.updateAccount(company, name, legalName, legalId, legalType, sicCode, tickerSymbol, industry, type, size);
        return this.updateVirtualHostname(companyId, virtualHostname);
    }

    public void updateDisplay(long companyId, String languageId, String timeZoneId) throws PortalException {
        User user = this.userLocalService.getDefaultUser(companyId);
        user.setLanguageId(languageId);
        user.setTimeZoneId(timeZoneId);
        this.userPersistence.update((BaseModel)user);
        this.updateDisplayGroupNames(companyId);
    }

    @Async
    public void updateDisplayGroupNames(long companyId) throws PortalException {
        User user = this.userLocalService.getDefaultUser(companyId);
        Locale locale = user.getLocale();
        if (locale.equals(LocaleUtil.getDefault())) {
            return;
        }
        ActionableDynamicQuery groupActionableDynamicQuery = this.groupLocalService.getActionableDynamicQuery();
        groupActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property activeProperty = PropertyFactoryUtil.forName((String)"active");
            dynamicQuery.add(activeProperty.eq((Object)Boolean.TRUE));
            Property nameProperty = PropertyFactoryUtil.forName((String)"name");
            dynamicQuery.add(nameProperty.isNotNull());
            Property typeProperty = PropertyFactoryUtil.forName((String)"type");
            dynamicQuery.add(typeProperty.ne((Object)4));
        });
        groupActionableDynamicQuery.setCompanyId(user.getCompanyId());
        groupActionableDynamicQuery.setPerformActionMethod(group -> {
            Map nameMap = group.getNameMap();
            if (MapUtil.isEmpty((Map)nameMap)) {
                return;
            }
            String groupDefaultName = (String)nameMap.get(locale);
            if (Validator.isNotNull((String)groupDefaultName)) {
                return;
            }
            String oldGroupDefaultName = (String)nameMap.get(LocaleUtil.getDefault());
            if (_log.isWarnEnabled()) {
                StringBundler sb = new StringBundler(5);
                sb.append("No name was found for locale ");
                sb.append((Object)locale);
                sb.append(". Using \"");
                sb.append(oldGroupDefaultName);
                sb.append("\" as the name instead.");
                _log.warn((Object)sb.toString());
            }
            nameMap.put(locale, oldGroupDefaultName);
            group.setNameMap(nameMap);
            this.groupLocalService.updateGroup(group);
        });
        groupActionableDynamicQuery.performActions();
    }

    public Company updateLogo(long companyId, byte[] bytes) throws PortalException {
        Company company = this.checkLogo(companyId);
        this.imageLocalService.updateImage(company.getLogoId(), bytes);
        return company;
    }

    public Company updateLogo(long companyId, File file) throws PortalException {
        Company company = this.checkLogo(companyId);
        this.imageLocalService.updateImage(company.getLogoId(), file);
        return company;
    }

    public Company updateLogo(long companyId, InputStream inputStream) throws PortalException {
        Company company = this.checkLogo(companyId);
        this.imageLocalService.updateImage(company.getLogoId(), inputStream);
        return company;
    }

    public void updatePreferences(long companyId, UnicodeProperties unicodeProperties) throws PortalException {
        PortletPreferences portletPreferences = PrefsPropsUtil.getPreferences(companyId);
        try {
            String oldLanguageIds;
            String newLanguageIds = unicodeProperties.getProperty("locales");
            if (Validator.isNotNull((String)newLanguageIds) && !Objects.equals(oldLanguageIds = portletPreferences.getValue("locales", ""), newLanguageIds)) {
                this.validateLanguageIds(newLanguageIds);
                this._updateGroupLanguageIds(companyId, newLanguageIds, oldLanguageIds);
                LanguageUtil.resetAvailableLocales((long)companyId);
                Date now = new Date();
                for (LayoutSetPrototype layoutSetPrototype : this.layoutSetPrototypeLocalService.getLayoutSetPrototypes(companyId)) {
                    layoutSetPrototype.setModifiedDate(now);
                    this.layoutSetPrototypeLocalService.updateLayoutSetPrototype(layoutSetPrototype);
                }
            }
            ArrayList<String> resetKeys = new ArrayList<String>();
            for (Map.Entry entry : unicodeProperties.entrySet()) {
                String value = (String)entry.getValue();
                if (value.equals("TEMP_OBFUSCATION_VALUE")) continue;
                String key = (String)entry.getKey();
                String propsUtilValue = PropsUtil.get(key);
                if (!value.equals(propsUtilValue)) {
                    portletPreferences.setValue(key, value);
                    continue;
                }
                String portletPreferencesValue = portletPreferences.getValue(key, null);
                if (portletPreferencesValue == null) continue;
                resetKeys.add(key);
            }
            for (String key : resetKeys) {
                portletPreferences.reset(key);
            }
            portletPreferences.store();
        }
        catch (LocaleException localeException) {
            throw localeException;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        this._clearCompanyCache(companyId);
    }

    public void updateSecurity(long companyId, String authType, boolean autoLogin, boolean sendPassword, boolean strangers, boolean strangersWithMx, boolean strangersVerify, boolean siteLogo) {
        PortletPreferences preferences = PrefsPropsUtil.getPreferences(companyId);
        try {
            preferences.setValue("company.security.auth.type", authType);
            preferences.setValue("company.security.auto.login", String.valueOf(autoLogin));
            preferences.setValue("company.security.strangers", String.valueOf(strangers));
            preferences.setValue("company.security.strangers.with.mx", String.valueOf(strangersWithMx));
            preferences.setValue("company.security.strangers.verify", String.valueOf(strangersVerify));
            preferences.setValue("company.security.site.logo", String.valueOf(siteLogo));
            preferences.store();
        }
        catch (IOException | PortletException exception) {
            throw new SystemException(exception);
        }
        this._clearCompanyCache(companyId);
    }

    protected void addAssetEntriesFacet(SearchContext searchContext) {
    }

    protected Company checkLogo(long companyId) throws PortalException {
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        long logoId = company.getLogoId();
        if (logoId <= 0L) {
            logoId = this.counterLocalService.increment();
            company.setLogoId(logoId);
            company = (Company)this.companyPersistence.update((BaseModel)company);
        }
        return company;
    }

    protected SearchContext createSearchContext(long companyId, long userId, String portletId, long groupId, String keywords, int start, int end) {
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setEntryClassNames(SearchEngineHelperUtil.getEntryClassNames());
        if (groupId > 0L) {
            searchContext.setGroupIds(new long[]{groupId});
        }
        searchContext.setKeywords(keywords);
        if (Validator.isNotNull((String)portletId)) {
            searchContext.setPortletIds(new String[]{portletId});
        }
        searchContext.setStart(start);
        searchContext.setUserId(userId);
        return searchContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Company doDeleteCompany(long companyId) throws PortalException {
        String[] systemGroups;
        final Company company = this.companyPersistence.findByPrimaryKey(companyId);
        if (DBPartitionUtil.removeDBPartition(companyId)) {
            this._clearCompanyCache(companyId);
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    PortalInstances.removeCompany(company.getCompanyId());
                    return null;
                }
            };
            TransactionCommitCallbackUtil.registerCallback((Callable)callable);
            return company;
        }
        this.preunregisterCompany(company);
        this.companyPersistence.remove((BaseModel)company);
        this.companyInfoPersistence.remove((BaseModel)company.getCompanyInfo());
        this.accountLocalService.deleteAccount(company.getAccountId());
        DeleteExpandoColumnActionableDynamicQuery deleteExpandoColumnActionableDynamicQuery = new DeleteExpandoColumnActionableDynamicQuery(company.getCompanyId());
        deleteExpandoColumnActionableDynamicQuery.performActions();
        DeleteExpandoTableActionableDynamicQuery deleteExpandoTableActionableDynamicQuery = new DeleteExpandoTableActionableDynamicQuery(company.getCompanyId());
        deleteExpandoTableActionableDynamicQuery.performActions();
        DeleteGroupActionableDynamicQuery deleteGroupActionableDynamicQuery = new DeleteGroupActionableDynamicQuery();
        deleteGroupActionableDynamicQuery.setCompanyId(companyId);
        deleteGroupActionableDynamicQuery.performActions();
        for (String groupName : systemGroups = PortalUtil.getSystemGroups()) {
            deleteGroupActionableDynamicQuery.deleteGroup(this.groupLocalService.getGroup(companyId, groupName));
        }
        deleteGroupActionableDynamicQuery.deleteGroup(this.groupLocalService.getCompanyGroup(companyId));
        ActionableDynamicQuery layoutPrototypeActionableDynamicQuery = this.layoutPrototypeLocalService.getActionableDynamicQuery();
        layoutPrototypeActionableDynamicQuery.setCompanyId(companyId);
        layoutPrototypeActionableDynamicQuery.setPerformActionMethod(layoutPrototype -> this.layoutPrototypeLocalService.deleteLayoutPrototype(layoutPrototype));
        layoutPrototypeActionableDynamicQuery.performActions();
        ActionableDynamicQuery layoutSetPrototypeActionableDynamicQuery = this.layoutSetPrototypeLocalService.getActionableDynamicQuery();
        layoutSetPrototypeActionableDynamicQuery.setCompanyId(companyId);
        layoutSetPrototypeActionableDynamicQuery.setPerformActionMethod(layoutSetPrototype -> this.layoutSetPrototypeLocalService.deleteLayoutSetPrototype(layoutSetPrototype));
        layoutSetPrototypeActionableDynamicQuery.performActions();
        DeleteOrganizationActionableDynamicQuery deleteOrganizationActionableDynamicQuery = new DeleteOrganizationActionableDynamicQuery();
        deleteOrganizationActionableDynamicQuery.setCompanyId(companyId);
        deleteOrganizationActionableDynamicQuery.performActions();
        DeleteUserGroupActionableDynamicQuery deleteUserGroupActionableDynamicQuery = new DeleteUserGroupActionableDynamicQuery(company.getCompanyId());
        deleteUserGroupActionableDynamicQuery.performActions();
        this.passwordPolicyLocalService.deleteNondefaultPasswordPolicies(companyId);
        PasswordPolicy defaultPasswordPolicy = this.passwordPolicyLocalService.getDefaultPasswordPolicy(companyId);
        if (defaultPasswordPolicy != null) {
            this.passwordPolicyLocalService.deletePasswordPolicy(defaultPasswordPolicy);
        }
        PortalPreferences portalPreferences = this.portalPreferencesPersistence.findByO_O(companyId, 1);
        this.portalPreferencesLocalService.deletePortalPreferences(portalPreferences);
        User defaultUser = this.userLocalService.getDefaultUser(companyId);
        String name = PrincipalThreadLocal.getName();
        try {
            PrincipalThreadLocal.setName((long)defaultUser.getUserId());
            ActionableDynamicQuery userActionableDynamicQuery = this.userLocalService.getActionableDynamicQuery();
            userActionableDynamicQuery.setCompanyId(companyId);
            userActionableDynamicQuery.setPerformActionMethod(user -> {
                if (!user.isDefaultUser()) {
                    this.userLocalService.deleteUser(user.getUserId());
                }
            });
            userActionableDynamicQuery.performActions();
        }
        finally {
            PrincipalThreadLocal.setName((String)name);
        }
        this.userLocalService.deleteUser(defaultUser);
        ActionableDynamicQuery roleActionableDynamicQuery = this.roleLocalService.getActionableDynamicQuery();
        roleActionableDynamicQuery.setCompanyId(companyId);
        roleActionableDynamicQuery.setPerformActionMethod(role -> this.roleLocalService.deleteRole(role));
        roleActionableDynamicQuery.performActions();
        DeleteSystemEventActionableDynamicQuery deleteSystemEventActionableDynamicQuery = new DeleteSystemEventActionableDynamicQuery(company.getCompanyId());
        deleteSystemEventActionableDynamicQuery.performActions();
        this._deletePortalInstance(company);
        return company;
    }

    protected void preregisterCompany(long companyId) {
        try {
            SearchEngineHelperUtil.initialize((long)companyId);
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to initialize search engine for company " + companyId), (Throwable)exception);
        }
    }

    protected void preunregisterCompany(Company company) {
        PortalInstanceLifecycleManager portalInstanceLifecycleManager = (PortalInstanceLifecycleManager)this._serviceTracker.getService();
        if (portalInstanceLifecycleManager != null) {
            portalInstanceLifecycleManager.preunregisterCompany(company);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerCompany(Company company) {
        PortalInstanceLifecycleManager portalInstanceLifecycleManager = (PortalInstanceLifecycleManager)this._serviceTracker.getService();
        if (portalInstanceLifecycleManager != null) {
            portalInstanceLifecycleManager.registerCompany(company);
        } else {
            Set<Company> set = this._pendingCompanies;
            synchronized (set) {
                this._pendingCompanies.add(company);
            }
        }
    }

    protected void unregisterCompany(Company company) {
        PortalInstanceLifecycleManager portalInstanceLifecycleManager = (PortalInstanceLifecycleManager)this._serviceTracker.getService();
        if (portalInstanceLifecycleManager != null) {
            portalInstanceLifecycleManager.unregisterCompany(company);
        }
    }

    protected void updateAccount(Company company, String name, String legalName, String legalId, String legalType, String sicCode, String tickerSymbol, String industry, String type, String size) {
        Account account = this.accountPersistence.fetchByPrimaryKey(company.getAccountId());
        if (account == null) {
            long accountId = this.counterLocalService.increment();
            account = this.accountPersistence.create(accountId);
            account.setCompanyId(company.getCompanyId());
            account.setUserId(0L);
            account.setUserName("");
            company.setAccountId(accountId);
            this.companyPersistence.update((BaseModel)company);
        }
        account.setName(name);
        account.setLegalName(legalName);
        account.setLegalId(legalId);
        account.setLegalType(legalType);
        account.setSicCode(sicCode);
        account.setTickerSymbol(tickerSymbol);
        account.setIndustry(industry);
        account.setType(type);
        account.setSize(size);
        this.accountPersistence.update((BaseModel)account);
    }

    protected Company updateVirtualHostname(long companyId, String virtualHostname) throws CompanyVirtualHostException {
        if (Validator.isNotNull((String)virtualHostname)) {
            try {
                if (Validator.isIPv6Address((String)virtualHostname)) {
                    Inet6Address address = (Inet6Address)InetAddress.getByName(virtualHostname);
                    virtualHostname = address.getHostAddress();
                }
            }
            catch (UnknownHostException unknownHostException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)unknownHostException, (Throwable)unknownHostException);
                }
                throw new CompanyVirtualHostException("Virtual hostname is not a valid IPv6 address");
            }
            VirtualHost virtualHost = this.virtualHostPersistence.fetchByHostname(virtualHostname);
            if (virtualHost == null) {
                this.virtualHostLocalService.updateVirtualHosts(companyId, 0L, TreeMapBuilder.put((Object)virtualHostname, (Object)"").build());
            } else if (virtualHost.getCompanyId() != companyId || virtualHost.getLayoutSetId() != 0L) {
                throw new CompanyVirtualHostException();
            }
        } else {
            List virtualHosts = this.virtualHostPersistence.findByC_L(companyId, 0L);
            if (!virtualHosts.isEmpty()) {
                for (VirtualHost virtualHost : virtualHosts) {
                    this.virtualHostPersistence.remove((BaseModel)virtualHost);
                }
            }
        }
        return this.companyPersistence.fetchByPrimaryKey(companyId);
    }

    protected void validateLanguageIds(String languageIds) throws PortalException {
        String[] languageIdsArray;
        for (String languageId : languageIdsArray = StringUtil.split((String)languageIds, (String)",")) {
            if (ArrayUtil.contains((Object[])PropsValues.LOCALES, (Object)languageId)) continue;
            LocaleException localeException = new LocaleException(1);
            localeException.setSourceAvailableLocales(Arrays.asList(LocaleUtil.fromLanguageIds((String[])PropsValues.LOCALES)));
            localeException.setTargetAvailableLocales(Arrays.asList(LocaleUtil.fromLanguageIds((String[])languageIdsArray)));
            throw localeException;
        }
    }

    protected void validateMx(long companyId, String mx) throws PortalException {
        if (Validator.isNull((String)mx) || !Validator.isDomain((String)mx)) {
            throw new CompanyMxException("Invalid domain " + mx);
        }
        String emailAddress = PropsValues.DEFAULT_ADMIN_EMAIL_ADDRESS_PREFIX + "@" + mx;
        EmailAddressValidator emailAddressValidator = EmailAddressValidatorFactory.getInstance();
        if (!emailAddressValidator.validate(companyId, emailAddress)) {
            throw new CompanyMxException("Invalid email address " + emailAddress);
        }
    }

    protected void validateName(long companyId, String name) throws PortalException {
        Group group = this.groupLocalService.fetchGroup(companyId, name);
        if (group != null || Validator.isNull((String)name)) {
            throw new AccountNameException();
        }
    }

    protected void validateVirtualHost(String webId, String virtualHostname) throws PortalException {
        if (Validator.isNull((String)virtualHostname)) {
            throw new CompanyVirtualHostException("Virtual hostname is null");
        }
        if (virtualHostname.equals(_DEFAULT_VIRTUAL_HOST) && !webId.equals(PropsValues.COMPANY_DEFAULT_WEB_ID)) {
            throw new CompanyVirtualHostException("localhost can only be used with the default web ID " + webId);
        }
        if (!Validator.isDomain((String)virtualHostname) && !Validator.isIPAddress((String)virtualHostname)) {
            throw new CompanyVirtualHostException("Virtual hostname is invalid");
        }
        VirtualHost virtualHost = this.virtualHostLocalService.fetchVirtualHost(virtualHostname);
        if (virtualHost == null) {
            return;
        }
        Company virtualHostnameCompany = this.companyPersistence.findByPrimaryKey(virtualHost.getCompanyId());
        if (!webId.equals(virtualHostnameCompany.getWebId())) {
            throw new CompanyVirtualHostException("Duplicate virtual hostname " + virtualHostname);
        }
    }

    protected void validateWebId(String webId) throws CompanyWebIdException {
        if (Validator.isNull((String)webId)) {
            throw new CompanyWebIdException("Web ID is null");
        }
        if (this.companyPersistence.fetchByWebId(webId) != null) {
            throw new CompanyWebIdException("Duplicate web ID " + webId);
        }
    }

    private User _addDefaultUser(Company company) {
        Date now = new Date();
        User defaultUser = this.userPersistence.create(this.counterLocalService.increment());
        defaultUser.setCompanyId(company.getCompanyId());
        defaultUser.setDefaultUser(true);
        defaultUser.setContactId(this.counterLocalService.increment());
        defaultUser.setPassword("password");
        defaultUser.setScreenName(String.valueOf(defaultUser.getUserId()));
        defaultUser.setEmailAddress("default@" + company.getMx());
        defaultUser.setLanguageId(LocaleUtil.toLanguageId((Locale)LocaleUtil.fromLanguageId((String)PropsValues.COMPANY_DEFAULT_LOCALE)));
        if (Validator.isNotNull((String)PropsValues.COMPANY_DEFAULT_TIME_ZONE)) {
            defaultUser.setTimeZoneId(PropsValues.COMPANY_DEFAULT_TIME_ZONE);
        } else {
            TimeZone timeZone = TimeZoneUtil.getDefault();
            defaultUser.setTimeZoneId(timeZone.getID());
        }
        String greeting = LanguageUtil.format((Locale)defaultUser.getLocale(), (String)"welcome", null, (boolean)false);
        defaultUser.setGreeting(greeting + "!");
        defaultUser.setLoginDate(now);
        defaultUser.setFailedLoginAttempts(0);
        defaultUser.setAgreedToTermsOfUse(true);
        defaultUser.setStatus(0);
        defaultUser = this.userPersistence.updateImpl(defaultUser);
        Contact defaultContact = this.contactPersistence.create(defaultUser.getContactId());
        defaultContact.setCompanyId(defaultUser.getCompanyId());
        defaultContact.setUserId(defaultUser.getUserId());
        defaultContact.setUserName("");
        defaultContact.setClassName(User.class.getName());
        defaultContact.setClassPK(defaultUser.getUserId());
        defaultContact.setAccountId(company.getAccountId());
        defaultContact.setParentContactId(0L);
        defaultContact.setEmailAddress(defaultUser.getEmailAddress());
        defaultContact.setFirstName("");
        defaultContact.setMiddleName("");
        defaultContact.setLastName("");
        defaultContact.setMale(true);
        defaultContact.setBirthday(now);
        this.contactPersistence.update((BaseModel)defaultContact);
        return defaultUser;
    }

    private void _addDemoSettings(Company company) throws PortalException {
        this.updateVirtualHostname(company.getCompanyId(), "demo.liferay.net");
        this.updateSecurity(company.getCompanyId(), "emailAddress", true, true, true, true, false, true);
        PortletPreferences preferences = PrefsPropsUtil.getPreferences(company.getCompanyId());
        try {
            preferences.setValue("admin.email.from.name", "Liferay Demo");
            preferences.setValue("admin.email.from.address", "test@liferay.net");
            preferences.store();
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
        catch (PortletException portletException) {
            throw new SystemException((Throwable)portletException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Company _checkCompany(Company company, String mx) throws PortalException {
        Locale localeThreadLocalDefaultLocale = LocaleThreadLocal.getDefaultLocale();
        Locale localeThreadSiteDefaultLocale = LocaleThreadLocal.getSiteDefaultLocale();
        try {
            this.preregisterCompany(company.getCompanyId());
            Locale companyDefaultLocale = LocaleUtil.fromLanguageId((String)PropsValues.COMPANY_DEFAULT_LOCALE);
            LocaleThreadLocal.setDefaultLocale((Locale)companyDefaultLocale);
            LocaleThreadLocal.setSiteDefaultLocale(null);
            this.checkCompanyKey(company.getCompanyId());
            User defaultUser = this.userPersistence.fetchByC_DU(company.getCompanyId(), true);
            if (defaultUser != null) {
                if (!defaultUser.isAgreedToTermsOfUse()) {
                    defaultUser.setAgreedToTermsOfUse(true);
                    defaultUser = (User)this.userPersistence.update((BaseModel)defaultUser);
                }
            } else {
                defaultUser = this._addDefaultUser(company);
            }
            this.roleLocalService.checkSystemRoles(company.getCompanyId());
            this.groupLocalService.checkSystemGroups(company.getCompanyId());
            this.groupLocalService.checkCompanyGroup(company.getCompanyId());
            this.passwordPolicyLocalService.checkDefaultPasswordPolicy(company.getCompanyId());
            Role guestRole = this.roleLocalService.getRole(company.getCompanyId(), "Guest");
            this.roleLocalService.setUserRoles(defaultUser.getUserId(), new long[]{guestRole.getRoleId()});
            if (this.userPersistence.countByCompanyId(company.getCompanyId()) == 0) {
                String emailAddress = PropsValues.DEFAULT_ADMIN_EMAIL_ADDRESS_PREFIX + "@" + mx;
                this.userLocalService.addDefaultAdminUser(company.getCompanyId(), PropsValues.DEFAULT_ADMIN_SCREEN_NAME, emailAddress, defaultUser.getLocale(), PropsValues.DEFAULT_ADMIN_FIRST_NAME, PropsValues.DEFAULT_ADMIN_MIDDLE_NAME, PropsValues.DEFAULT_ADMIN_LAST_NAME);
            }
            this.portletLocalService.checkPortlets(company.getCompanyId());
            final Company finalCompany = company;
            TransactionCommitCallbackUtil.registerCallback((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    CompanyLocalServiceImpl.this.registerCompany(finalCompany);
                    return null;
                }
            });
        }
        finally {
            LocaleThreadLocal.setDefaultLocale((Locale)localeThreadLocalDefaultLocale);
            LocaleThreadLocal.setSiteDefaultLocale((Locale)localeThreadSiteDefaultLocale);
        }
        return company;
    }

    private void _clearCompanyCache(long companyId) {
        final Company company = this.companyPersistence.fetchByPrimaryKey(companyId);
        if (company != null) {
            TransactionCommitCallbackUtil.registerCallback((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    EntityCacheUtil.removeResult(company.getClass(), (Serializable)company.getPrimaryKeyObj());
                    return null;
                }
            });
            this.companyPersistence.clearCache((BaseModel)company);
        }
    }

    private void _deletePortalInstance(final Company company) throws PortalException {
        List portlets = this.portletPersistence.findByCompanyId(company.getCompanyId());
        for (Portlet portlet : portlets) {
            this.portletLocalService.deletePortlet(portlet.getId());
        }
        this.portletLocalService.removeCompanyPortletsPool(company.getCompanyId());
        VirtualHost companyVirtualHost = this.virtualHostLocalService.fetchVirtualHost(company.getCompanyId(), 0L);
        this.virtualHostLocalService.deleteVirtualHost(companyVirtualHost);
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                PortalInstances.removeCompany(company.getCompanyId());
                CompanyLocalServiceImpl.this.unregisterCompany(company);
                return null;
            }
        };
        TransactionCommitCallbackUtil.registerCallback((Callable)callable);
    }

    private void _updateGroupLanguageIds(long companyId, String newLanguageIds, String oldLanguageIds) {
        List removedLanguageIds;
        Object[] oldLanguageIdsArray = StringUtil.split((String)oldLanguageIds);
        if (ArrayUtil.isEmpty((Object[])oldLanguageIdsArray)) {
            oldLanguageIdsArray = LocaleUtil.toLanguageIds((Collection)LanguageUtil.getCompanyAvailableLocales((long)companyId));
        }
        if (ListUtil.isEmpty((List)(removedLanguageIds = ListUtil.remove((List)ListUtil.fromArray((Object[])oldLanguageIdsArray), (List)ListUtil.fromArray((Object[])StringUtil.split((String)newLanguageIds)))))) {
            return;
        }
        List groups = (List)this.groupLocalService.dslQuery((DSLQuery)DSLQueryFactoryUtil.selectDistinct((Table)GroupTable.INSTANCE).from((Table)GroupTable.INSTANCE).where(GroupTable.INSTANCE.companyId.eq((Object)companyId).and((Expression)GroupTable.INSTANCE.active.eq((Object)true)).and((Expression)GroupTable.INSTANCE.site.eq((Object)true)).and((Expression)GroupTable.INSTANCE.typeSettings.like("%inheritLocales=false%"))));
        for (Group group : groups) {
            UnicodeProperties groupTypeSettingsUnicodeProperties = group.getTypeSettingsProperties();
            Object[] groupLanguageIds = StringUtil.split((String)groupTypeSettingsUnicodeProperties.getProperty("locales"));
            boolean updateLocales = false;
            for (String removedLanguageId : removedLanguageIds) {
                if (!ArrayUtil.contains((Object[])groupLanguageIds, (Object)removedLanguageId)) continue;
                groupLanguageIds = ArrayUtil.remove((String[])groupLanguageIds, (String)removedLanguageId);
                updateLocales = true;
            }
            if (!updateLocales) continue;
            LanguageUtil.resetAvailableGroupLocales((long)group.getGroupId());
            groupTypeSettingsUnicodeProperties.setProperty("locales", StringUtil.merge((Object[])groupLanguageIds, (String)","));
            this.groupLocalService.updateGroup(group);
        }
    }

    private class PortalInstanceLifecycleManagerServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<PortalInstanceLifecycleManager, PortalInstanceLifecycleManager> {
        private PortalInstanceLifecycleManagerServiceTrackerCustomizer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PortalInstanceLifecycleManager addingService(ServiceReference<PortalInstanceLifecycleManager> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            PortalInstanceLifecycleManager portalInstanceLifecycleManager = (PortalInstanceLifecycleManager)registry.getService(serviceReference);
            Set set = CompanyLocalServiceImpl.this._pendingCompanies;
            synchronized (set) {
                CompanyLocalServiceImpl.this.forEachCompany(company -> portalInstanceLifecycleManager.registerCompany(company), new ArrayList<Company>(CompanyLocalServiceImpl.this._pendingCompanies));
                CompanyLocalServiceImpl.this._pendingCompanies.clear();
            }
            return portalInstanceLifecycleManager;
        }

        public void modifiedService(ServiceReference<PortalInstanceLifecycleManager> serviceReference, PortalInstanceLifecycleManager portalInstanceLifecycleManager) {
            this.removedService(serviceReference, portalInstanceLifecycleManager);
            this.addingService(serviceReference);
        }

        public void removedService(ServiceReference<PortalInstanceLifecycleManager> serviceReference, PortalInstanceLifecycleManager portalInstanceLifecycleManager) {
        }
    }

    protected class DeleteUserGroupActionableDynamicQuery {
        private ActionableDynamicQuery _actionableDynamicQuery;

        protected DeleteUserGroupActionableDynamicQuery(long companyId) {
            this._actionableDynamicQuery = CompanyLocalServiceImpl.this.userGroupLocalService.getActionableDynamicQuery();
            this._actionableDynamicQuery.setCompanyId(companyId);
            this._actionableDynamicQuery.setPerformActionMethod(userGroup -> CompanyLocalServiceImpl.this.userGroupLocalService.deleteUserGroup(userGroup));
        }

        protected void performActions() throws PortalException {
            this._actionableDynamicQuery.performActions();
        }
    }

    protected class DeleteSystemEventActionableDynamicQuery {
        private ActionableDynamicQuery _actionableDynamicQuery;

        protected DeleteSystemEventActionableDynamicQuery(long companyId) {
            this._actionableDynamicQuery = CompanyLocalServiceImpl.this.systemEventLocalService.getActionableDynamicQuery();
            this._actionableDynamicQuery.setCompanyId(companyId);
            this._actionableDynamicQuery.setPerformActionMethod(systemEvent -> CompanyLocalServiceImpl.this.systemEventLocalService.deleteSystemEvent(systemEvent));
        }

        protected void performActions() throws PortalException {
            this._actionableDynamicQuery.performActions();
        }
    }

    protected class DeleteOrganizationActionableDynamicQuery {
        private ActionableDynamicQuery _actionableDynamicQuery;
        private long _parentOrganizationId = 0L;

        public void setParentOrganizationId(long parentOrganizationId) {
            this._parentOrganizationId = parentOrganizationId;
        }

        protected DeleteOrganizationActionableDynamicQuery() {
            this._actionableDynamicQuery = CompanyLocalServiceImpl.this.organizationLocalService.getActionableDynamicQuery();
            this._actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
                Property property = PropertyFactoryUtil.forName((String)"parentOrganizationId");
                dynamicQuery.add(property.eq((Object)this._parentOrganizationId));
            });
            this._actionableDynamicQuery.setPerformActionMethod(organization -> this.deleteOrganization((Organization)organization));
        }

        protected void deleteOrganization(Organization organization) throws PortalException {
            DeleteOrganizationActionableDynamicQuery deleteOrganizationActionableDynamicQuery = new DeleteOrganizationActionableDynamicQuery();
            deleteOrganizationActionableDynamicQuery.setCompanyId(organization.getCompanyId());
            deleteOrganizationActionableDynamicQuery.setParentOrganizationId(organization.getOrganizationId());
            deleteOrganizationActionableDynamicQuery.performActions();
            CompanyLocalServiceImpl.this.organizationLocalService.deleteOrganization(organization);
        }

        protected void performActions() throws PortalException {
            this._actionableDynamicQuery.performActions();
        }

        protected void setCompanyId(long companyId) {
            this._actionableDynamicQuery.setCompanyId(companyId);
        }
    }

    protected class DeleteGroupActionableDynamicQuery {
        private ActionableDynamicQuery _actionableDynamicQuery;
        private long _parentGroupId = 0L;

        protected DeleteGroupActionableDynamicQuery() {
            this._actionableDynamicQuery = CompanyLocalServiceImpl.this.groupLocalService.getActionableDynamicQuery();
            this._actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
                Property parentGroupIdProperty = PropertyFactoryUtil.forName((String)"parentGroupId");
                dynamicQuery.add(parentGroupIdProperty.eq((Object)this._parentGroupId));
                Property siteProperty = PropertyFactoryUtil.forName((String)"site");
                dynamicQuery.add(siteProperty.eq((Object)Boolean.TRUE));
            });
            this._actionableDynamicQuery.setPerformActionMethod(group -> {
                if (!(PortalUtil.isSystemGroup((String)group.getGroupKey()) || group.isCompany() || group.isStagingGroup())) {
                    this.deleteGroup((Group)group);
                }
            });
        }

        protected void deleteGroup(Group group) throws PortalException {
            DeleteGroupActionableDynamicQuery deleteGroupActionableDynamicQuery = new DeleteGroupActionableDynamicQuery();
            deleteGroupActionableDynamicQuery.setCompanyId(group.getCompanyId());
            deleteGroupActionableDynamicQuery.setParentGroupId(group.getGroupId());
            deleteGroupActionableDynamicQuery.performActions();
            CompanyLocalServiceImpl.this.groupLocalService.deleteGroup(group);
            LiveUsers.deleteGroup(group.getCompanyId(), group.getGroupId());
        }

        protected void performActions() throws PortalException {
            this._actionableDynamicQuery.performActions();
        }

        protected void setCompanyId(long companyId) {
            this._actionableDynamicQuery.setCompanyId(companyId);
        }

        protected void setParentGroupId(long parentGroupId) {
            this._parentGroupId = parentGroupId;
        }
    }

    protected class DeleteExpandoTableActionableDynamicQuery {
        private ActionableDynamicQuery _actionableDynamicQuery;

        protected DeleteExpandoTableActionableDynamicQuery(long companyId) {
            this._actionableDynamicQuery = CompanyLocalServiceImpl.this.expandoTableLocalService.getActionableDynamicQuery();
            this._actionableDynamicQuery.setCompanyId(companyId);
            this._actionableDynamicQuery.setPerformActionMethod(expandoTable -> CompanyLocalServiceImpl.this.expandoTableLocalService.deleteExpandoTable(expandoTable));
        }

        protected void performActions() throws PortalException {
            this._actionableDynamicQuery.performActions();
        }
    }

    protected class DeleteExpandoColumnActionableDynamicQuery {
        private ActionableDynamicQuery _actionableDynamicQuery;

        protected DeleteExpandoColumnActionableDynamicQuery(long companyId) {
            this._actionableDynamicQuery = CompanyLocalServiceImpl.this.expandoColumnLocalService.getActionableDynamicQuery();
            this._actionableDynamicQuery.setCompanyId(companyId);
            this._actionableDynamicQuery.setPerformActionMethod(expandoColumn -> CompanyLocalServiceImpl.this.expandoColumnLocalService.deleteExpandoColumn(expandoColumn));
        }

        protected void performActions() throws PortalException {
            this._actionableDynamicQuery.performActions();
        }
    }
}

