/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.service.base.LayoutSetServiceBaseImpl;
import java.io.File;
import java.io.InputStream;
import java.util.TreeMap;

public class LayoutSetServiceImpl
extends LayoutSetServiceBaseImpl {
    public void updateLayoutSetPrototypeLinkEnabled(long groupId, boolean privateLayout, boolean layoutSetPrototypeLinkEnabled, String layoutSetPrototypeUuid) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"UPDATE");
        LayoutSet layoutSet = this.layoutSetLocalService.getLayoutSet(groupId, privateLayout);
        if (layoutSet.isLayoutSetPrototypeLinkEnabled() && !layoutSetPrototypeLinkEnabled) {
            PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"UNLINK_LAYOUT_SET_PROTOTYPE");
        }
        this.layoutSetLocalService.updateLayoutSetPrototypeLinkEnabled(groupId, privateLayout, layoutSetPrototypeLinkEnabled, layoutSetPrototypeUuid);
    }

    public void updateLogo(long groupId, boolean privateLayout, boolean hasLogo, byte[] bytes) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"MANAGE_LAYOUTS");
        this.layoutSetLocalService.updateLogo(groupId, privateLayout, hasLogo, bytes);
    }

    public void updateLogo(long groupId, boolean privateLayout, boolean hasLogo, File file) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"MANAGE_LAYOUTS");
        this.layoutSetLocalService.updateLogo(groupId, privateLayout, hasLogo, file);
    }

    public void updateLogo(long groupId, boolean privateLayout, boolean hasLogo, InputStream inputStream) throws PortalException {
        this.updateLogo(groupId, privateLayout, hasLogo, inputStream, true);
    }

    public void updateLogo(long groupId, boolean privateLayout, boolean hasLogo, InputStream inputStream, boolean cleanUpStream) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"MANAGE_LAYOUTS");
        this.layoutSetLocalService.updateLogo(groupId, privateLayout, hasLogo, inputStream, cleanUpStream);
    }

    public LayoutSet updateLookAndFeel(long groupId, boolean privateLayout, String themeId, String colorSchemeId, String css) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"MANAGE_LAYOUTS");
        this.pluginSettingLocalService.checkPermission(this.getUserId(), themeId, "theme");
        return this.layoutSetLocalService.updateLookAndFeel(groupId, privateLayout, themeId, colorSchemeId, css);
    }

    public LayoutSet updateSettings(long groupId, boolean privateLayout, String settings) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"MANAGE_LAYOUTS");
        return this.layoutSetLocalService.updateSettings(groupId, privateLayout, settings);
    }

    public LayoutSet updateVirtualHosts(long groupId, boolean privateLayout, TreeMap<String, String> virtualHostnames) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"UPDATE");
        return this.layoutSetLocalService.updateVirtualHosts(groupId, privateLayout, virtualHostnames);
    }
}

