/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.NoSuchListTypeException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.model.ListType;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.service.base.ListTypeLocalServiceBaseImpl;
import java.util.List;
import java.util.Objects;

public class ListTypeLocalServiceImpl
extends ListTypeLocalServiceBaseImpl {
    public ListType addListType(String name, String type) {
        ListType listType = this.listTypePersistence.fetchByN_T(name, type);
        if (listType != null) {
            return listType;
        }
        long listTypeId = this.counterLocalService.increment(ListType.class.getName());
        listType = this.listTypePersistence.create(listTypeId);
        listType.setName(name);
        listType.setType(type);
        return (ListType)this.listTypePersistence.update((BaseModel)listType);
    }

    @Override
    public ListType getListType(long listTypeId) throws PortalException {
        return this.listTypePersistence.findByPrimaryKey(listTypeId);
    }

    public ListType getListType(String name, String type) {
        return this.listTypePersistence.fetchByN_T(name, type);
    }

    public List<ListType> getListTypes(String type) {
        return this.listTypePersistence.findByType(type);
    }

    @Transactional(readOnly=true)
    public void validate(long listTypeId, long classNameId, String type) throws PortalException {
        ClassName className = this.classNameLocalService.getClassName(classNameId);
        this.validate(listTypeId, className.getValue() + type);
    }

    @Transactional(readOnly=true)
    public void validate(long listTypeId, String type) throws PortalException {
        ListType listType = this.listTypePersistence.fetchByPrimaryKey(listTypeId);
        if (listType == null || !Objects.equals(listType.getType(), type)) {
            NoSuchListTypeException noSuchListTypeException = new NoSuchListTypeException();
            noSuchListTypeException.setType(type);
            throw noSuchListTypeException;
        }
    }
}

