/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.LayoutTemplate;
import com.liferay.portal.kernel.model.PluginSetting;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.model.impl.PluginSettingImpl;
import com.liferay.portal.service.base.PluginSettingLocalServiceBaseImpl;

public class PluginSettingLocalServiceImpl
extends PluginSettingLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(PluginSettingLocalServiceImpl.class);

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public void checkPermission(long userId, String pluginId, String pluginType) throws PortalException {
        if (!this.hasPermission(userId, pluginId, pluginType)) {
            throw new PrincipalException.MustHavePermission(userId, new String[]{pluginType, pluginId});
        }
    }

    @Transactional(enabled=false)
    public PluginSetting getDefaultPluginSetting() {
        PluginSettingImpl pluginSettingImpl = new PluginSettingImpl();
        pluginSettingImpl.setRoles("");
        pluginSettingImpl.setActive(true);
        return pluginSettingImpl;
    }

    public PluginSetting getPluginSetting(long companyId, String pluginId, String pluginType) {
        PluginSetting pluginSetting = this.pluginSettingPersistence.fetchByC_I_T(companyId, pluginId, pluginType);
        if (pluginSetting != null) {
            return pluginSetting;
        }
        LayoutTemplate plugin = null;
        if (pluginType.equals("layouttpl")) {
            plugin = this.layoutTemplateLocalService.getLayoutTemplate(pluginId, false, null);
        } else if (pluginType.equals("theme")) {
            plugin = this.themeLocalService.getTheme(companyId, pluginId);
        }
        if (plugin == null || plugin.getDefaultPluginSetting() == null) {
            pluginSetting = this.getDefaultPluginSetting();
            pluginSetting.setCompanyId(companyId);
        } else {
            pluginSetting = plugin.getDefaultPluginSetting(companyId);
        }
        return pluginSetting;
    }

    public boolean hasPermission(long userId, String pluginId, String pluginType) {
        try {
            User user = this.userPersistence.findByPrimaryKey(userId);
            PluginSetting pluginSetting = this.getPluginSetting(user.getCompanyId(), pluginId, pluginType);
            return pluginSetting.hasPermission(userId);
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Could not check permissions for " + pluginId), (Throwable)exception);
            }
            return false;
        }
    }

    public PluginSetting updatePluginSetting(long companyId, String pluginId, String pluginType, String roles, boolean active) {
        PluginSetting pluginSetting = this.pluginSettingPersistence.fetchByC_I_T(companyId, pluginId = PortalUtil.getJsSafePortletId((String)pluginId), pluginType);
        if (pluginSetting == null) {
            long pluginSettingId = this.counterLocalService.increment();
            pluginSetting = this.pluginSettingPersistence.create(pluginSettingId);
            pluginSetting.setCompanyId(companyId);
            pluginSetting.setPluginId(pluginId);
            pluginSetting.setPluginType(pluginType);
        }
        pluginSetting.setRoles(roles);
        pluginSetting.setActive(active);
        return (PluginSetting)this.pluginSettingPersistence.update((BaseModel)pluginSetting);
    }
}

