/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.NoSuchRepositoryEntryException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.RepositoryEntry;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.service.base.RepositoryEntryLocalServiceBaseImpl;
import java.util.List;

public class RepositoryEntryLocalServiceImpl
extends RepositoryEntryLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(RepositoryEntryLocalServiceImpl.class);

    public RepositoryEntry addRepositoryEntry(long userId, long groupId, long repositoryId, String mappedId, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long repositoryEntryId = this.counterLocalService.increment();
        RepositoryEntry repositoryEntry = this.repositoryEntryPersistence.create(repositoryEntryId);
        repositoryEntry.setUuid(serviceContext.getUuid());
        repositoryEntry.setGroupId(groupId);
        repositoryEntry.setCompanyId(user.getCompanyId());
        repositoryEntry.setUserId(userId);
        repositoryEntry.setUserName(user.getFullName());
        repositoryEntry.setRepositoryId(repositoryId);
        repositoryEntry.setMappedId(mappedId);
        return (RepositoryEntry)this.repositoryEntryPersistence.update((BaseModel)repositoryEntry);
    }

    public void deleteRepositoryEntries(long repositoryId, Iterable<String> mappedIds) throws PortalException {
        for (String mappedId : mappedIds) {
            try {
                this.deleteRepositoryEntry(repositoryId, mappedId);
            }
            catch (NoSuchRepositoryEntryException noSuchRepositoryEntryException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)noSuchRepositoryEntryException, (Throwable)noSuchRepositoryEntryException);
            }
        }
    }

    public void deleteRepositoryEntry(long repositoryId, String mappedId) throws PortalException {
        this.repositoryEntryPersistence.removeByR_M(repositoryId, mappedId);
    }

    public List<RepositoryEntry> getRepositoryEntries(long repositoryId) {
        return this.repositoryEntryPersistence.findByRepositoryId(repositoryId);
    }

    public RepositoryEntry getRepositoryEntry(long userId, long groupId, long repositoryId, String objectId) throws PortalException {
        RepositoryEntry repositoryEntry = this.repositoryEntryPersistence.fetchByR_M(repositoryId, objectId);
        if (repositoryEntry != null) {
            return repositoryEntry;
        }
        return this.addRepositoryEntry(userId, groupId, repositoryId, objectId, new ServiceContext());
    }

    public RepositoryEntry getRepositoryEntry(String uuid, long groupId) throws PortalException {
        return this.repositoryEntryPersistence.findByUUID_G(uuid, groupId);
    }

    public RepositoryEntry updateRepositoryEntry(long repositoryEntryId, String mappedId) throws PortalException {
        RepositoryEntry repositoryEntry = this.repositoryEntryPersistence.findByPrimaryKey(repositoryEntryId);
        repositoryEntry.setMappedId(mappedId);
        return (RepositoryEntry)this.repositoryEntryPersistence.update((BaseModel)repositoryEntry);
    }
}

