/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.NoSuchRepositoryException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.repository.InvalidRepositoryIdException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionUtil;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.repository.registry.RepositoryClassDefinitionCatalog;
import com.liferay.portal.service.base.RepositoryServiceBaseImpl;

public class RepositoryServiceImpl
extends RepositoryServiceBaseImpl {
    private static volatile ModelResourcePermission<FileEntry> _fileEntryModelResourcePermission = ModelResourcePermissionFactory.getInstance(RepositoryServiceImpl.class, (String)"_fileEntryModelResourcePermission", FileEntry.class);
    private static volatile ModelResourcePermission<Folder> _folderModelResourcePermission = ModelResourcePermissionFactory.getInstance(RepositoryServiceImpl.class, (String)"_folderModelResourcePermission", Folder.class);
    private static volatile PortletResourcePermission _portletResourcePermission = PortletResourcePermissionFactory.getInstance(RepositoryServiceImpl.class, (String)"_portletResourcePermission", (String)"com.liferay.document.library");
    @BeanReference(type=RepositoryClassDefinitionCatalog.class)
    private RepositoryClassDefinitionCatalog _repositoryClassDefinitionCatalog;

    public Repository addRepository(long groupId, long classNameId, long parentFolderId, String name, String description, String portletId, UnicodeProperties typeSettingsUnicodeProperties, ServiceContext serviceContext) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "ADD_REPOSITORY");
        return this.repositoryLocalService.addRepository(this.getUserId(), groupId, classNameId, parentFolderId, name, description, portletId, typeSettingsUnicodeProperties, false, serviceContext);
    }

    public void checkRepository(long repositoryId) throws PortalException {
        this.checkRepository(repositoryId, 0L, 0L, 0L);
    }

    public void deleteRepository(long repositoryId) throws PortalException {
        Repository repository = this.repositoryPersistence.findByPrimaryKey(repositoryId);
        ModelResourcePermissionUtil.check(_folderModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)repository.getGroupId(), (long)repository.getDlFolderId(), (String)"DELETE");
        this.repositoryLocalService.deleteRepository(repository.getRepositoryId());
    }

    public Repository getRepository(long repositoryId) throws PortalException {
        Repository repository = this.repositoryPersistence.findByPrimaryKey(repositoryId);
        ModelResourcePermissionUtil.check(_folderModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)repository.getGroupId(), (long)repository.getDlFolderId(), (String)"VIEW");
        return repository;
    }

    public Repository getRepository(long groupId, String portletId) throws PortalException {
        Repository repository = this.repositoryPersistence.findByG_N_P(groupId, portletId, portletId);
        ModelResourcePermissionUtil.check(_folderModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)repository.getGroupId(), (long)repository.getDlFolderId(), (String)"VIEW");
        return repository;
    }

    public UnicodeProperties getTypeSettingsProperties(long repositoryId) throws PortalException {
        this.checkRepository(repositoryId);
        return this.repositoryLocalService.getTypeSettingsProperties(repositoryId);
    }

    public void updateRepository(long repositoryId, String name, String description) throws PortalException {
        Repository repository = this.repositoryPersistence.findByPrimaryKey(repositoryId);
        ModelResourcePermissionUtil.check(_folderModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)repository.getGroupId(), (long)repository.getDlFolderId(), (String)"UPDATE");
        this.repositoryLocalService.updateRepository(repositoryId, name, description);
    }

    protected void checkModelPermissions(long folderId, long fileEntryId, long fileVersionId) throws PortalException {
        DLFileVersion dlFileVersion;
        if (folderId != 0L) {
            DLFolder dlFolder = this.dlFolderLocalService.fetchDLFolder(folderId);
            if (dlFolder != null) {
                _folderModelResourcePermission.check(this.getPermissionChecker(), folderId, "VIEW");
            }
        } else if (fileEntryId != 0L) {
            DLFileEntry dlFileEntry = this.dlFileEntryLocalService.fetchDLFileEntry(fileEntryId);
            if (dlFileEntry != null) {
                _fileEntryModelResourcePermission.check(this.getPermissionChecker(), fileEntryId, "VIEW");
            }
        } else if (fileVersionId != 0L && (dlFileVersion = this.dlFileVersionLocalService.fetchDLFileVersion(fileVersionId)) != null) {
            _fileEntryModelResourcePermission.check(this.getPermissionChecker(), dlFileVersion.getFileEntryId(), "VIEW");
        }
    }

    protected void checkRepository(long repositoryId, long folderId, long fileEntryId, long fileVersionId) throws PortalException {
        Group group = this.groupPersistence.fetchByPrimaryKey(repositoryId);
        if (group != null) {
            this.checkModelPermissions(folderId, fileEntryId, fileVersionId);
            return;
        }
        try {
            Repository repository = this.repositoryPersistence.fetchByPrimaryKey(repositoryId);
            if (repository != null) {
                ModelResourcePermissionUtil.check(_folderModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)repository.getGroupId(), (long)repository.getDlFolderId(), (String)"VIEW");
            }
        }
        catch (NoSuchRepositoryException noSuchRepositoryException) {
            throw new InvalidRepositoryIdException(noSuchRepositoryException.getMessage());
        }
    }
}

