/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.model.UserGroupGroupRole;
import com.liferay.portal.service.base.UserGroupGroupRoleLocalServiceBaseImpl;
import java.util.List;

public class UserGroupGroupRoleLocalServiceImpl
extends UserGroupGroupRoleLocalServiceBaseImpl {
    public void addUserGroupGroupRoles(long userGroupId, long groupId, long[] roleIds) {
        for (long roleId : roleIds) {
            UserGroupGroupRole userGroupGroupRole = this.userGroupGroupRolePersistence.fetchByU_G_R(userGroupId, groupId, roleId);
            if (userGroupGroupRole != null) continue;
            userGroupGroupRole = this.userGroupGroupRolePersistence.create(this.counterLocalService.increment(UserGroupGroupRole.class.getName()));
            userGroupGroupRole.setUserGroupId(userGroupId);
            userGroupGroupRole.setGroupId(groupId);
            userGroupGroupRole.setRoleId(roleId);
            this.userGroupGroupRolePersistence.update((BaseModel)userGroupGroupRole);
        }
    }

    public void addUserGroupGroupRoles(long[] userGroupIds, long groupId, long roleId) {
        for (long userGroupId : userGroupIds) {
            UserGroupGroupRole userGroupGroupRole = this.userGroupGroupRolePersistence.fetchByU_G_R(userGroupId, groupId, roleId);
            if (userGroupGroupRole != null) continue;
            userGroupGroupRole = this.userGroupGroupRolePersistence.create(this.counterLocalService.increment(UserGroupGroupRole.class.getName()));
            userGroupGroupRole.setUserGroupId(userGroupId);
            userGroupGroupRole.setGroupId(groupId);
            userGroupGroupRole.setRoleId(roleId);
            this.userGroupGroupRolePersistence.update((BaseModel)userGroupGroupRole);
        }
    }

    public void deleteUserGroupGroupRoles(long groupId, int roleType) {
        List userGroupGroupRoles = this.userGroupGroupRoleFinder.findByGroupRoleType(groupId, roleType);
        for (UserGroupGroupRole userGroupGroupRole : userGroupGroupRoles) {
            this.userGroupGroupRolePersistence.removeByG_R(groupId, userGroupGroupRole.getRoleId());
        }
    }

    public void deleteUserGroupGroupRoles(long userGroupId, long groupId, long[] roleIds) {
        for (long roleId : roleIds) {
            UserGroupGroupRole userGroupGroupRole = this.userGroupGroupRolePersistence.fetchByU_G_R(userGroupId, groupId, roleId);
            if (userGroupGroupRole == null) continue;
            this.userGroupGroupRolePersistence.remove((BaseModel)userGroupGroupRole);
        }
    }

    public void deleteUserGroupGroupRoles(long userGroupId, long[] groupIds) {
        for (long groupId : groupIds) {
            this.userGroupGroupRolePersistence.removeByU_G(userGroupId, groupId);
        }
    }

    public void deleteUserGroupGroupRoles(long[] userGroupIds, long groupId) {
        for (long userGroupId : userGroupIds) {
            this.userGroupGroupRolePersistence.removeByU_G(userGroupId, groupId);
        }
    }

    public void deleteUserGroupGroupRoles(long[] userGroupIds, long groupId, long roleId) {
        for (long userGroupId : userGroupIds) {
            UserGroupGroupRole userGroupGroupRole = this.userGroupGroupRolePersistence.fetchByU_G_R(userGroupId, groupId, roleId);
            if (userGroupGroupRole == null) continue;
            this.userGroupGroupRolePersistence.remove((BaseModel)userGroupGroupRole);
        }
    }

    public void deleteUserGroupGroupRolesByGroupId(long groupId) {
        this.userGroupGroupRolePersistence.removeByGroupId(groupId);
    }

    public void deleteUserGroupGroupRolesByRoleId(long roleId) {
        this.userGroupGroupRolePersistence.removeByRoleId(roleId);
    }

    public void deleteUserGroupGroupRolesByUserGroupId(long userGroupId) {
        this.userGroupGroupRolePersistence.removeByUserGroupId(userGroupId);
    }

    public List<UserGroupGroupRole> getUserGroupGroupRoles(long userGroupId) {
        return this.userGroupGroupRolePersistence.findByUserGroupId(userGroupId);
    }

    public List<UserGroupGroupRole> getUserGroupGroupRoles(long userGroupId, long groupId) {
        return this.userGroupGroupRolePersistence.findByU_G(userGroupId, groupId);
    }

    public List<UserGroupGroupRole> getUserGroupGroupRolesByGroupAndRole(long groupId, long roleId) {
        return this.userGroupGroupRolePersistence.findByG_R(groupId, roleId);
    }

    public List<UserGroupGroupRole> getUserGroupGroupRolesByUser(long userId) {
        return this.userGroupGroupRoleFinder.findByUserGroupsUsers(userId);
    }

    public List<UserGroupGroupRole> getUserGroupGroupRolesByUser(long userId, long groupId) {
        return this.userGroupGroupRoleFinder.findByUserGroupsUsers(userId, groupId);
    }

    public boolean hasUserGroupGroupRole(long userGroupId, long groupId, long roleId) {
        int count = this.userGroupGroupRolePersistence.countByU_G_R(userGroupId, groupId, roleId);
        return count > 0;
    }

    public boolean hasUserGroupGroupRole(long userGroupId, long groupId, String roleName) throws PortalException {
        UserGroup userGroup = this.userGroupPersistence.findByPrimaryKey(userGroupId);
        Role role = this.rolePersistence.findByC_N(userGroup.getCompanyId(), roleName);
        return this.hasUserGroupGroupRole(userGroupId, groupId, role.getRoleId());
    }
}

