/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.NoSuchRepositoryException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.RepositoryTable;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.RepositoryPersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.model.impl.RepositoryImpl;
import com.liferay.portal.model.impl.RepositoryModelImpl;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceRegistration;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class RepositoryPersistenceImpl
extends BasePersistenceImpl<Repository>
implements RepositoryPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = RepositoryImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByUuid;
    private FinderPath _finderPathWithoutPaginationFindByUuid;
    private FinderPath _finderPathCountByUuid;
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "repository.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(repository.uuid IS NULL OR repository.uuid = '')";
    private FinderPath _finderPathFetchByUUID_G;
    private FinderPath _finderPathCountByUUID_G;
    private static final String _FINDER_COLUMN_UUID_G_UUID_2 = "repository.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_G_UUID_3 = "(repository.uuid IS NULL OR repository.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_G_GROUPID_2 = "repository.groupId = ?";
    private FinderPath _finderPathWithPaginationFindByUuid_C;
    private FinderPath _finderPathWithoutPaginationFindByUuid_C;
    private FinderPath _finderPathCountByUuid_C;
    private static final String _FINDER_COLUMN_UUID_C_UUID_2 = "repository.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_3 = "(repository.uuid IS NULL OR repository.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_C_COMPANYID_2 = "repository.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByGroupId;
    private FinderPath _finderPathWithoutPaginationFindByGroupId;
    private FinderPath _finderPathCountByGroupId;
    private static final String _FINDER_COLUMN_GROUPID_GROUPID_2 = "repository.groupId = ?";
    private FinderPath _finderPathFetchByG_N_P;
    private FinderPath _finderPathCountByG_N_P;
    private static final String _FINDER_COLUMN_G_N_P_GROUPID_2 = "repository.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_N_P_NAME_2 = "repository.name = ? AND ";
    private static final String _FINDER_COLUMN_G_N_P_NAME_3 = "(repository.name IS NULL OR repository.name = '') AND ";
    private static final String _FINDER_COLUMN_G_N_P_PORTLETID_2 = "repository.portletId = ?";
    private static final String _FINDER_COLUMN_G_N_P_PORTLETID_3 = "(repository.portletId IS NULL OR repository.portletId = '')";
    private static final String _SQL_SELECT_REPOSITORY = "SELECT repository FROM Repository repository";
    private static final String _SQL_SELECT_REPOSITORY_WHERE = "SELECT repository FROM Repository repository WHERE ";
    private static final String _SQL_COUNT_REPOSITORY = "SELECT COUNT(repository) FROM Repository repository";
    private static final String _SQL_COUNT_REPOSITORY_WHERE = "SELECT COUNT(repository) FROM Repository repository WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "repository.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Repository exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Repository exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(RepositoryPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"uuid"});
    private ServiceRegistration<ArgumentsResolver> _argumentsResolverServiceRegistration;

    public List<Repository> findByUuid(String uuid) {
        return this.findByUuid(uuid, -1, -1, null);
    }

    public List<Repository> findByUuid(String uuid, int start, int end) {
        return this.findByUuid(uuid, start, end, null);
    }

    public List<Repository> findByUuid(String uuid, int start, int end, OrderByComparator<Repository> orderByComparator) {
        return this.findByUuid(uuid, start, end, orderByComparator, true);
    }

    public List<Repository> findByUuid(String uuid, int start, int end, OrderByComparator<Repository> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid;
                finderArgs = new Object[]{uuid};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid;
            finderArgs = new Object[]{uuid, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)FinderCacheUtil.getResult((FinderPath)finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (Repository repository : list) {
                if (uuid.equals(repository.getUuid())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_REPOSITORY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY repository.repositoryId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Repository findByUuid_First(String uuid, OrderByComparator<Repository> orderByComparator) throws NoSuchRepositoryException {
        Repository repository = this.fetchByUuid_First(uuid, orderByComparator);
        if (repository != null) {
            return repository;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchRepositoryException(sb.toString());
    }

    public Repository fetchByUuid_First(String uuid, OrderByComparator<Repository> orderByComparator) {
        List<Repository> list = this.findByUuid(uuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Repository findByUuid_Last(String uuid, OrderByComparator<Repository> orderByComparator) throws NoSuchRepositoryException {
        Repository repository = this.fetchByUuid_Last(uuid, orderByComparator);
        if (repository != null) {
            return repository;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchRepositoryException(sb.toString());
    }

    public Repository fetchByUuid_Last(String uuid, OrderByComparator<Repository> orderByComparator) {
        int count = this.countByUuid(uuid);
        if (count == 0) {
            return null;
        }
        List<Repository> list = this.findByUuid(uuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Repository[] findByUuid_PrevAndNext(long repositoryId, String uuid, OrderByComparator<Repository> orderByComparator) throws NoSuchRepositoryException {
        uuid = Objects.toString(uuid, "");
        Repository repository = this.findByPrimaryKey(repositoryId);
        Session session = null;
        try {
            session = this.openSession();
            Repository[] array = new RepositoryImpl[]{this.getByUuid_PrevAndNext(session, repository, uuid, orderByComparator, true), repository, this.getByUuid_PrevAndNext(session, repository, uuid, orderByComparator, false)};
            Repository[] repositoryArray = array;
            return repositoryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Repository getByUuid_PrevAndNext(Session session, Repository repository, String uuid, OrderByComparator<Repository> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_REPOSITORY_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_UUID_3);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_UUID_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY repository.repositoryId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)repository)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (Repository)list.get(1);
        }
        return null;
    }

    public void removeByUuid(String uuid) {
        for (Repository repository : this.findByUuid(uuid, -1, -1, null)) {
            this.remove((BaseModel)repository);
        }
    }

    public int countByUuid(String uuid) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid;
        Object[] finderArgs = new Object[]{uuid};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_REPOSITORY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                count = (Long)query.uniqueResult();
                FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Repository findByUUID_G(String uuid, long groupId) throws NoSuchRepositoryException {
        Repository repository = this.fetchByUUID_G(uuid, groupId);
        if (repository == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("uuid=");
            sb.append(uuid);
            sb.append(", groupId=");
            sb.append(groupId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchRepositoryException(sb.toString());
        }
        return repository;
    }

    public Repository fetchByUUID_G(String uuid, long groupId) {
        return this.fetchByUUID_G(uuid, groupId, true);
    }

    public Repository fetchByUUID_G(String uuid, long groupId, boolean useFinderCache) {
        Repository repository;
        uuid = Objects.toString(uuid, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{uuid, groupId};
        }
        Object result = null;
        if (useFinderCache) {
            result = FinderCacheUtil.getResult((FinderPath)this._finderPathFetchByUUID_G, finderArgs);
        }
        if (result instanceof Repository && (!Objects.equals(uuid, (repository = (Repository)result).getUuid()) || groupId != repository.getGroupId())) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_REPOSITORY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(repository.uuid IS NULL OR repository.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("repository.uuid = ? AND ");
            }
            sb.append("repository.groupId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(groupId);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache) {
                        FinderCacheUtil.putResult((FinderPath)this._finderPathFetchByUUID_G, (Object[])finderArgs, (Object)list);
                    }
                } else {
                    Repository repository2 = (Repository)list.get(0);
                    result = repository2;
                    this.cacheResult(repository2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Repository)result;
    }

    public Repository removeByUUID_G(String uuid, long groupId) throws NoSuchRepositoryException {
        Repository repository = this.findByUUID_G(uuid, groupId);
        return (Repository)this.remove((BaseModel)repository);
    }

    public int countByUUID_G(String uuid, long groupId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUUID_G;
        Object[] finderArgs = new Object[]{uuid, groupId};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_REPOSITORY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(repository.uuid IS NULL OR repository.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("repository.uuid = ? AND ");
            }
            sb.append("repository.groupId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(groupId);
                count = (Long)query.uniqueResult();
                FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<Repository> findByUuid_C(String uuid, long companyId) {
        return this.findByUuid_C(uuid, companyId, -1, -1, null);
    }

    public List<Repository> findByUuid_C(String uuid, long companyId, int start, int end) {
        return this.findByUuid_C(uuid, companyId, start, end, null);
    }

    public List<Repository> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<Repository> orderByComparator) {
        return this.findByUuid_C(uuid, companyId, start, end, orderByComparator, true);
    }

    public List<Repository> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<Repository> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid_C;
                finderArgs = new Object[]{uuid, companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid_C;
            finderArgs = new Object[]{uuid, companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)FinderCacheUtil.getResult((FinderPath)finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (Repository repository : list) {
                if (uuid.equals(repository.getUuid()) && companyId == repository.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_REPOSITORY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(repository.uuid IS NULL OR repository.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("repository.uuid = ? AND ");
            }
            sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY repository.repositoryId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Repository findByUuid_C_First(String uuid, long companyId, OrderByComparator<Repository> orderByComparator) throws NoSuchRepositoryException {
        Repository repository = this.fetchByUuid_C_First(uuid, companyId, orderByComparator);
        if (repository != null) {
            return repository;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchRepositoryException(sb.toString());
    }

    public Repository fetchByUuid_C_First(String uuid, long companyId, OrderByComparator<Repository> orderByComparator) {
        List<Repository> list = this.findByUuid_C(uuid, companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Repository findByUuid_C_Last(String uuid, long companyId, OrderByComparator<Repository> orderByComparator) throws NoSuchRepositoryException {
        Repository repository = this.fetchByUuid_C_Last(uuid, companyId, orderByComparator);
        if (repository != null) {
            return repository;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchRepositoryException(sb.toString());
    }

    public Repository fetchByUuid_C_Last(String uuid, long companyId, OrderByComparator<Repository> orderByComparator) {
        int count = this.countByUuid_C(uuid, companyId);
        if (count == 0) {
            return null;
        }
        List<Repository> list = this.findByUuid_C(uuid, companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Repository[] findByUuid_C_PrevAndNext(long repositoryId, String uuid, long companyId, OrderByComparator<Repository> orderByComparator) throws NoSuchRepositoryException {
        uuid = Objects.toString(uuid, "");
        Repository repository = this.findByPrimaryKey(repositoryId);
        Session session = null;
        try {
            session = this.openSession();
            Repository[] array = new RepositoryImpl[]{this.getByUuid_C_PrevAndNext(session, repository, uuid, companyId, orderByComparator, true), repository, this.getByUuid_C_PrevAndNext(session, repository, uuid, companyId, orderByComparator, false)};
            Repository[] repositoryArray = array;
            return repositoryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Repository getByUuid_C_PrevAndNext(Session session, Repository repository, String uuid, long companyId, OrderByComparator<Repository> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_REPOSITORY_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append("(repository.uuid IS NULL OR repository.uuid = '') AND ");
        } else {
            bindUuid = true;
            sb.append("repository.uuid = ? AND ");
        }
        sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY repository.repositoryId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)repository)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (Repository)list.get(1);
        }
        return null;
    }

    public void removeByUuid_C(String uuid, long companyId) {
        for (Repository repository : this.findByUuid_C(uuid, companyId, -1, -1, null)) {
            this.remove((BaseModel)repository);
        }
    }

    public int countByUuid_C(String uuid, long companyId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid_C;
        Object[] finderArgs = new Object[]{uuid, companyId};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_REPOSITORY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(repository.uuid IS NULL OR repository.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("repository.uuid = ? AND ");
            }
            sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<Repository> findByGroupId(long groupId) {
        return this.findByGroupId(groupId, -1, -1, null);
    }

    public List<Repository> findByGroupId(long groupId, int start, int end) {
        return this.findByGroupId(groupId, start, end, null);
    }

    public List<Repository> findByGroupId(long groupId, int start, int end, OrderByComparator<Repository> orderByComparator) {
        return this.findByGroupId(groupId, start, end, orderByComparator, true);
    }

    public List<Repository> findByGroupId(long groupId, int start, int end, OrderByComparator<Repository> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByGroupId;
                finderArgs = new Object[]{groupId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByGroupId;
            finderArgs = new Object[]{groupId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)FinderCacheUtil.getResult((FinderPath)finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (Repository repository : list) {
                if (groupId == repository.getGroupId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_REPOSITORY_WHERE);
            sb.append("repository.groupId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY repository.repositoryId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Repository findByGroupId_First(long groupId, OrderByComparator<Repository> orderByComparator) throws NoSuchRepositoryException {
        Repository repository = this.fetchByGroupId_First(groupId, orderByComparator);
        if (repository != null) {
            return repository;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append("}");
        throw new NoSuchRepositoryException(sb.toString());
    }

    public Repository fetchByGroupId_First(long groupId, OrderByComparator<Repository> orderByComparator) {
        List<Repository> list = this.findByGroupId(groupId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Repository findByGroupId_Last(long groupId, OrderByComparator<Repository> orderByComparator) throws NoSuchRepositoryException {
        Repository repository = this.fetchByGroupId_Last(groupId, orderByComparator);
        if (repository != null) {
            return repository;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append("}");
        throw new NoSuchRepositoryException(sb.toString());
    }

    public Repository fetchByGroupId_Last(long groupId, OrderByComparator<Repository> orderByComparator) {
        int count = this.countByGroupId(groupId);
        if (count == 0) {
            return null;
        }
        List<Repository> list = this.findByGroupId(groupId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Repository[] findByGroupId_PrevAndNext(long repositoryId, long groupId, OrderByComparator<Repository> orderByComparator) throws NoSuchRepositoryException {
        Repository repository = this.findByPrimaryKey(repositoryId);
        Session session = null;
        try {
            session = this.openSession();
            Repository[] array = new RepositoryImpl[]{this.getByGroupId_PrevAndNext(session, repository, groupId, orderByComparator, true), repository, this.getByGroupId_PrevAndNext(session, repository, groupId, orderByComparator, false)};
            Repository[] repositoryArray = array;
            return repositoryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Repository getByGroupId_PrevAndNext(Session session, Repository repository, long groupId, OrderByComparator<Repository> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_REPOSITORY_WHERE);
        sb.append("repository.groupId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY repository.repositoryId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(groupId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)repository)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (Repository)list.get(1);
        }
        return null;
    }

    public void removeByGroupId(long groupId) {
        for (Repository repository : this.findByGroupId(groupId, -1, -1, null)) {
            this.remove((BaseModel)repository);
        }
    }

    public int countByGroupId(long groupId) {
        FinderPath finderPath = this._finderPathCountByGroupId;
        Object[] finderArgs = new Object[]{groupId};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_REPOSITORY_WHERE);
            sb.append("repository.groupId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                count = (Long)query.uniqueResult();
                FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Repository findByG_N_P(long groupId, String name, String portletId) throws NoSuchRepositoryException {
        Repository repository = this.fetchByG_N_P(groupId, name, portletId);
        if (repository == null) {
            StringBundler sb = new StringBundler(8);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("groupId=");
            sb.append(groupId);
            sb.append(", name=");
            sb.append(name);
            sb.append(", portletId=");
            sb.append(portletId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchRepositoryException(sb.toString());
        }
        return repository;
    }

    public Repository fetchByG_N_P(long groupId, String name, String portletId) {
        return this.fetchByG_N_P(groupId, name, portletId, true);
    }

    public Repository fetchByG_N_P(long groupId, String name, String portletId, boolean useFinderCache) {
        Repository repository;
        name = Objects.toString(name, "");
        portletId = Objects.toString(portletId, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{groupId, name, portletId};
        }
        Object result = null;
        if (useFinderCache) {
            result = FinderCacheUtil.getResult((FinderPath)this._finderPathFetchByG_N_P, finderArgs);
        }
        if (!(!(result instanceof Repository) || groupId == (repository = (Repository)result).getGroupId() && Objects.equals(name, repository.getName()) && Objects.equals(portletId, repository.getPortletId()))) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(5);
            sb.append(_SQL_SELECT_REPOSITORY_WHERE);
            sb.append(_FINDER_COLUMN_G_N_P_GROUPID_2);
            boolean bindName = false;
            if (name.isEmpty()) {
                sb.append(_FINDER_COLUMN_G_N_P_NAME_3);
            } else {
                bindName = true;
                sb.append(_FINDER_COLUMN_G_N_P_NAME_2);
            }
            boolean bindPortletId = false;
            if (portletId.isEmpty()) {
                sb.append(_FINDER_COLUMN_G_N_P_PORTLETID_3);
            } else {
                bindPortletId = true;
                sb.append(_FINDER_COLUMN_G_N_P_PORTLETID_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                if (bindName) {
                    queryPos.add(name);
                }
                if (bindPortletId) {
                    queryPos.add(portletId);
                }
                if ((list = query.list()).isEmpty()) {
                    if (useFinderCache) {
                        FinderCacheUtil.putResult((FinderPath)this._finderPathFetchByG_N_P, (Object[])finderArgs, (Object)list);
                    }
                } else {
                    Repository repository2 = (Repository)list.get(0);
                    result = repository2;
                    this.cacheResult(repository2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Repository)result;
    }

    public Repository removeByG_N_P(long groupId, String name, String portletId) throws NoSuchRepositoryException {
        Repository repository = this.findByG_N_P(groupId, name, portletId);
        return (Repository)this.remove((BaseModel)repository);
    }

    public int countByG_N_P(long groupId, String name, String portletId) {
        name = Objects.toString(name, "");
        portletId = Objects.toString(portletId, "");
        FinderPath finderPath = this._finderPathCountByG_N_P;
        Object[] finderArgs = new Object[]{groupId, name, portletId};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_COUNT_REPOSITORY_WHERE);
            sb.append(_FINDER_COLUMN_G_N_P_GROUPID_2);
            boolean bindName = false;
            if (name.isEmpty()) {
                sb.append(_FINDER_COLUMN_G_N_P_NAME_3);
            } else {
                bindName = true;
                sb.append(_FINDER_COLUMN_G_N_P_NAME_2);
            }
            boolean bindPortletId = false;
            if (portletId.isEmpty()) {
                sb.append(_FINDER_COLUMN_G_N_P_PORTLETID_3);
            } else {
                bindPortletId = true;
                sb.append(_FINDER_COLUMN_G_N_P_PORTLETID_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                if (bindName) {
                    queryPos.add(name);
                }
                if (bindPortletId) {
                    queryPos.add(portletId);
                }
                count = (Long)query.uniqueResult();
                FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public RepositoryPersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("uuid", "uuid_");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(Repository.class);
        this.setModelImplClass(RepositoryImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)RepositoryTable.INSTANCE);
    }

    public void cacheResult(Repository repository) {
        EntityCacheUtil.putResult(RepositoryImpl.class, (Serializable)Long.valueOf(repository.getPrimaryKey()), (Serializable)repository);
        FinderCacheUtil.putResult((FinderPath)this._finderPathFetchByUUID_G, (Object[])new Object[]{repository.getUuid(), repository.getGroupId()}, (Object)repository);
        FinderCacheUtil.putResult((FinderPath)this._finderPathFetchByG_N_P, (Object[])new Object[]{repository.getGroupId(), repository.getName(), repository.getPortletId()}, (Object)repository);
    }

    public void cacheResult(List<Repository> repositories) {
        for (Repository repository : repositories) {
            if (EntityCacheUtil.getResult(RepositoryImpl.class, (Serializable)Long.valueOf(repository.getPrimaryKey())) != null) continue;
            this.cacheResult(repository);
        }
    }

    public void clearCache() {
        EntityCacheUtil.clearCache(RepositoryImpl.class);
        FinderCacheUtil.clearCache(RepositoryImpl.class);
    }

    public void clearCache(Repository repository) {
        EntityCacheUtil.removeResult(RepositoryImpl.class, (BaseModel)repository);
    }

    public void clearCache(List<Repository> repositories) {
        for (Repository repository : repositories) {
            EntityCacheUtil.removeResult(RepositoryImpl.class, (BaseModel)repository);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        FinderCacheUtil.clearCache(RepositoryImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            EntityCacheUtil.removeResult(RepositoryImpl.class, (Serializable)primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(RepositoryModelImpl repositoryModelImpl) {
        Object[] args = new Object[]{repositoryModelImpl.getUuid(), repositoryModelImpl.getGroupId()};
        FinderCacheUtil.putResult((FinderPath)this._finderPathCountByUUID_G, (Object[])args, (Object)1L);
        FinderCacheUtil.putResult((FinderPath)this._finderPathFetchByUUID_G, (Object[])args, (Object)((Object)repositoryModelImpl));
        args = new Object[]{repositoryModelImpl.getGroupId(), repositoryModelImpl.getName(), repositoryModelImpl.getPortletId()};
        FinderCacheUtil.putResult((FinderPath)this._finderPathCountByG_N_P, (Object[])args, (Object)1L);
        FinderCacheUtil.putResult((FinderPath)this._finderPathFetchByG_N_P, (Object[])args, (Object)((Object)repositoryModelImpl));
    }

    public Repository create(long repositoryId) {
        RepositoryImpl repository = new RepositoryImpl();
        repository.setNew(true);
        repository.setPrimaryKey(repositoryId);
        String uuid = PortalUUIDUtil.generate();
        repository.setUuid(uuid);
        repository.setCompanyId(CompanyThreadLocal.getCompanyId());
        return repository;
    }

    public Repository remove(long repositoryId) throws NoSuchRepositoryException {
        return this.remove(Long.valueOf(repositoryId));
    }

    public Repository remove(Serializable primaryKey) throws NoSuchRepositoryException {
        Session session = null;
        try {
            session = this.openSession();
            Repository repository = (Repository)session.get(RepositoryImpl.class, primaryKey);
            if (repository == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchRepositoryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            Repository repository2 = (Repository)this.remove((BaseModel)repository);
            return repository2;
        }
        catch (NoSuchRepositoryException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Repository removeImpl(Repository repository) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)repository)) {
                repository = (Repository)session.get(RepositoryImpl.class, repository.getPrimaryKeyObj());
            }
            if (repository != null) {
                session.delete((Object)repository);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (repository != null) {
            this.clearCache(repository);
        }
        return repository;
    }

    public Repository updateImpl(Repository repository) {
        boolean isNew = repository.isNew();
        if (!(repository instanceof RepositoryModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(repository.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)repository);
                throw new IllegalArgumentException("Implement ModelWrapper in repository proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom Repository implementation " + repository.getClass());
        }
        RepositoryModelImpl repositoryModelImpl = (RepositoryModelImpl)repository;
        if (Validator.isNull((String)repository.getUuid())) {
            String uuid = PortalUUIDUtil.generate();
            repository.setUuid(uuid);
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && repository.getCreateDate() == null) {
            if (serviceContext == null) {
                repository.setCreateDate(date);
            } else {
                repository.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!repositoryModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                repository.setModifiedDate(date);
            } else {
                repository.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)repository);
            } else {
                repository = (Repository)session.merge((Object)repository);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        EntityCacheUtil.putResult(RepositoryImpl.class, (BaseModel)repositoryModelImpl, (boolean)false, (boolean)true);
        this.cacheUniqueFindersCache(repositoryModelImpl);
        if (isNew) {
            repository.setNew(false);
        }
        repository.resetOriginalValues();
        return repository;
    }

    public Repository findByPrimaryKey(Serializable primaryKey) throws NoSuchRepositoryException {
        Repository repository = (Repository)this.fetchByPrimaryKey(primaryKey);
        if (repository == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchRepositoryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return repository;
    }

    public Repository findByPrimaryKey(long repositoryId) throws NoSuchRepositoryException {
        return this.findByPrimaryKey(Long.valueOf(repositoryId));
    }

    public Repository fetchByPrimaryKey(long repositoryId) {
        return (Repository)this.fetchByPrimaryKey(Long.valueOf(repositoryId));
    }

    public List<Repository> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<Repository> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<Repository> findAll(int start, int end, OrderByComparator<Repository> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<Repository> findAll(int start, int end, OrderByComparator<Repository> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)FinderCacheUtil.getResult((FinderPath)finderPath, finderArgs);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_REPOSITORY);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_REPOSITORY;
                sql = sql.concat(" ORDER BY repository.repositoryId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (Repository repository : this.findAll()) {
            this.remove((BaseModel)repository);
        }
    }

    public int countAll() {
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)this._finderPathCountAll, (Object[])FINDER_ARGS_EMPTY);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_REPOSITORY);
                count = (Long)query.uniqueResult();
                FinderCacheUtil.putResult((FinderPath)this._finderPathCountAll, (Object[])FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return EntityCacheUtil.getEntityCache();
    }

    protected String getPKDBName() {
        return "repositoryId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_REPOSITORY;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return RepositoryModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        Registry registry = RegistryUtil.getRegistry();
        this._argumentsResolverServiceRegistration = registry.registerService(ArgumentsResolver.class, (Object)new RepositoryModelArgumentsResolver());
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"uuid_"}, true);
        this._finderPathWithoutPaginationFindByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid", new String[]{String.class.getName()}, new String[]{"uuid_"}, true);
        this._finderPathCountByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid", new String[]{String.class.getName()}, new String[]{"uuid_"}, false);
        this._finderPathFetchByUUID_G = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByUUID_G", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "groupId"}, true);
        this._finderPathCountByUUID_G = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUUID_G", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "groupId"}, false);
        this._finderPathWithPaginationFindByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"uuid_", "companyId"}, true);
        this._finderPathWithoutPaginationFindByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "companyId"}, true);
        this._finderPathCountByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "companyId"}, false);
        this._finderPathWithPaginationFindByGroupId = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByGroupId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"groupId"}, true);
        this._finderPathWithoutPaginationFindByGroupId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByGroupId", new String[]{Long.class.getName()}, new String[]{"groupId"}, true);
        this._finderPathCountByGroupId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByGroupId", new String[]{Long.class.getName()}, new String[]{"groupId"}, false);
        this._finderPathFetchByG_N_P = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByG_N_P", new String[]{Long.class.getName(), String.class.getName(), String.class.getName()}, new String[]{"groupId", "name", "portletId"}, true);
        this._finderPathCountByG_N_P = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_N_P", new String[]{Long.class.getName(), String.class.getName(), String.class.getName()}, new String[]{"groupId", "name", "portletId"}, false);
    }

    public void destroy() {
        EntityCacheUtil.removeCache((String)RepositoryImpl.class.getName());
        this._argumentsResolverServiceRegistration.unregister();
    }

    protected FinderCache getFinderCache() {
        return FinderCacheUtil.getFinderCache();
    }

    private static class RepositoryModelArgumentsResolver
    implements ArgumentsResolver {
        private static final Map<FinderPath, Long> _finderPathColumnBitmasksCache = new ConcurrentHashMap<FinderPath, Long>();

        private RepositoryModelArgumentsResolver() {
        }

        public Object[] getArguments(FinderPath finderPath, BaseModel<?> baseModel, boolean checkColumn, boolean original) {
            String[] columnNames = finderPath.getColumnNames();
            if (columnNames == null || columnNames.length == 0) {
                if (baseModel.isNew()) {
                    return FINDER_ARGS_EMPTY;
                }
                return null;
            }
            RepositoryModelImpl repositoryModelImpl = (RepositoryModelImpl)baseModel;
            long columnBitmask = repositoryModelImpl.getColumnBitmask();
            if (!checkColumn || columnBitmask == 0L) {
                return RepositoryModelArgumentsResolver._getValue(repositoryModelImpl, columnNames, original);
            }
            Long finderPathColumnBitmask = _finderPathColumnBitmasksCache.get(finderPath);
            if (finderPathColumnBitmask == null) {
                finderPathColumnBitmask = 0L;
                for (String columnName : columnNames) {
                    finderPathColumnBitmask = finderPathColumnBitmask | RepositoryModelImpl.getColumnBitmask(columnName);
                }
                _finderPathColumnBitmasksCache.put(finderPath, finderPathColumnBitmask);
            }
            if ((columnBitmask & finderPathColumnBitmask) != 0L) {
                return RepositoryModelArgumentsResolver._getValue(repositoryModelImpl, columnNames, original);
            }
            return null;
        }

        public String getClassName() {
            return RepositoryImpl.class.getName();
        }

        public String getTableName() {
            return RepositoryTable.INSTANCE.getTableName();
        }

        private static Object[] _getValue(RepositoryModelImpl repositoryModelImpl, String[] columnNames, boolean original) {
            Object[] arguments = new Object[columnNames.length];
            for (int i = 0; i < arguments.length; ++i) {
                String columnName = columnNames[i];
                arguments[i] = original ? repositoryModelImpl.getColumnOriginalValue(columnName) : repositoryModelImpl.getColumnValue(columnName);
            }
            return arguments;
        }
    }
}

