/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.servlet.SharedSessionWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;

public class SharedSessionServletRequest
extends HttpServletRequestWrapper {
    private HttpSession _portalSession;
    private final boolean _shared;

    public SharedSessionServletRequest(HttpServletRequest httpServletRequest, boolean shared) {
        super(httpServletRequest);
        this._shared = shared;
        this._portalSession = httpServletRequest.getSession();
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        if (create) {
            this.checkPortalSession();
        }
        if (this._shared) {
            return this._portalSession;
        }
        HttpSession portletSession = super.getSession(create);
        if (portletSession != null && portletSession != this._portalSession) {
            return this.getSharedSessionWrapper(this._portalSession, portletSession);
        }
        return portletSession;
    }

    public HttpSession getSharedSession() {
        return this._portalSession;
    }

    protected void checkPortalSession() {
        try {
            this._portalSession.isNew();
        }
        catch (IllegalStateException illegalStateException) {
            this._portalSession = super.getSession(true);
        }
    }

    protected HttpSession getSharedSessionWrapper(HttpSession portalSession, HttpSession portletSession) {
        return new SharedSessionWrapper(portalSession, portletSession);
    }
}

