/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.password.modified;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.session.AuthenticatedSessionManagerUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import java.util.Date;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class PasswordModifiedFilter
extends BasePortalFilter {
    private static final Log _log = LogFactoryUtil.getLog(PasswordModifiedFilter.class);

    protected void processFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws Exception {
        if (this._isPasswordModified(httpServletRequest)) {
            AuthenticatedSessionManagerUtil.logout((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
            if (StringUtil.equals((String)httpServletRequest.getMethod(), (String)"GET")) {
                httpServletResponse.sendRedirect(PortalUtil.getCurrentCompleteURL((HttpServletRequest)httpServletRequest));
            } else {
                httpServletResponse.sendRedirect(PortalUtil.getPortalURL((HttpServletRequest)httpServletRequest));
            }
        } else {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
    }

    private boolean _isPasswordModified(HttpServletRequest httpServletRequest) {
        HttpSession session = httpServletRequest.getSession(false);
        if (session == null) {
            return false;
        }
        if (!httpServletRequest.isRequestedSessionIdValid()) {
            return false;
        }
        try {
            User user = PortalUtil.getUser((HttpServletRequest)httpServletRequest);
            if (user == null || user.isDefaultUser()) {
                return false;
            }
            if (!this._isValidRealUserId(session, user)) {
                return false;
            }
            Date passwordModifiedDate = user.getPasswordModifiedDate();
            if (passwordModifiedDate == null) {
                return false;
            }
            return !httpServletRequest.isRequestedSessionIdValid() || session.getCreationTime() < passwordModifiedDate.getTime();
        }
        catch (PortalException portalException) {
            _log.error((Object)portalException, (Throwable)portalException);
            return false;
        }
    }

    private boolean _isValidRealUserId(HttpSession session, User user) {
        Long realUserId = (Long)session.getAttribute("USER_ID");
        return realUserId != null && user.getUserId() == realUserId.longValue();
    }
}

