/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.struts;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.access.control.AccessControlUtil;
import com.liferay.portal.kernel.security.auth.AuthTokenUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.SharedSessionServletRequest;
import com.liferay.portal.struts.Action;
import com.liferay.portal.struts.model.ActionForward;
import com.liferay.portal.struts.model.ActionMapping;
import com.liferay.portal.util.PropsValues;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class JSONAction
implements Action {
    private static final Log _log = LogFactoryUtil.getLog(JSONAction.class);
    private final Set<String> _hostsAllowed = SetUtil.fromArray((Object[])PropsValues.JSON_SERVICE_AUTH_TOKEN_HOSTS_ALLOWED);
    private ServletContext _servletContext;

    @Override
    public ActionForward execute(ActionMapping actionMapping, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (this.rerouteExecute(httpServletRequest, httpServletResponse)) {
            return null;
        }
        String callback = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"callback");
        String json = null;
        try {
            this.checkAuthToken(httpServletRequest);
            json = this.getJSON(httpServletRequest, httpServletResponse);
            if (Validator.isNotNull((String)callback)) {
                StringBundler sb = new StringBundler(5);
                sb.append("/**/");
                sb.append(callback);
                sb.append("(");
                sb.append(json);
                sb.append(")");
                json = sb.toString();
            }
        }
        catch (PrincipalException principalException) {
            _log.error((Object)principalException.getMessage());
            PortalUtil.sendError((int)403, (Exception)((Object)principalException), (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
            return null;
        }
        catch (SecurityException securityException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)securityException.getMessage());
            }
            if (PropsValues.JSON_SERVICE_SERIALIZE_THROWABLE) {
                json = JSONFactoryUtil.serializeThrowable((Throwable)securityException);
            }
            PortalUtil.sendError((int)500, (Exception)securityException, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
            return null;
        }
        catch (Exception exception) {
            _log.error((Object)exception.getMessage());
            PortalUtil.sendError((int)500, (Exception)exception, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
            return null;
        }
        boolean refresh = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"refresh");
        if (refresh) {
            return actionMapping.getActionForward("/common/referer_js.jsp");
        }
        if (Validator.isNotNull((String)json)) {
            httpServletResponse.setCharacterEncoding("UTF-8");
            httpServletResponse.setContentType("application/json");
            httpServletResponse.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
            try (ServletOutputStream outputStream = httpServletResponse.getOutputStream();){
                outputStream.write(json.getBytes("UTF-8"));
            }
        }
        return null;
    }

    public abstract String getJSON(HttpServletRequest var1, HttpServletResponse var2) throws Exception;

    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    protected void checkAuthToken(HttpServletRequest httpServletRequest) throws PortalException {
        String authType = GetterUtil.getString((String)httpServletRequest.getAuthType());
        if (AccessControlUtil.getAccessControlContext() == null ? authType.equals("BASIC") || authType.equals("DIGEST") : !authType.equals("FORM")) {
            return;
        }
        if (PropsValues.JSON_SERVICE_AUTH_TOKEN_ENABLED && !AccessControlUtil.isAccessAllowed((HttpServletRequest)httpServletRequest, this._hostsAllowed)) {
            AuthTokenUtil.checkCSRFToken((HttpServletRequest)httpServletRequest, (String)this.getCSRFOrigin(httpServletRequest));
        }
    }

    protected String getCSRFOrigin(HttpServletRequest httpServletRequest) {
        return ClassUtil.getClassName((Object)this);
    }

    protected String getReroutePath() {
        return null;
    }

    protected boolean rerouteExecute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String servletContextName;
        String reroutePath = this.getReroutePath();
        if (Validator.isNull((String)reroutePath)) {
            return false;
        }
        String requestServletContextName = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"servletContextName");
        if (Validator.isNull((String)requestServletContextName)) {
            return false;
        }
        ServletContext servletContext = this._servletContext;
        if (servletContext == null) {
            servletContext = (ServletContext)httpServletRequest.getAttribute("CTX");
        }
        if ((servletContextName = GetterUtil.getString((String)servletContext.getServletContextName())).equals(requestServletContextName)) {
            return false;
        }
        ServletContext requestServletContext = ServletContextPool.get((String)requestServletContextName);
        if (requestServletContext == null) {
            return false;
        }
        RequestDispatcher requestDispatcher = requestServletContext.getRequestDispatcher(reroutePath);
        if (requestDispatcher == null) {
            return false;
        }
        requestDispatcher.forward((ServletRequest)new SharedSessionServletRequest(httpServletRequest, true), (ServletResponse)httpServletResponse);
        return true;
    }
}

