/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.petra.string.CharPool;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ArgumentsUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfigurationEnvBuilder {
    private static final Map<Character, String> _charStrings = new HashMap<Character, String>(){
        {
            try {
                for (Field field : CharPool.class.getFields()) {
                    if (!Modifier.isStatic(field.getModifiers()) || field.getType() != Character.TYPE) continue;
                    this.put(Character.valueOf(field.getChar(null)), StringUtil.removeChar((String)field.getName(), (char)'_'));
                }
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new ExceptionInInitializerError(reflectiveOperationException);
            }
        }
    };
    private static final Pattern _pattern = Pattern.compile("\\s*public .* ([^\\s]+)\\(\\);");

    public static String buildContent(String[] configurationJavaFileNames) throws IOException {
        TreeMap<String, String> map = new TreeMap<String, String>();
        StringBundler sb = new StringBundler(map.size() * 5 + 2);
        sb.append("#\n# The following environment variables can be used to ");
        sb.append("override OSGi configurations.\n#");
        Matcher matcher = _pattern.matcher("");
        for (String configurationJavaFileName : configurationJavaFileNames) {
            Path path = Paths.get(configurationJavaFileName, new String[0]);
            String fullyQualifiedName = configurationJavaFileName.substring(configurationJavaFileName.indexOf(StringBundler.concat((String[])new String[]{"com", File.separator, "liferay"})), configurationJavaFileName.indexOf(".java"));
            fullyQualifiedName = StringUtil.replace((String)fullyQualifiedName, (String)File.separator, (String)".");
            List<String> lines = Files.readAllLines(path);
            for (String line : lines) {
                if (line.contains("public class")) break;
                matcher.reset(line);
                if (!matcher.matches()) continue;
                String configurationKey = StringBundler.concat((String[])new String[]{fullyQualifiedName, "_", matcher.group(1)});
                map.put(configurationKey, ConfigurationEnvBuilder._getEnvirionmentVariableName(configurationKey));
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            sb.append("\n\n");
            sb.append("#\n# ");
            sb.append((String)entry.getKey());
            sb.append("\n#\n");
            sb.append((String)entry.getValue());
        }
        return sb.toString();
    }

    public static void main(String[] args) throws IOException {
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        String[] configurationJavaFileNames = StringUtil.split((String)arguments.get("configuration.java.files"));
        String content = ConfigurationEnvBuilder.buildContent(configurationJavaFileNames);
        Files.write(Paths.get(arguments.get("output.file"), new String[0]), content.getBytes(), new OpenOption[0]);
    }

    private static String _getEnvirionmentVariableName(String configurationKey) {
        StringBundler sb = new StringBundler();
        sb.append("LIFERAY_CONFIGURATION_OVERRIDE_");
        for (char c : configurationKey.toCharArray()) {
            if (Character.isLowerCase(c)) {
                sb.append(Character.toUpperCase(c));
                continue;
            }
            sb.append('_');
            sb.append(_charStrings.get(Character.valueOf(c)));
            sb.append('_');
        }
        return sb.toString();
    }
}

