/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;

public class UpgradeMobileDeviceRules
extends UpgradeProcess {
    private static final String _CLASS_NAME = "com.liferay.mobile.device.rules.model.MDRRuleGroupInstance";

    public void doUpgrade() throws Exception {
        this.populateCompanyIds();
        this.populateResourcePermissions();
    }

    public long getActionIds(String className) throws Exception {
        long actionIds = 0L;
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select bitwiseValue from ResourceAction where name = ?");){
            preparedStatement.setString(1, className);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    long bitwiseValue = resultSet.getLong(1);
                    actionIds |= bitwiseValue;
                }
            }
        }
        return actionIds;
    }

    public Map<Long, Long> getOwnerRoleIds() throws Exception {
        HashMap<Long, Long> ownerRoleIds = new HashMap<Long, Long>();
        String roleName = "Owner";
        int roleType = 1;
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select companyId, roleId from Role_ where name = ? and type_ = ?");){
            preparedStatement.setString(1, roleName);
            preparedStatement.setInt(2, roleType);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    long companyId = resultSet.getLong(1);
                    long roleId = resultSet.getLong(2);
                    ownerRoleIds.put(companyId, roleId);
                }
            }
        }
        return ownerRoleIds;
    }

    public void populateCompanyIds() throws Exception {
        StringBundler sb = new StringBundler(6);
        sb.append("select MDRRuleGroup.companyId, ");
        sb.append("MDRRuleGroupInstance.ruleGroupInstanceId from ");
        sb.append("MDRRuleGroup left join MDRRuleGroupInstance on ");
        sb.append("MDRRuleGroup.ruleGroupId = ");
        sb.append("MDRRuleGroupInstance.ruleGroupId where ");
        sb.append("MDRRuleGroupInstance.companyId = 0");
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(sb.toString());
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update MDRRuleGroupInstance set companyId = ? where ruleGroupInstanceId = ?");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                long companyId = resultSet.getLong(1);
                long ruleGroupInstanceId = resultSet.getLong(2);
                preparedStatement2.setLong(1, companyId);
                preparedStatement2.setLong(2, ruleGroupInstanceId);
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }

    public void populateResourcePermissions() throws Exception {
        StringBundler sb1 = new StringBundler(12);
        sb1.append("select MDRRuleGroupInstance.companyId, ");
        sb1.append("MDRRuleGroupInstance.ruleGroupInstanceId, ");
        sb1.append("MDRRuleGroupInstance.userId from MDRRuleGroupInstance ");
        sb1.append("where not exists (select 1 from ResourcePermission where ");
        sb1.append("(MDRRuleGroupInstance.companyId = ResourcePermission.");
        sb1.append("companyId) and (MDRRuleGroupInstance.ruleGroupInstanceId ");
        sb1.append("= ResourcePermission.primKeyId) and ");
        sb1.append("(MDRRuleGroupInstance.userId = ");
        sb1.append("ResourcePermission.ownerId) and (ResourcePermission.name ");
        sb1.append("= '");
        sb1.append(_CLASS_NAME);
        sb1.append("'))");
        StringBundler sb2 = new StringBundler(4);
        sb2.append("insert into ResourcePermission (resourcePermissionId, ");
        sb2.append("companyId, name, scope, primKey, primKeyId, roleId, ");
        sb2.append("ownerId, actionIds, viewActionId) values (?, ?, ?, ?, ?, ");
        sb2.append("?, ?, ?, ?, ?)");
        Map<Long, Long> ownerRoleIds = this.getOwnerRoleIds();
        long actionIds = this.getActionIds(_CLASS_NAME);
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(sb1.toString());
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)sb2.toString());
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                long companyId = resultSet.getLong(1);
                long ruleGroupInstanceId = resultSet.getLong(2);
                long userId = resultSet.getLong(3);
                preparedStatement2.setLong(1, this.increment(ResourcePermission.class.getName()));
                preparedStatement2.setLong(2, companyId);
                preparedStatement2.setString(3, _CLASS_NAME);
                preparedStatement2.setInt(4, 4);
                preparedStatement2.setString(5, String.valueOf(ruleGroupInstanceId));
                preparedStatement2.setLong(6, ruleGroupInstanceId);
                preparedStatement2.setLong(7, ownerRoleIds.get(companyId));
                preparedStatement2.setLong(8, userId);
                preparedStatement2.setLong(9, actionIds);
                preparedStatement2.setBoolean(10, true);
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }
}

