/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_3;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class UpgradeOracle
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeOracle.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void alterVarchar2Columns() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement = this.connection.prepareStatement("select table_name, column_name, data_length from user_tab_columns where data_type = 'VARCHAR2' and char_used = 'B'");){
            ResultSet resultSet = preparedStatement.executeQuery();
            Throwable throwable = null;
            block29: while (true) {
                try {
                    while (resultSet.next()) {
                        String tableName = resultSet.getString(1);
                        if (!this.isPortal62TableName(tableName)) continue;
                        String columnName = resultSet.getString(2);
                        try {
                            this.runSQL(StringBundler.concat((Object[])new Object[]{"alter table ", tableName, " modify ", columnName, " varchar2(", resultSet.getInt(3), " char)"}));
                            continue block29;
                        }
                        catch (SQLException sqlException) {
                            if (sqlException.getErrorCode() != 1441) throw sqlException;
                            if (!_log.isWarnEnabled()) continue;
                            StringBundler sb = new StringBundler(6);
                            sb.append("Unable to alter length of column ");
                            sb.append(columnName);
                            sb.append(" for table ");
                            sb.append(tableName);
                            sb.append(" because it contains values that are ");
                            sb.append("larger than the new column length");
                            _log.warn((Object)sb.toString());
                            continue;
                            return;
                        }
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            finally {
                if (resultSet != null) {
                    if (throwable != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        resultSet.close();
                    }
                }
            }
        }
    }

    protected void doUpgrade() throws Exception {
        DB db = DBManagerUtil.getDB();
        if (db.getDBType() != DBType.ORACLE) {
            return;
        }
        this.alterVarchar2Columns();
    }
}

