/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypeController;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.model.impl.LayoutTypeControllerImpl;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LayoutTypeControllerTracker {
    private static final String[] _LAYOUT_TYPES = new String[]{"portlet"};
    private static final ServiceTrackerMap<String, LayoutTypeController> _serviceTrackerMap;

    public static LayoutTypeController getLayoutTypeController(Layout layout) {
        return LayoutTypeControllerTracker.getLayoutTypeController(layout.getType());
    }

    public static LayoutTypeController getLayoutTypeController(String type) {
        LayoutTypeController layoutTypeController = (LayoutTypeController)_serviceTrackerMap.getService((Object)type);
        if (layoutTypeController != null) {
            return layoutTypeController;
        }
        return (LayoutTypeController)_serviceTrackerMap.getService((Object)"portlet");
    }

    public static Map<String, LayoutTypeController> getLayoutTypeControllers() {
        HashMap<String, LayoutTypeController> layoutTypeControllers = new HashMap<String, LayoutTypeController>();
        for (String type : _serviceTrackerMap.keySet()) {
            layoutTypeControllers.put(type, (LayoutTypeController)_serviceTrackerMap.getService((Object)type));
        }
        return layoutTypeControllers;
    }

    public static String[] getTypes() {
        Set types = _serviceTrackerMap.keySet();
        return types.toArray(new String[0]);
    }

    static {
        Registry registry = RegistryUtil.getRegistry();
        for (String type : _LAYOUT_TYPES) {
            registry.registerService(LayoutTypeController.class, (Object)new LayoutTypeControllerImpl(type), (Map)HashMapBuilder.put((Object)"layout.type", (Object)type).put((Object)"service.ranking", (Object)Integer.MIN_VALUE).build());
        }
        _serviceTrackerMap = ServiceTrackerCollections.openSingleValueMap(LayoutTypeController.class, (String)"layout.type");
    }
}

