/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.petra.process.ProcessConfig;
import com.liferay.petra.process.ProcessLog;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLCodec;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

public class PortalClassPathUtil {
    private static final Log _log = LogFactoryUtil.getLog(PortalClassPathUtil.class);
    private static ProcessConfig _portalProcessConfig;
    private static final List<String> _processArgs;

    public static ProcessConfig createProcessConfig(Class<?> ... classes) {
        ProcessConfig.Builder builder = new ProcessConfig.Builder();
        builder.setArguments(_processArgs);
        String classpath = PortalClassPathUtil._buildClassPath(classes);
        classpath = StringBundler.concat((String[])new String[]{classpath, File.pathSeparator, _portalProcessConfig.getBootstrapClassPath()});
        builder.setBootstrapClassPath(classpath);
        builder.setProcessLogConsumer(processLog -> {
            if (ProcessLog.Level.DEBUG == processLog.getLevel()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)processLog.getMessage(), processLog.getThrowable());
                }
            } else if (ProcessLog.Level.INFO == processLog.getLevel()) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)processLog.getMessage(), processLog.getThrowable());
                }
            } else if (ProcessLog.Level.WARN == processLog.getLevel()) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)processLog.getMessage(), processLog.getThrowable());
                }
            } else {
                _log.error((Object)processLog.getMessage(), processLog.getThrowable());
            }
        });
        builder.setReactClassLoader(PortalClassLoaderUtil.getClassLoader());
        builder.setRuntimeClassPath(classpath);
        return builder.build();
    }

    public static ProcessConfig getPortalProcessConfig() {
        return _portalProcessConfig;
    }

    public static void initializeClassPaths(ServletContext servletContext) {
        ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
        if (classLoader == null) {
            Thread currentThread = Thread.currentThread();
            classLoader = currentThread.getContextClassLoader();
        }
        StringBundler sb = new StringBundler(8);
        String appServerGlobalClassPath = PortalClassPathUtil._buildClassPath(classLoader, ServletException.class.getName());
        sb.append(appServerGlobalClassPath);
        sb.append(File.pathSeparator);
        String portalGlobalClassPath = PortalClassPathUtil._buildClassPath(classLoader, CentralizedThreadLocal.class.getName(), PortalException.class.getName());
        sb.append(portalGlobalClassPath);
        String globalClassPath = sb.toString();
        sb.append(File.pathSeparator);
        sb.append(PortalClassPathUtil._buildClassPath(classLoader, "com.liferay.portal.internal.servlet.MainServlet"));
        if (servletContext != null) {
            sb.append(File.pathSeparator);
            sb.append(servletContext.getRealPath(""));
            sb.append("/WEB-INF/classes");
        }
        String portalClassPath = sb.toString();
        ProcessConfig.Builder builder = new ProcessConfig.Builder();
        builder.setArguments(_processArgs);
        builder.setBootstrapClassPath(globalClassPath);
        builder.setReactClassLoader(classLoader);
        builder.setRuntimeClassPath(portalClassPath);
        _portalProcessConfig = builder.build();
    }

    private static String _buildClassPath(Class<?> ... classes) {
        if (ArrayUtil.isEmpty((Object[])classes)) {
            return "";
        }
        StringBundler sb = new StringBundler(classes.length * 2);
        for (Class<?> clazz : classes) {
            sb.append(PortalClassPathUtil._buildClassPath(clazz.getClassLoader(), clazz.getName()));
            sb.append(File.pathSeparator);
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }

    private static String _buildClassPath(ClassLoader classLoader, String ... classNames) {
        HashSet fileSet = new HashSet();
        for (String className : classNames) {
            File[] files = PortalClassPathUtil._listClassPathFiles(classLoader, className);
            if (files == null) continue;
            Collections.addAll(fileSet, files);
        }
        Object[] files = fileSet.toArray(new File[0]);
        Arrays.sort(files);
        StringBundler sb = new StringBundler(files.length * 2);
        for (Object file : files) {
            sb.append(((File)file).getAbsolutePath());
            sb.append(File.pathSeparator);
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }

    private static File[] _listClassPathFiles(ClassLoader classLoader, String className) {
        String protocol;
        String pathOfClass = StringUtil.replace((String)className, (char)'.', (char)'/');
        pathOfClass = pathOfClass.concat(".class");
        URL url = classLoader.getResource(pathOfClass);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Build class path from " + url));
        }
        if ((protocol = url.getProtocol()).equals("bundle") || protocol.equals("bundleresource")) {
            try {
                URLConnection urlConnection = url.openConnection();
                Class<?> clazz = urlConnection.getClass();
                Method getLocalURLMethod = clazz.getDeclaredMethod("getLocalURL", new Class[0]);
                getLocalURLMethod.setAccessible(true);
                url = (URL)getLocalURLMethod.invoke((Object)urlConnection, new Object[0]);
            }
            catch (Exception exception) {
                _log.error((Object)"Unable to resolve local URL from bundle", (Throwable)exception);
                return null;
            }
        }
        String path = URLCodec.decodeURL((String)url.getPath());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Path " + path));
        }
        path = StringUtil.replace((String)path, (char)'\\', (char)'/');
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Decoded path " + path));
        }
        if (ServerDetector.isWebLogic() && protocol.equals("zip")) {
            path = "file:".concat(path);
        }
        if ((ServerDetector.isJBoss() || ServerDetector.isWildfly()) && (protocol.equals("vfs") || protocol.equals("vfsfile") || protocol.equals("vfszip"))) {
            String jarFilePath;
            File jarFile;
            int pos = path.indexOf(".jar/");
            if (pos != -1 && (jarFile = new File(jarFilePath = path.substring(0, pos + 4))).isFile()) {
                path = jarFilePath + '!' + path.substring(pos + 4);
            }
            path = "file:".concat(path);
        }
        File dir = null;
        int pos = -1;
        if (!path.startsWith("file:") || (pos = path.indexOf(33)) == -1) {
            if (!path.endsWith(pathOfClass)) {
                _log.error((Object)("Class " + className + " is not loaded from a JAR file"));
                return null;
            }
            String classesDirName = path.substring(0, path.length() - pathOfClass.length());
            if (!classesDirName.endsWith("/WEB-INF/classes/")) {
                _log.error((Object)StringBundler.concat((String[])new String[]{"Class ", className, " is not loaded from a standard ", "location (/WEB-INF/classes)"}));
                return null;
            }
            String libDirName = classesDirName.substring(0, classesDirName.length() - "classes/".length());
            libDirName = libDirName + "/lib";
            dir = new File(libDirName);
        } else {
            pos = path.lastIndexOf(47, pos);
            dir = new File(path.substring("file:".length(), pos));
        }
        if (!dir.isDirectory()) {
            _log.error((Object)(dir.toString() + " is not a directory"));
            return null;
        }
        return dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return false;
                }
                String name = file.getName();
                return name.equals("bundleFile") || name.endsWith(".jar");
            }
        });
    }

    static {
        _processArgs = Arrays.asList("-Dconfiguration.impl.quiet=true", "-Djava.awt.headless=true", "-Dserver.detector.quiet=true", "-Dsystem.properties.quiet=true");
    }
}

