/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.InvokerPortletResponse;
import com.liferay.portlet.internal.PortletSessionImpl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpSession;

public class InvokerPortletUtil {
    public static void clearResponse(HttpSession session, long plid, String portletId, String languageId) {
        String sesResponseId = InvokerPortletUtil.encodeResponseKey(plid, portletId, languageId);
        Map<String, InvokerPortletResponse> responses = InvokerPortletUtil.getResponses(session);
        responses.remove(sesResponseId);
    }

    public static void clearResponses(PortletSession session) {
        Map<String, InvokerPortletResponse> responses = InvokerPortletUtil.getResponses(session);
        responses.clear();
    }

    public static String encodeResponseKey(long plid, String portletId, String languageId) {
        StringBundler sb = new StringBundler(5);
        sb.append(StringUtil.toHexString((long)plid));
        sb.append("_");
        sb.append(portletId);
        sb.append("_");
        sb.append(languageId);
        return sb.toString();
    }

    public static Map<String, InvokerPortletResponse> getResponses(HttpSession session) {
        ConcurrentHashMap responses = (ConcurrentHashMap)session.getAttribute("CACHE_PORTLET_RESPONSES");
        if (responses == null) {
            responses = new ConcurrentHashMap();
            session.setAttribute("CACHE_PORTLET_RESPONSES", responses);
        }
        return responses;
    }

    public static Map<String, InvokerPortletResponse> getResponses(PortletSession portletSession) {
        PortletSessionImpl portletSessionImpl = (PortletSessionImpl)portletSession;
        return InvokerPortletUtil.getResponses(portletSessionImpl.getHttpSession());
    }
}

