/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.servlet.PortalSessionContext;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.RenderParametersPool;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class PublicRenderParametersPool {
    private static final String _PUBLIC_RENDER_PARAMETERS = "PUBLIC_RENDER_PARAMETERS";
    private static final Log _log = LogFactoryUtil.getLog(PublicRenderParametersPool.class);

    public static Map<String, String[]> get(HttpServletRequest httpServletRequest, long plid) {
        ConcurrentHashMap<Long, Map> publicRenderParametersPool;
        if (PropsValues.PORTLET_PUBLIC_RENDER_PARAMETER_DISTRIBUTION_LAYOUT) {
            return RenderParametersPool.getOrCreate(httpServletRequest, plid, _PUBLIC_RENDER_PARAMETERS);
        }
        HttpSession session = httpServletRequest.getSession();
        HttpSession portalSession = PortalSessionContext.get((String)session.getId());
        if (portalSession != null) {
            session = portalSession;
        }
        if ((publicRenderParametersPool = (ConcurrentHashMap<Long, Map>)session.getAttribute("PUBLIC_RENDER_PARAMETERS_POOL_")) == null) {
            publicRenderParametersPool = new ConcurrentHashMap<Long, Map>();
            session.setAttribute("PUBLIC_RENDER_PARAMETERS_POOL_", publicRenderParametersPool);
        }
        try {
            Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
            LayoutSet layoutSet = layout.getLayoutSet();
            return publicRenderParametersPool.computeIfAbsent(layoutSet.getLayoutSetId(), key -> new HashMap());
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)exception, (Throwable)exception);
            }
            return new HashMap<String, String[]>();
        }
    }
}

