/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.announcements.service.impl;

import com.liferay.announcements.kernel.model.AnnouncementsDelivery;
import com.liferay.announcements.kernel.model.AnnouncementsEntryConstants;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portlet.announcements.service.base.AnnouncementsDeliveryLocalServiceBaseImpl;
import java.util.ArrayList;
import java.util.List;

public class AnnouncementsDeliveryLocalServiceImpl
extends AnnouncementsDeliveryLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(AnnouncementsDeliveryLocalServiceImpl.class);

    public AnnouncementsDelivery addUserDelivery(long userId, String type) throws PortalException {
        AnnouncementsDelivery delivery;
        block3: {
            User user = this.userPersistence.findByPrimaryKey(userId);
            long deliveryId = this.counterLocalService.increment();
            delivery = this.announcementsDeliveryPersistence.create(deliveryId);
            delivery.setCompanyId(user.getCompanyId());
            delivery.setUserId(user.getUserId());
            delivery.setType(type);
            delivery.setEmail(false);
            delivery.setSms(false);
            delivery.setWebsite(true);
            try {
                delivery = (AnnouncementsDelivery)this.announcementsDeliveryPersistence.update((BaseModel)delivery);
            }
            catch (SystemException systemException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Add failed, fetch {userId=", userId, ", type=", type, "}"}));
                }
                if ((delivery = this.announcementsDeliveryPersistence.fetchByU_T(userId, type, false)) != null) break block3;
                throw systemException;
            }
        }
        return delivery;
    }

    public void deleteDeliveries(long userId) {
        List deliveries = this.announcementsDeliveryPersistence.findByUserId(userId);
        for (AnnouncementsDelivery delivery : deliveries) {
            this.deleteDelivery(delivery);
        }
    }

    public void deleteDelivery(AnnouncementsDelivery delivery) {
        this.announcementsDeliveryPersistence.remove((BaseModel)delivery);
    }

    public void deleteDelivery(long deliveryId) throws PortalException {
        AnnouncementsDelivery delivery = this.announcementsDeliveryPersistence.findByPrimaryKey(deliveryId);
        this.deleteDelivery(delivery);
    }

    public void deleteDelivery(long userId, String type) {
        AnnouncementsDelivery delivery = this.announcementsDeliveryPersistence.fetchByU_T(userId, type);
        if (delivery != null) {
            this.deleteDelivery(delivery);
        }
    }

    public AnnouncementsDelivery getDelivery(long deliveryId) throws PortalException {
        return this.announcementsDeliveryPersistence.findByPrimaryKey(deliveryId);
    }

    public List<AnnouncementsDelivery> getUserDeliveries(long userId) throws PortalException {
        ArrayList<AnnouncementsDelivery> deliveries = new ArrayList<AnnouncementsDelivery>(AnnouncementsEntryConstants.TYPES.length);
        for (String type : AnnouncementsEntryConstants.TYPES) {
            deliveries.add(this.getUserDelivery(userId, type));
        }
        return deliveries;
    }

    public AnnouncementsDelivery getUserDelivery(long userId, String type) throws PortalException {
        AnnouncementsDelivery delivery = this.announcementsDeliveryPersistence.fetchByU_T(userId, type);
        if (delivery == null) {
            delivery = this.announcementsDeliveryLocalService.addUserDelivery(userId, type);
        }
        return delivery;
    }

    public AnnouncementsDelivery updateDelivery(long userId, String type, boolean email, boolean sms) throws PortalException {
        AnnouncementsDelivery delivery = this.getUserDelivery(userId, type);
        delivery.setEmail(email);
        delivery.setSms(sms);
        delivery.setWebsite(true);
        return (AnnouncementsDelivery)this.announcementsDeliveryPersistence.update((BaseModel)delivery);
    }
}

