/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetLink;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.model.DLFileShortcut;
import com.liferay.document.library.kernel.model.DLFileShortcutConstants;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.model.DLFolderConstants;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.kernel.util.DLAppHelperThreadLocal;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.document.library.kernel.util.comparator.DLFileVersionVersionComparator;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.dao.orm.WildcardMode;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.interval.IntervalActionProcessor;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.messaging.async.Async;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.RepositoryProviderUtil;
import com.liferay.portal.kernel.repository.capabilities.RepositoryEventTriggerCapability;
import com.liferay.portal.kernel.repository.event.RepositoryEventType;
import com.liferay.portal.kernel.repository.event.TrashRepositoryEventType;
import com.liferay.portal.kernel.repository.event.WorkflowRepositoryEventType;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.model.RepositoryModel;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.social.SocialActivityManagerUtil;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileShortcut;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portal.repository.liferayrepository.model.LiferayFolder;
import com.liferay.portlet.documentlibrary.service.base.DLAppHelperLocalServiceBaseImpl;
import com.liferay.portlet.documentlibrary.util.DLAppUtil;
import com.liferay.trash.kernel.exception.RestoreEntryException;
import com.liferay.trash.kernel.exception.TrashEntryException;
import com.liferay.trash.kernel.model.TrashEntry;
import com.liferay.trash.kernel.model.TrashVersion;
import com.liferay.trash.kernel.util.TrashUtil;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DLAppHelperLocalServiceImpl
extends DLAppHelperLocalServiceBaseImpl {
    @BeanReference(type=DLAppService.class)
    protected DLAppService dlAppService;

    public void addFolder(long userId, Folder folder, ServiceContext serviceContext) throws PortalException {
        if (!DLAppHelperThreadLocal.isEnabled()) {
            return;
        }
        this.updateAsset(userId, folder, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
    }

    public void cancelCheckOut(long userId, FileEntry fileEntry, FileVersion sourceFileVersion, FileVersion destinationFileVersion, FileVersion draftFileVersion, ServiceContext serviceContext) throws PortalException {
        if (draftFileVersion == null) {
            return;
        }
        AssetEntry draftAssetEntry = this.assetEntryLocalService.fetchEntry(DLFileEntryConstants.getClassName(), draftFileVersion.getPrimaryKey());
        if (draftAssetEntry != null) {
            this.assetEntryLocalService.deleteEntry(draftAssetEntry);
        }
    }

    public void cancelCheckOuts(long groupId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this.getCancelCheckOutsActionableDynamicQuery(groupId);
        actionableDynamicQuery.performActions();
    }

    public void checkAssetEntry(long userId, FileEntry fileEntry, FileVersion fileVersion) throws PortalException {
        AssetEntry fileVersionAssetEntry;
        AssetEntry fileEntryAssetEntry = this.assetEntryLocalService.fetchEntry(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
        long[] assetCategoryIds = new long[]{};
        String[] assetTagNames = new String[]{};
        long fileEntryTypeId = this.getFileEntryTypeId(fileEntry);
        if (fileEntryAssetEntry == null) {
            fileEntryAssetEntry = this.assetEntryLocalService.updateEntry(userId, fileEntry.getGroupId(), fileEntry.getCreateDate(), fileEntry.getModifiedDate(), DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId(), fileEntry.getUuid(), fileEntryTypeId, assetCategoryIds, assetTagNames, true, false, null, null, null, fileEntry.getExpirationDate(), fileEntry.getMimeType(), fileEntry.getTitle(), fileEntry.getDescription(), null, null, null, 0, 0, null);
        }
        if ((fileVersionAssetEntry = this.assetEntryLocalService.fetchEntry(DLFileEntryConstants.getClassName(), fileVersion.getFileVersionId())) != null || fileVersion.isApproved()) {
            return;
        }
        String version = fileVersion.getVersion();
        if (version.equals("1.0")) {
            return;
        }
        assetCategoryIds = this.assetCategoryLocalService.getCategoryIds(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
        assetTagNames = this.assetTagLocalService.getTagNames(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
        fileVersionAssetEntry = this.assetEntryLocalService.updateEntry(userId, fileEntry.getGroupId(), fileEntry.getCreateDate(), fileEntry.getModifiedDate(), DLFileEntryConstants.getClassName(), fileVersion.getFileVersionId(), fileEntry.getUuid(), fileEntryTypeId, assetCategoryIds, assetTagNames, true, false, null, null, null, fileEntry.getExpirationDate(), fileEntry.getMimeType(), fileEntry.getTitle(), fileEntry.getDescription(), null, null, null, 0, 0, null);
        List assetLinks = this.assetLinkLocalService.getDirectLinks(fileEntryAssetEntry.getEntryId(), false);
        long[] assetLinkIds = ListUtil.toLongArray((List)assetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR);
        this.assetLinkLocalService.updateLinks(userId, fileVersionAssetEntry.getEntryId(), assetLinkIds, 0);
    }

    public void deleteFileEntry(FileEntry fileEntry) throws PortalException {
        if (!DLAppHelperThreadLocal.isEnabled()) {
            return;
        }
        this._deleteFileEntry(fileEntry.getFileEntryId());
    }

    public void deleteFolder(Folder folder) throws PortalException {
        if (!DLAppHelperThreadLocal.isEnabled()) {
            return;
        }
        this.assetEntryLocalService.deleteEntry(DLFolderConstants.getClassName(), folder.getFolderId());
    }

    public void deleteRepositoryFileEntries(long repositoryId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this.dlFileEntryLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"repositoryId", (Object)repositoryId)));
        actionableDynamicQuery.setPerformActionMethod(dlFileEntry -> this._deleteFileEntry(dlFileEntry.getFileEntryId()));
    }

    public long getCheckedOutFileEntriesCount(long groupId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this.getCancelCheckOutsActionableDynamicQuery(groupId);
        return actionableDynamicQuery.performCount();
    }

    public void getFileAsStream(long userId, FileEntry fileEntry, boolean incrementCounter) {
        if (!incrementCounter) {
            return;
        }
        this.assetEntryLocalService.incrementViewCounter(fileEntry.getCompanyId(), userId, DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId(), 1);
        List fileShortcuts = this.dlFileShortcutPersistence.findByToFileEntryId(fileEntry.getFileEntryId());
        for (DLFileShortcut fileShortcut : fileShortcuts) {
            this.assetEntryLocalService.incrementViewCounter(fileEntry.getCompanyId(), userId, DLFileShortcutConstants.getClassName(), fileShortcut.getFileShortcutId(), 1);
        }
    }

    public List<DLFileShortcut> getFileShortcuts(long groupId, long folderId, boolean active, int status) {
        return this.dlFileShortcutPersistence.findByG_F_A_S(groupId, folderId, active, status);
    }

    public int getFileShortcutsCount(long groupId, long folderId, boolean active, int status) {
        return this.dlFileShortcutPersistence.countByG_F_A_S(groupId, folderId, active, status);
    }

    public List<FileEntry> getNoAssetFileEntries() {
        return null;
    }

    public void moveDependentsToTrash(DLFolder dlFolder) throws PortalException {
        this.trashOrRestoreFolder(dlFolder, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileEntry moveFileEntryFromTrash(long userId, FileEntry fileEntry, long newFolderId, ServiceContext serviceContext) throws PortalException {
        boolean hasLock = this.dlFileEntryLocalService.hasFileEntryLock(userId, fileEntry.getFileEntryId(), fileEntry.getFolderId());
        if (!hasLock) {
            this.dlFileEntryLocalService.lockFileEntry(userId, fileEntry.getFileEntryId());
        }
        try {
            FileEntry fileEntry2 = this.doMoveFileEntryFromTrash(userId, fileEntry, newFolderId, serviceContext);
            return fileEntry2;
        }
        finally {
            if (!hasLock) {
                this.dlFileEntryLocalService.unlockFileEntry(fileEntry.getFileEntryId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileEntry moveFileEntryToTrash(long userId, FileEntry fileEntry) throws PortalException {
        boolean hasLock = this.dlFileEntryLocalService.hasFileEntryLock(userId, fileEntry.getFileEntryId(), fileEntry.getFolderId());
        if (!hasLock) {
            this.dlFileEntryLocalService.lockFileEntry(userId, fileEntry.getFileEntryId());
        }
        try {
            if (fileEntry.isCheckedOut()) {
                this.dlFileEntryLocalService.cancelCheckOut(userId, fileEntry.getFileEntryId());
            }
            FileEntry fileEntry2 = this.doMoveFileEntryToTrash(userId, fileEntry);
            return fileEntry2;
        }
        finally {
            if (!hasLock) {
                this.dlFileEntryLocalService.unlockFileEntry(fileEntry.getFileEntryId());
            }
        }
    }

    public FileShortcut moveFileShortcutFromTrash(long userId, FileShortcut fileShortcut, long newFolderId, ServiceContext serviceContext) throws PortalException {
        DLFileShortcut dlFileShortcut = (DLFileShortcut)fileShortcut.getModel();
        if (!dlFileShortcut.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        if (dlFileShortcut.isInTrashExplicitly()) {
            this.restoreFileShortcutFromTrash(userId, fileShortcut);
        } else {
            TrashVersion trashVersion = this.trashVersionLocalService.fetchVersion(DLFileShortcutConstants.getClassName(), fileShortcut.getFileShortcutId());
            int status = 0;
            if (trashVersion != null) {
                status = trashVersion.getStatus();
            }
            this.dlFileShortcutLocalService.updateStatus(userId, fileShortcut.getFileShortcutId(), status, new ServiceContext());
            if (trashVersion != null) {
                this.trashVersionLocalService.deleteTrashVersion(trashVersion);
            }
            JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)fileShortcut.getToTitle());
            SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)fileShortcut, (int)10008, (String)extraDataJSONObject.toString(), (long)0L);
        }
        return this.dlAppLocalService.updateFileShortcut(userId, fileShortcut.getFileShortcutId(), newFolderId, fileShortcut.getToFileEntryId(), serviceContext);
    }

    public FileShortcut moveFileShortcutToTrash(long userId, FileShortcut fileShortcut) throws PortalException {
        DLFileShortcut dlFileShortcut = (DLFileShortcut)fileShortcut.getModel();
        if (dlFileShortcut.isInTrash()) {
            throw new TrashEntryException();
        }
        int oldStatus = dlFileShortcut.getStatus();
        dlFileShortcut = this.dlFileShortcutLocalService.updateStatus(userId, fileShortcut.getFileShortcutId(), 8, new ServiceContext());
        JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)TrashUtil.getOriginalTitle((String)fileShortcut.getToTitle()));
        SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)fileShortcut, (int)10007, (String)extraDataJSONObject.toString(), (long)0L);
        this.trashEntryLocalService.addTrashEntry(userId, fileShortcut.getGroupId(), DLFileShortcutConstants.getClassName(), fileShortcut.getFileShortcutId(), fileShortcut.getUuid(), null, oldStatus, null, null);
        return new LiferayFileShortcut(dlFileShortcut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Folder moveFolderFromTrash(long userId, Folder folder, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        boolean hasLock = this.dlFolderLocalService.hasFolderLock(userId, folder.getFolderId());
        Lock lock = null;
        if (!hasLock) {
            lock = this.dlFolderLocalService.lockFolder(userId, folder.getFolderId());
        }
        try {
            Folder folder2 = this.doMoveFolderFromTrash(userId, folder, parentFolderId, serviceContext);
            return folder2;
        }
        finally {
            if (!hasLock) {
                this.dlFolderLocalService.unlockFolder(folder.getFolderId(), lock.getUuid());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Folder moveFolderToTrash(long userId, Folder folder) throws PortalException {
        boolean hasLock = this.dlFolderLocalService.hasFolderLock(userId, folder.getFolderId());
        Lock lock = null;
        if (!hasLock) {
            lock = this.dlFolderLocalService.lockFolder(userId, folder.getFolderId());
        }
        try {
            Folder folder2 = this.doMoveFolderToTrash(userId, folder);
            return folder2;
        }
        finally {
            if (!hasLock) {
                this.dlFolderLocalService.unlockFolder(folder.getFolderId(), lock.getUuid());
            }
        }
    }

    @Async
    public void reindex(long companyId, List<Long> dlFileEntryIds) throws PortalException {
        IntervalActionProcessor intervalActionProcessor = new IntervalActionProcessor(dlFileEntryIds.size());
        intervalActionProcessor.setPerformIntervalActionMethod((start, end) -> {
            List sublist = dlFileEntryIds.subList(start, end);
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(DLFileEntry.class);
            IndexableActionableDynamicQuery indexableActionableDynamicQuery = this.dlFileEntryLocalService.getIndexableActionableDynamicQuery();
            indexableActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
                Property dlFileEntryId = PropertyFactoryUtil.forName((String)"fileEntryId");
                dynamicQuery.add(dlFileEntryId.in((Collection)sublist));
            });
            indexableActionableDynamicQuery.setCompanyId(companyId);
            indexableActionableDynamicQuery.setPerformActionMethod(dlFileEntry -> indexableActionableDynamicQuery.addDocuments(new Document[]{indexer.getDocument(dlFileEntry)}));
            indexableActionableDynamicQuery.setSearchEngineId(indexer.getSearchEngineId());
            indexableActionableDynamicQuery.performActions();
            intervalActionProcessor.incrementStart(sublist.size());
            return null;
        });
        intervalActionProcessor.performIntervalActions();
    }

    public void restoreDependentsFromTrash(DLFolder dlFolder) throws PortalException {
        this.trashOrRestoreFolder(dlFolder, false);
    }

    public void restoreFileEntryFromTrash(long userId, FileEntry fileEntry) throws PortalException {
        this.restoreFileEntryFromTrash(userId, fileEntry.getFolderId(), fileEntry);
    }

    public void restoreFileEntryFromTrash(long userId, long newFolderId, FileEntry fileEntry) throws PortalException {
        String originalFileName;
        DLFileEntry dlFileEntry = (DLFileEntry)fileEntry.getModel();
        if (!dlFileEntry.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        FileVersion fileVersion = fileEntry.getFileVersion();
        if (!DLAppHelperThreadLocal.isEnabled()) {
            this.dlFileEntryLocalService.updateStatus(userId, fileVersion.getFileVersionId(), 0, new ServiceContext(), new HashMap());
            return;
        }
        String originalTitle = TrashUtil.getOriginalTitle((String)dlFileEntry.getTitle());
        String title = this.dlFileEntryLocalService.getUniqueTitle(dlFileEntry.getGroupId(), newFolderId, dlFileEntry.getFileEntryId(), originalTitle, dlFileEntry.getExtension());
        String fileName = originalFileName = TrashUtil.getOriginalTitle((String)dlFileEntry.getTitle(), (String)"fileName");
        if (!StringUtil.equals((String)title, (String)originalTitle)) {
            fileName = DLUtil.getSanitizedFileName((String)title, (String)DLAppUtil.getExtension(title, originalFileName));
        }
        dlFileEntry.setFileName(fileName);
        dlFileEntry.setTitle(title);
        dlFileEntry = (DLFileEntry)this.dlFileEntryPersistence.update((BaseModel)dlFileEntry);
        DLFileVersion dlFileVersion = (DLFileVersion)fileVersion.getModel();
        dlFileVersion.setFileName(fileName);
        dlFileVersion.setTitle(title);
        dlFileVersion = (DLFileVersion)this.dlFileVersionPersistence.update((BaseModel)dlFileVersion);
        TrashEntry trashEntry = this.trashEntryLocalService.getEntry(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
        this.dlFileEntryLocalService.updateStatus(userId, dlFileEntry, dlFileVersion, trashEntry.getStatus(), new ServiceContext(), new HashMap());
        this.dlFileShortcutLocalService.enableFileShortcuts(fileEntry.getFileEntryId());
        this.triggerRepositoryEvent(fileEntry.getRepositoryId(), TrashRepositoryEventType.EntryRestored.class, FileEntry.class, fileEntry);
        List trashVersions = this.trashVersionLocalService.getVersions(trashEntry.getEntryId());
        for (TrashVersion trashVersion : trashVersions) {
            DLFileVersion trashDLFileVersion = this.dlFileVersionPersistence.findByPrimaryKey(trashVersion.getClassPK());
            trashDLFileVersion.setStatus(trashVersion.getStatus());
            this.dlFileVersionPersistence.update((BaseModel)trashDLFileVersion);
        }
        this.trashEntryLocalService.deleteEntry(trashEntry.getEntryId());
        JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)fileEntry.getTitle());
        SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)fileEntry, (int)10008, (String)extraDataJSONObject.toString(), (long)0L);
    }

    public void restoreFileShortcutFromTrash(long userId, FileShortcut fileShortcut) throws PortalException {
        DLFileShortcut dlFileShortcut = (DLFileShortcut)fileShortcut.getModel();
        if (!dlFileShortcut.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        TrashEntry trashEntry = this.trashEntryLocalService.getEntry(DLFileShortcutConstants.getClassName(), fileShortcut.getFileShortcutId());
        this.dlFileShortcutLocalService.updateStatus(userId, fileShortcut.getFileShortcutId(), trashEntry.getStatus(), new ServiceContext());
        JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)fileShortcut.getToTitle());
        SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)fileShortcut, (int)10008, (String)extraDataJSONObject.toString(), (long)0L);
        this.trashEntryLocalService.deleteEntry(trashEntry.getEntryId());
    }

    public void restoreFolderFromTrash(long userId, Folder folder) throws PortalException {
        DLFolder dlFolder = (DLFolder)folder.getModel();
        if (!dlFolder.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        String originalName = TrashUtil.getOriginalTitle((String)dlFolder.getName());
        dlFolder.setName(this.dlFolderLocalService.getUniqueFolderName(folder.getUuid(), folder.getGroupId(), folder.getParentFolderId(), originalName, 2));
        dlFolder = (DLFolder)this.dlFolderPersistence.update((BaseModel)dlFolder);
        TrashEntry trashEntry = this.trashEntryLocalService.getEntry(DLFolder.class.getName(), dlFolder.getFolderId());
        this.dlFolderLocalService.updateStatus(userId, folder.getFolderId(), trashEntry.getStatus(), new HashMap(), new ServiceContext());
        this.restoreDependentsFromTrash(dlFolder);
        this.triggerRepositoryEvent(folder.getRepositoryId(), TrashRepositoryEventType.EntryRestored.class, Folder.class, folder);
        this.trashEntryLocalService.deleteEntry(trashEntry.getEntryId());
        JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)folder.getName());
        SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)folder, (int)10008, (String)extraDataJSONObject.toString(), (long)0L);
    }

    public AssetEntry updateAsset(long userId, FileEntry fileEntry, FileVersion fileVersion, long assetClassPK) throws PortalException {
        long[] assetCategoryIds = this.assetCategoryLocalService.getCategoryIds(DLFileEntryConstants.getClassName(), assetClassPK);
        String[] assetTagNames = this.assetTagLocalService.getTagNames(DLFileEntryConstants.getClassName(), assetClassPK);
        AssetEntry assetEntry = this.assetEntryLocalService.fetchEntry(DLFileEntryConstants.getClassName(), assetClassPK);
        List assetLinks = null;
        if (assetEntry != null) {
            assetLinks = this.assetLinkLocalService.getDirectLinks(assetEntry.getEntryId(), false);
        }
        long[] assetLinkIds = ListUtil.toLongArray(assetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR);
        return this.updateAsset(userId, fileEntry, fileVersion, assetCategoryIds, assetTagNames, assetLinkIds);
    }

    public AssetEntry updateAsset(long userId, FileEntry fileEntry, FileVersion fileVersion, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds) throws PortalException {
        AssetEntry assetEntry = null;
        boolean visible = false;
        boolean addDraftAssetEntry = false;
        if (fileEntry instanceof LiferayFileEntry) {
            DLFileVersion dlFileVersion = (DLFileVersion)fileVersion.getModel();
            if (dlFileVersion.isApproved()) {
                visible = true;
            } else {
                String version = dlFileVersion.getVersion();
                if (!version.equals("1.0")) {
                    addDraftAssetEntry = true;
                }
            }
        } else {
            visible = true;
        }
        long fileEntryTypeId = this.getFileEntryTypeId(fileEntry);
        if (addDraftAssetEntry) {
            if (assetCategoryIds == null) {
                assetCategoryIds = this.assetCategoryLocalService.getCategoryIds(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
            }
            if (assetTagNames == null) {
                assetTagNames = this.assetTagLocalService.getTagNames(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
            }
            if (assetLinkEntryIds == null) {
                AssetEntry previousAssetEntry = this.assetEntryLocalService.getEntry(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
                List assetLinks = this.assetLinkLocalService.getDirectLinks(previousAssetEntry.getEntryId(), 0, false);
                assetLinkEntryIds = ListUtil.toLongArray((List)assetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR);
            }
            assetEntry = this.assetEntryLocalService.updateEntry(userId, fileEntry.getGroupId(), fileEntry.getCreateDate(), fileEntry.getModifiedDate(), DLFileEntryConstants.getClassName(), fileVersion.getFileVersionId(), fileEntry.getUuid(), fileEntryTypeId, assetCategoryIds, assetTagNames, true, false, null, null, null, fileEntry.getExpirationDate(), fileEntry.getMimeType(), fileEntry.getTitle(), fileEntry.getDescription(), null, null, null, 0, 0, null);
        } else {
            Date publishDate = null;
            if (visible) {
                publishDate = fileEntry.getCreateDate();
            }
            assetEntry = this.assetEntryLocalService.updateEntry(userId, fileEntry.getGroupId(), fileEntry.getCreateDate(), fileEntry.getModifiedDate(), DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId(), fileEntry.getUuid(), fileEntryTypeId, assetCategoryIds, assetTagNames, true, visible, null, null, publishDate, fileEntry.getExpirationDate(), fileEntry.getMimeType(), fileEntry.getTitle(), fileEntry.getDescription(), null, null, null, 0, 0, null);
            List dlFileShortcuts = this.dlFileShortcutPersistence.findByToFileEntryId(fileEntry.getFileEntryId());
            for (DLFileShortcut dlFileShortcut : dlFileShortcuts) {
                this.assetEntryLocalService.updateEntry(userId, dlFileShortcut.getGroupId(), dlFileShortcut.getCreateDate(), dlFileShortcut.getModifiedDate(), DLFileShortcutConstants.getClassName(), dlFileShortcut.getFileShortcutId(), dlFileShortcut.getUuid(), fileEntryTypeId, assetCategoryIds, assetTagNames, true, true, null, null, dlFileShortcut.getCreateDate(), null, fileEntry.getMimeType(), fileEntry.getTitle(), fileEntry.getDescription(), null, null, null, 0, 0, null);
            }
        }
        this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
        return assetEntry;
    }

    public AssetEntry updateAsset(long userId, Folder folder, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds) throws PortalException {
        boolean visible = false;
        if (folder instanceof LiferayFolder) {
            DLFolder dlFolder = (DLFolder)folder.getModel();
            if (dlFolder.isApproved() && !dlFolder.isHidden() && !dlFolder.isInHiddenFolder()) {
                visible = true;
            }
        } else {
            visible = true;
        }
        Date publishDate = null;
        if (visible) {
            publishDate = folder.getCreateDate();
        }
        AssetEntry assetEntry = this.assetEntryLocalService.updateEntry(userId, folder.getGroupId(), folder.getCreateDate(), folder.getModifiedDate(), DLFolderConstants.getClassName(), folder.getFolderId(), folder.getUuid(), 0L, assetCategoryIds, assetTagNames, true, visible, null, null, publishDate, null, null, folder.getName(), folder.getDescription(), null, null, null, 0, 0, null);
        this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
        return assetEntry;
    }

    public void updateFileEntry(long userId, FileEntry fileEntry, FileVersion sourceFileVersion, FileVersion destinationFileVersion, long assetClassPK) throws PortalException {
        String version;
        if (!DLAppHelperThreadLocal.isEnabled()) {
            return;
        }
        boolean updateAsset = true;
        if (fileEntry instanceof LiferayFileEntry && (version = fileEntry.getVersion()).equals(destinationFileVersion.getVersion())) {
            updateAsset = false;
        }
        if (updateAsset) {
            this.updateAsset(userId, fileEntry, destinationFileVersion, assetClassPK);
        }
    }

    public void updateFileEntry(long userId, FileEntry fileEntry, FileVersion sourceFileVersion, FileVersion destinationFileVersion, ServiceContext serviceContext) throws PortalException {
        if (!DLAppHelperThreadLocal.isEnabled()) {
            return;
        }
        if (Objects.equals(serviceContext.getCommand(), "revert")) {
            List assetCategories = this.assetCategoryLocalService.getCategories(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
            List assetCategoryIds = ListUtil.toList((List)assetCategories, (Accessor)AssetCategory.CATEGORY_ID_ACCESSOR);
            serviceContext.setAssetCategoryIds(ArrayUtil.toLongArray((Collection)assetCategoryIds));
        }
        this.updateAsset(userId, fileEntry, destinationFileVersion, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
    }

    public void updateFolder(long userId, Folder folder, ServiceContext serviceContext) throws PortalException {
        this.updateAsset(userId, folder, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
    }

    public void updateStatus(long userId, FileEntry fileEntry, FileVersion latestFileVersion, int oldStatus, int newStatus, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        if (!DLAppHelperThreadLocal.isEnabled()) {
            return;
        }
        if (newStatus == 0) {
            String event;
            String latestFileVersionVersion = latestFileVersion.getVersion();
            if (latestFileVersionVersion.equals(fileEntry.getVersion())) {
                AssetEntry assetEntry;
                AssetEntry draftAssetEntry;
                if (!latestFileVersionVersion.equals("1.0") && (draftAssetEntry = this.assetEntryLocalService.fetchEntry(DLFileEntryConstants.getClassName(), latestFileVersion.getPrimaryKey())) != null) {
                    long fileEntryTypeId = this.getFileEntryTypeId(fileEntry);
                    long[] assetCategoryIds = draftAssetEntry.getCategoryIds();
                    String[] assetTagNames = draftAssetEntry.getTagNames();
                    List assetLinks = this.assetLinkLocalService.getDirectLinks(draftAssetEntry.getEntryId(), 0, false);
                    long[] assetLinkEntryIds = ListUtil.toLongArray((List)assetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR);
                    AssetEntry assetEntry2 = this.assetEntryLocalService.updateEntry(userId, fileEntry.getGroupId(), fileEntry.getCreateDate(), fileEntry.getModifiedDate(), DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId(), fileEntry.getUuid(), fileEntryTypeId, assetCategoryIds, assetTagNames, true, true, null, null, fileEntry.getCreateDate(), fileEntry.getExpirationDate(), draftAssetEntry.getMimeType(), fileEntry.getTitle(), fileEntry.getDescription(), null, null, null, 0, 0, null);
                    this.assetLinkLocalService.updateLinks(userId, assetEntry2.getEntryId(), assetLinkEntryIds, 0);
                    this.assetEntryLocalService.deleteEntry(draftAssetEntry);
                }
                if ((assetEntry = this.assetEntryLocalService.fetchEntry(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId())) != null) {
                    this.assetEntryLocalService.updateEntry(assetEntry.getClassName(), assetEntry.getClassPK(), assetEntry.getCreateDate(), assetEntry.getExpirationDate(), assetEntry.isListable(), true);
                }
            }
            if (Validator.isNotNull((String)(event = GetterUtil.getString((Object)workflowContext.get("event"))))) {
                this.triggerRepositoryEvent(fileEntry.getRepositoryId(), this.getWorkflowRepositoryEventTypeClass(event), FileEntry.class, fileEntry);
            }
            if (oldStatus != 8 && !fileEntry.isInTrash()) {
                Date activityCreateDate = latestFileVersion.getModifiedDate();
                int activityType = 2;
                if (event.equals("add")) {
                    activityCreateDate = latestFileVersion.getCreateDate();
                    activityType = 1;
                }
                JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)fileEntry.getTitle());
                SocialActivityManagerUtil.addUniqueActivity((long)latestFileVersion.getStatusByUserId(), (Date)activityCreateDate, (ClassedModel)fileEntry, (int)activityType, (String)extraDataJSONObject.toString(), (long)0L);
            }
        } else {
            List approvedFileVersions;
            boolean visible = false;
            if (newStatus != 8 && !(approvedFileVersions = this.dlFileVersionPersistence.findByF_S(fileEntry.getFileEntryId(), 0)).isEmpty()) {
                visible = true;
            }
            this.assetEntryLocalService.updateVisible(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId(), visible);
        }
    }

    protected FileEntry doMoveFileEntryFromTrash(long userId, FileEntry fileEntry, long newFolderId, ServiceContext serviceContext) throws PortalException {
        DLFileEntry dlFileEntry = (DLFileEntry)fileEntry.getModel();
        if (!dlFileEntry.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        if (dlFileEntry.isInTrashExplicitly()) {
            this.restoreFileEntryFromTrash(userId, newFolderId, fileEntry);
            if (fileEntry.getFolderId() != newFolderId) {
                fileEntry = this.dlAppLocalService.moveFileEntry(userId, fileEntry.getFileEntryId(), newFolderId, serviceContext);
            }
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(DLFileEntry.class);
            indexer.reindex((Object)((DLFileEntry)fileEntry.getModel()));
            return fileEntry;
        }
        List dlFileVersions = this.dlFileVersionLocalService.getFileVersions(fileEntry.getFileEntryId(), 8);
        dlFileVersions = ListUtil.sort((List)dlFileVersions, (Comparator)new DLFileVersionVersionComparator());
        LiferayFileVersion fileVersion = new LiferayFileVersion((DLFileVersion)dlFileVersions.get(0));
        TrashVersion trashVersion = this.trashVersionLocalService.fetchVersion(DLFileVersion.class.getName(), fileVersion.getFileVersionId());
        int oldStatus = 0;
        if (trashVersion != null) {
            oldStatus = trashVersion.getStatus();
        }
        this.dlFileEntryLocalService.updateStatus(userId, dlFileEntry, (DLFileVersion)dlFileVersions.get(0), oldStatus, serviceContext, new HashMap());
        for (DLFileVersion dlFileVersion : dlFileVersions) {
            trashVersion = this.trashVersionLocalService.fetchVersion(DLFileVersion.class.getName(), dlFileVersion.getFileVersionId());
            oldStatus = 0;
            if (trashVersion != null) {
                oldStatus = trashVersion.getStatus();
            }
            dlFileVersion.setStatus(oldStatus);
            this.dlFileVersionPersistence.update((BaseModel)dlFileVersion);
            if (trashVersion == null) continue;
            this.trashVersionLocalService.deleteTrashVersion(trashVersion);
        }
        if (DLAppHelperThreadLocal.isEnabled()) {
            this.dlFileShortcutLocalService.enableFileShortcuts(fileEntry.getFileEntryId());
        }
        fileEntry = this.dlAppLocalService.moveFileEntry(userId, fileEntry.getFileEntryId(), newFolderId, serviceContext);
        this.triggerRepositoryEvent(fileEntry.getRepositoryId(), TrashRepositoryEventType.EntryRestored.class, FileEntry.class, fileEntry);
        JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)fileEntry.getTitle());
        SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)fileEntry, (int)10008, (String)extraDataJSONObject.toString(), (long)0L);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(DLFileEntry.class);
        indexer.reindex((Object)((DLFileEntry)fileEntry.getModel()));
        return fileEntry;
    }

    protected FileEntry doMoveFileEntryToTrash(long userId, FileEntry fileEntry) throws PortalException {
        if (fileEntry.isInTrash()) {
            throw new TrashEntryException();
        }
        List dlFileVersions = this.dlFileVersionLocalService.getFileVersions(fileEntry.getFileEntryId(), -1);
        dlFileVersions = ListUtil.sort((List)dlFileVersions, (Comparator)new DLFileVersionVersionComparator());
        List<Object> dlFileVersionStatusOVPs = new ArrayList();
        if (dlFileVersions != null && !dlFileVersions.isEmpty()) {
            dlFileVersionStatusOVPs = this.getDlFileVersionStatuses(dlFileVersions);
        }
        FileVersion fileVersion = fileEntry.getLatestFileVersion(true);
        this.dlFileEntryLocalService.updateStatus(userId, fileVersion.getFileVersionId(), 8, new ServiceContext(), new HashMap());
        if (DLAppHelperThreadLocal.isEnabled()) {
            this.dlFileShortcutLocalService.disableFileShortcuts(fileEntry.getFileEntryId());
            this.triggerRepositoryEvent(fileEntry.getRepositoryId(), TrashRepositoryEventType.EntryTrashed.class, FileEntry.class, fileEntry);
        }
        dlFileVersions = this.dlFileVersionLocalService.getFileVersions(fileEntry.getFileEntryId(), -1);
        for (DLFileVersion curDLFileVersion : dlFileVersions) {
            curDLFileVersion.setStatus(8);
            this.dlFileVersionPersistence.update((BaseModel)curDLFileVersion);
        }
        if (!DLAppHelperThreadLocal.isEnabled()) {
            return fileEntry;
        }
        DLFileEntry dlFileEntry = (DLFileEntry)fileEntry.getModel();
        DLFileVersion oldDLFileVersion = (DLFileVersion)fileVersion.getModel();
        int oldDLFileVersionStatus = oldDLFileVersion.getStatus();
        UnicodeProperties typeSettingsUnicodeProperties = new UnicodeProperties();
        typeSettingsUnicodeProperties.put("fileName", dlFileEntry.getFileName());
        typeSettingsUnicodeProperties.put("title", dlFileEntry.getTitle());
        TrashEntry trashEntry = this.trashEntryLocalService.addTrashEntry(userId, dlFileEntry.getGroupId(), DLFileEntryConstants.getClassName(), dlFileEntry.getFileEntryId(), dlFileEntry.getUuid(), dlFileEntry.getClassName(), oldDLFileVersionStatus, dlFileVersionStatusOVPs, typeSettingsUnicodeProperties);
        String trashTitle = TrashUtil.getTrashTitle((long)trashEntry.getEntryId());
        dlFileEntry.setFileName(trashTitle);
        dlFileEntry.setTitle(trashTitle);
        dlFileEntry = (DLFileEntry)this.dlFileEntryPersistence.update((BaseModel)dlFileEntry);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(DLFileEntry.class);
        indexer.reindex((Object)dlFileEntry);
        JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)TrashUtil.getOriginalTitle((String)fileEntry.getTitle()));
        SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)fileEntry, (int)10007, (String)extraDataJSONObject.toString(), (long)0L);
        int oldStatus = fileVersion.getStatus();
        if (oldStatus == 1) {
            this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(fileVersion.getCompanyId(), fileVersion.getGroupId(), DLFileEntryConstants.getClassName(), fileVersion.getFileVersionId());
        }
        return fileEntry;
    }

    protected Folder doMoveFolderFromTrash(long userId, Folder folder, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        DLFolder dlFolder = (DLFolder)folder.getModel();
        if (!dlFolder.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        if (dlFolder.isInTrashExplicitly()) {
            this.restoreFolderFromTrash(userId, folder);
        } else {
            TrashVersion trashVersion = this.trashVersionLocalService.fetchVersion(DLFolder.class.getName(), dlFolder.getFolderId());
            int status = 0;
            if (trashVersion != null) {
                status = trashVersion.getStatus();
            }
            this.dlFolderLocalService.updateStatus(userId, folder.getFolderId(), status, new HashMap(), new ServiceContext());
            if (trashVersion != null) {
                this.trashVersionLocalService.deleteTrashVersion(trashVersion);
            }
            this.restoreDependentsFromTrash(dlFolder);
            this.triggerRepositoryEvent(folder.getRepositoryId(), TrashRepositoryEventType.EntryRestored.class, Folder.class, folder);
            JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)folder.getName());
            SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)folder, (int)10008, (String)extraDataJSONObject.toString(), (long)0L);
        }
        return this.dlAppLocalService.moveFolder(userId, folder.getFolderId(), parentFolderId, serviceContext);
    }

    protected Folder doMoveFolderToTrash(long userId, Folder folder) throws PortalException {
        DLFolder dlFolder = (DLFolder)folder.getModel();
        if (dlFolder.isInTrash()) {
            throw new TrashEntryException();
        }
        dlFolder = this.dlFolderLocalService.updateStatus(userId, folder.getFolderId(), 8, new HashMap(), new ServiceContext());
        UnicodeProperties typeSettingsUnicodeProperties = new UnicodeProperties();
        typeSettingsUnicodeProperties.put("title", dlFolder.getName());
        TrashEntry trashEntry = this.trashEntryLocalService.addTrashEntry(userId, dlFolder.getGroupId(), DLFolderConstants.getClassName(), dlFolder.getFolderId(), dlFolder.getUuid(), null, 0, null, typeSettingsUnicodeProperties);
        dlFolder.setName(TrashUtil.getTrashTitle((long)trashEntry.getEntryId()));
        dlFolder = (DLFolder)this.dlFolderPersistence.update((BaseModel)dlFolder);
        this.moveDependentsToTrash(dlFolder);
        this.triggerRepositoryEvent(folder.getRepositoryId(), TrashRepositoryEventType.EntryTrashed.class, Folder.class, folder);
        JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)folder.getName());
        SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)folder, (int)10007, (String)extraDataJSONObject.toString(), (long)0L);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(DLFolder.class);
        indexer.reindex((Object)dlFolder);
        return new LiferayFolder(dlFolder);
    }

    protected ActionableDynamicQuery getCancelCheckOutsActionableDynamicQuery(long groupId) {
        ActionableDynamicQuery fileEntryActionableDynamicQuery = this.dlFileEntryLocalService.getActionableDynamicQuery();
        fileEntryActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property fileEntryIdProperty = PropertyFactoryUtil.forName((String)"fileEntryId");
            DynamicQuery fileVersionDynamicQuery = DynamicQueryFactoryUtil.forClass(DLFileVersion.class, (String)"dlFileVersion", (ClassLoader)PortalClassLoaderUtil.getClassLoader());
            fileVersionDynamicQuery.setProjection(ProjectionFactoryUtil.property((String)"fileEntryId"));
            fileVersionDynamicQuery.add(RestrictionsFactoryUtil.eqProperty((String)"dlFileVersion.fileEntryId", (String)"this.fileEntryId"));
            Property versionProperty = PropertyFactoryUtil.forName((String)"version");
            fileVersionDynamicQuery.add(versionProperty.eq((Object)"PWC"));
            dynamicQuery.add(fileEntryIdProperty.in(fileVersionDynamicQuery));
        });
        fileEntryActionableDynamicQuery.setGroupId(groupId);
        fileEntryActionableDynamicQuery.setPerformActionMethod(dlFileEntry -> this.dlAppService.cancelCheckOut(dlFileEntry.getFileEntryId()));
        return fileEntryActionableDynamicQuery;
    }

    protected List<ObjectValuePair<Long, Integer>> getDlFileVersionStatuses(List<DLFileVersion> dlFileVersions) {
        ArrayList<ObjectValuePair<Long, Integer>> dlFileVersionStatusOVPs = new ArrayList<ObjectValuePair<Long, Integer>>(dlFileVersions.size());
        for (DLFileVersion dlFileVersion : dlFileVersions) {
            int status = dlFileVersion.getStatus();
            if (status == 1) {
                status = 2;
            }
            ObjectValuePair dlFileVersionStatusOVP = new ObjectValuePair((Object)dlFileVersion.getFileVersionId(), (Object)status);
            dlFileVersionStatusOVPs.add((ObjectValuePair<Long, Integer>)dlFileVersionStatusOVP);
        }
        return dlFileVersionStatusOVPs;
    }

    protected long getFileEntryTypeId(FileEntry fileEntry) {
        if (fileEntry instanceof LiferayFileEntry) {
            DLFileEntry dlFileEntry = (DLFileEntry)fileEntry.getModel();
            return dlFileEntry.getFileEntryTypeId();
        }
        return 0L;
    }

    protected Class<? extends WorkflowRepositoryEventType> getWorkflowRepositoryEventTypeClass(String syncEvent) {
        if (syncEvent.equals("add")) {
            return WorkflowRepositoryEventType.Add.class;
        }
        if (syncEvent.equals("update")) {
            return WorkflowRepositoryEventType.Update.class;
        }
        throw new IllegalArgumentException(String.format("Unsupported sync event %s", syncEvent));
    }

    protected void trashOrRestoreFolder(DLFolder dlFolder, boolean moveToTrash) throws PortalException {
        TrashEntry trashEntry = null;
        if (moveToTrash) {
            trashEntry = this.trashEntryLocalService.getEntry(DLFolderConstants.getClassName(), dlFolder.getFolderId());
        }
        long dlFileEntryClassNameId = this.classNameLocalService.getClassNameId(DLFileEntry.class);
        List dlFileEntries = this.dlFileEntryFinder.findByC_T(dlFileEntryClassNameId, dlFolder.getTreePath());
        for (DLFileEntry dlFileEntry : dlFileEntries) {
            this.assetEntryLocalService.updateVisible(DLFileEntry.class.getName(), dlFileEntry.getFileEntryId(), !moveToTrash);
        }
        long dlFolderClassNameId = this.classNameLocalService.getClassNameId(DLFolder.class);
        List dlFolders = this.dlFolderFinder.findF_ByC_T(dlFolderClassNameId, dlFolder.getTreePath());
        for (DLFolder curDLFolder : dlFolders) {
            this.assetEntryLocalService.updateVisible(DLFolder.class.getName(), curDLFolder.getFolderId(), !moveToTrash);
        }
        dlFolders = this.dlFolderPersistence.findByG_M_T_H(dlFolder.getGroupId(), false, CustomSQLUtil.keywords((String)dlFolder.getTreePath(), (WildcardMode)WildcardMode.TRAILING)[0], false);
        for (DLFolder childDLFolder : dlFolders) {
            this.trashOrRestoreFolder(dlFolder, childDLFolder, moveToTrash, trashEntry);
        }
    }

    protected void trashOrRestoreFolder(DLFolder dlFolder, DLFolder childDLFolder, boolean moveToTrash, TrashEntry trashEntry) throws PortalException {
        ArrayList<Long> dlFileEntryIds = new ArrayList<Long>();
        List dlFileEntries = this.dlFileEntryLocalService.getFileEntries(childDLFolder.getGroupId(), childDLFolder.getFolderId());
        for (Object dlFileEntry : dlFileEntries) {
            if (moveToTrash ? dlFileEntry.isInTrashExplicitly() : !dlFileEntry.isInTrashImplicitly()) continue;
            this.dlFileShortcutLocalService.updateFileShortcutsActive(dlFileEntry.getFileEntryId(), !moveToTrash);
            List dlFileVersions = null;
            dlFileVersions = moveToTrash ? this.dlFileVersionLocalService.getFileVersions(dlFileEntry.getFileEntryId(), -1) : this.dlFileVersionLocalService.getFileVersions(dlFileEntry.getFileEntryId(), 8);
            for (DLFileVersion dlFileVersion : dlFileVersions) {
                if (moveToTrash) {
                    int oldStatus = dlFileVersion.getStatus();
                    dlFileVersion.setStatus(8);
                    dlFileVersion = (DLFileVersion)this.dlFileVersionPersistence.update((BaseModel)dlFileVersion);
                    if (oldStatus != 0) {
                        int newStatus = oldStatus;
                        if (oldStatus == 1) {
                            newStatus = 2;
                        }
                        this.trashVersionLocalService.addTrashVersion(trashEntry.getEntryId(), DLFileVersion.class.getName(), dlFileVersion.getFileVersionId(), newStatus, null);
                    }
                    if (oldStatus != 1) continue;
                    this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(dlFileVersion.getCompanyId(), dlFileVersion.getGroupId(), DLFileEntryConstants.getClassName(), dlFileVersion.getFileVersionId());
                    continue;
                }
                TrashVersion trashVersion = this.trashVersionLocalService.fetchVersion(DLFileVersion.class.getName(), dlFileVersion.getFileVersionId());
                int oldStatus = 0;
                if (trashVersion != null) {
                    oldStatus = trashVersion.getStatus();
                }
                dlFileVersion.setStatus(oldStatus);
                this.dlFileVersionPersistence.update((BaseModel)dlFileVersion);
                if (trashVersion == null) continue;
                this.trashVersionLocalService.deleteTrashVersion(trashVersion);
            }
            dlFileEntryIds.add(dlFileEntry.getFileEntryId());
        }
        if (!dlFileEntryIds.isEmpty()) {
            this.dlAppHelperLocalService.reindex(dlFolder.getCompanyId(), dlFileEntryIds);
        }
        List dlFileShortcuts = this.dlFileShortcutPersistence.findByG_F(childDLFolder.getGroupId(), childDLFolder.getFolderId());
        for (DLFileShortcut dlFileShortcut : dlFileShortcuts) {
            if (moveToTrash) {
                if (dlFileShortcut.isInTrashExplicitly()) continue;
                int oldStatus = dlFileShortcut.getStatus();
                dlFileShortcut.setStatus(8);
                dlFileShortcut = (DLFileShortcut)this.dlFileShortcutPersistence.update((BaseModel)dlFileShortcut);
                if (oldStatus == 0) continue;
                this.trashVersionLocalService.addTrashVersion(trashEntry.getEntryId(), DLFileShortcutConstants.getClassName(), dlFileShortcut.getFileShortcutId(), oldStatus, null);
                continue;
            }
            if (!dlFileShortcut.isInTrashImplicitly()) continue;
            TrashVersion trashVersion = this.trashVersionLocalService.fetchVersion(DLFileShortcutConstants.getClassName(), dlFileShortcut.getFileShortcutId());
            int oldStatus = 0;
            if (trashVersion != null) {
                oldStatus = trashVersion.getStatus();
            }
            dlFileShortcut.setStatus(oldStatus);
            this.dlFileShortcutPersistence.update((BaseModel)dlFileShortcut);
            if (trashVersion == null) continue;
            this.trashVersionLocalService.deleteTrashVersion(trashVersion);
        }
        if (childDLFolder.equals(dlFolder)) {
            return;
        }
        if (moveToTrash) {
            if (childDLFolder.isInTrashExplicitly()) {
                return;
            }
            int oldStatus = childDLFolder.getStatus();
            childDLFolder.setStatus(8);
            childDLFolder = (DLFolder)this.dlFolderPersistence.update((BaseModel)childDLFolder);
            if (oldStatus != 0) {
                this.trashVersionLocalService.addTrashVersion(trashEntry.getEntryId(), DLFolder.class.getName(), childDLFolder.getFolderId(), oldStatus, null);
            }
        } else {
            if (!childDLFolder.isInTrashImplicitly()) {
                return;
            }
            TrashVersion trashVersion = this.trashVersionLocalService.fetchVersion(DLFolder.class.getName(), childDLFolder.getFolderId());
            int oldStatus = 0;
            if (trashVersion != null) {
                oldStatus = trashVersion.getStatus();
            }
            childDLFolder.setStatus(oldStatus);
            childDLFolder = (DLFolder)this.dlFolderPersistence.update((BaseModel)childDLFolder);
            if (trashVersion != null) {
                this.trashVersionLocalService.deleteTrashVersion(trashVersion);
            }
        }
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(DLFolder.class);
        indexer.reindex((Object)childDLFolder);
    }

    protected <T extends RepositoryModel<T>> void triggerRepositoryEvent(long repositoryId, Class<? extends RepositoryEventType> repositoryEventType, Class<T> modelClass, T target) throws PortalException {
        Repository repository = RepositoryProviderUtil.getRepository((long)repositoryId);
        if (repository.isCapabilityProvided(RepositoryEventTriggerCapability.class)) {
            RepositoryEventTriggerCapability repositoryEventTriggerCapability = (RepositoryEventTriggerCapability)repository.getCapability(RepositoryEventTriggerCapability.class);
            repositoryEventTriggerCapability.trigger(repositoryEventType, modelClass, target);
        }
    }

    private void _deleteFileEntry(long fileEntryId) throws PortalException {
        this.dlFileShortcutLocalService.deleteFileShortcuts(fileEntryId);
        this.assetEntryLocalService.deleteEntry(DLFileEntryConstants.getClassName(), fileEntryId);
        this.ratingsStatsLocalService.deleteStats(DLFileEntryConstants.getClassName(), fileEntryId);
    }

    private class DLSyncConstants {
        public static final String EVENT_ADD = "add";
        public static final String EVENT_UPDATE = "update";

        private DLSyncConstants() {
        }
    }
}

