/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.document.library.kernel.exception.DuplicateFileEntryTypeException;
import com.liferay.document.library.kernel.exception.NoSuchFileEntryTypeException;
import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.document.library.kernel.exception.NoSuchMetadataSetException;
import com.liferay.document.library.kernel.exception.RequiredFileEntryTypeException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryMetadata;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.model.DLVersionNumberIncrease;
import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalServiceUtil;
import com.liferay.document.library.kernel.service.persistence.DLFolderPersistence;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.dynamic.data.mapping.kernel.DDMForm;
import com.liferay.dynamic.data.mapping.kernel.DDMStructure;
import com.liferay.dynamic.data.mapping.kernel.DDMStructureLink;
import com.liferay.dynamic.data.mapping.kernel.DDMStructureLinkManagerUtil;
import com.liferay.dynamic.data.mapping.kernel.DDMStructureManagerUtil;
import com.liferay.dynamic.data.mapping.kernel.StructureDefinitionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.SortedArrayList;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portlet.documentlibrary.service.base.DLFileEntryTypeLocalServiceBaseImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class DLFileEntryTypeLocalServiceImpl
extends DLFileEntryTypeLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(DLFileEntryTypeLocalServiceImpl.class);

    public void addDDMStructureLinks(long fileEntryTypeId, Set<Long> ddmStructureIds) {
        long classNameId = this.classNameLocalService.getClassNameId(DLFileEntryType.class);
        for (long ddmStructureId : ddmStructureIds) {
            DDMStructureLinkManagerUtil.addStructureLink((long)classNameId, (long)fileEntryTypeId, (long)ddmStructureId);
        }
    }

    public DLFileEntryType addFileEntryType(long userId, long groupId, long dataDefinitionId, String fileEntryTypeKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, int scope, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        fileEntryTypeKey = Validator.isNull((String)fileEntryTypeKey) ? String.valueOf(this.counterLocalService.increment()) : StringUtil.toUpperCase((String)fileEntryTypeKey.trim());
        String fileEntryTypeUuid = GetterUtil.getString((Object)serviceContext.getAttribute("fileEntryTypeUuid"));
        if (Validator.isNull((String)fileEntryTypeUuid) && Validator.isNull((String)(fileEntryTypeUuid = serviceContext.getUuid()))) {
            fileEntryTypeUuid = PortalUUIDUtil.generate();
        }
        this._validateFileEntryTypeKey(groupId, fileEntryTypeKey);
        this._validateDDMStructures(fileEntryTypeKey, new long[]{dataDefinitionId});
        DLFileEntryType dlFileEntryType = this.dlFileEntryTypePersistence.create(this.counterLocalService.increment());
        dlFileEntryType.setUuid(fileEntryTypeUuid);
        dlFileEntryType.setGroupId(groupId);
        dlFileEntryType.setCompanyId(user.getCompanyId());
        dlFileEntryType.setUserId(user.getUserId());
        dlFileEntryType.setUserName(user.getFullName());
        dlFileEntryType.setDataDefinitionId(dataDefinitionId);
        dlFileEntryType.setFileEntryTypeKey(fileEntryTypeKey);
        dlFileEntryType.setNameMap(nameMap);
        dlFileEntryType.setDescriptionMap(descriptionMap);
        dlFileEntryType.setScope(scope);
        dlFileEntryType = (DLFileEntryType)this.dlFileEntryTypePersistence.update((BaseModel)dlFileEntryType);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addFileEntryTypeResources(dlFileEntryType, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addFileEntryTypeResources(dlFileEntryType, serviceContext.getModelPermissions());
        }
        return dlFileEntryType;
    }

    @Deprecated
    public DLFileEntryType addFileEntryType(long userId, long groupId, long dataDefinitionId, String fileEntryTypeKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, ServiceContext serviceContext) throws PortalException {
        return this.addFileEntryType(userId, groupId, dataDefinitionId, fileEntryTypeKey, nameMap, descriptionMap, 0, serviceContext);
    }

    @Deprecated
    public DLFileEntryType addFileEntryType(long userId, long groupId, String fileEntryTypeKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, long[] ddmStructureIds, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        fileEntryTypeKey = Validator.isNull((String)fileEntryTypeKey) ? String.valueOf(this.counterLocalService.increment()) : StringUtil.toUpperCase((String)fileEntryTypeKey.trim());
        String fileEntryTypeUuid = GetterUtil.getString((Object)serviceContext.getAttribute("fileEntryTypeUuid"));
        if (Validator.isNull((String)fileEntryTypeUuid) && Validator.isNull((String)(fileEntryTypeUuid = serviceContext.getUuid()))) {
            fileEntryTypeUuid = PortalUUIDUtil.generate();
        }
        long fileEntryTypeId = this.counterLocalService.increment();
        ddmStructureIds = this._updateDDMStructure(userId, fileEntryTypeUuid, fileEntryTypeId, groupId, nameMap, descriptionMap, ddmStructureIds, serviceContext);
        this._validateFileEntryTypeKey(groupId, fileEntryTypeKey);
        this._validateDDMStructures(fileEntryTypeKey, ddmStructureIds);
        DLFileEntryType dlFileEntryType = this.dlFileEntryTypePersistence.create(fileEntryTypeId);
        dlFileEntryType.setUuid(fileEntryTypeUuid);
        dlFileEntryType.setGroupId(groupId);
        dlFileEntryType.setCompanyId(user.getCompanyId());
        dlFileEntryType.setUserId(user.getUserId());
        dlFileEntryType.setUserName(user.getFullName());
        dlFileEntryType.setDataDefinitionId(ddmStructureIds[0]);
        dlFileEntryType.setFileEntryTypeKey(fileEntryTypeKey);
        dlFileEntryType.setNameMap(nameMap);
        dlFileEntryType.setDescriptionMap(descriptionMap);
        dlFileEntryType = (DLFileEntryType)this.dlFileEntryTypePersistence.update((BaseModel)dlFileEntryType);
        this.addDDMStructureLinks(fileEntryTypeId, SetUtil.fromArray((long[])ddmStructureIds));
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addFileEntryTypeResources(dlFileEntryType, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addFileEntryTypeResources(dlFileEntryType, serviceContext.getModelPermissions());
        }
        return dlFileEntryType;
    }

    @Deprecated
    public DLFileEntryType addFileEntryType(long userId, long groupId, String name, String description, long[] ddmStructureIds, ServiceContext serviceContext) throws PortalException {
        return this.addFileEntryType(userId, groupId, null, HashMapBuilder.put((Object)LocaleUtil.getSiteDefault(), (Object)name).build(), (Map<Locale, String>)HashMapBuilder.put((Object)LocaleUtil.getSiteDefault(), (Object)description).build(), ddmStructureIds, serviceContext);
    }

    public void cascadeFileEntryTypes(long userId, DLFolder dlFolder) throws PortalException {
        long[] groupIds = PortalUtil.getCurrentAndAncestorSiteGroupIds((long)dlFolder.getGroupId());
        List<DLFileEntryType> dlFileEntryTypes = this.getFolderFileEntryTypes(groupIds, dlFolder.getFolderId(), true);
        List<Long> fileEntryTypeIds = this.getFileEntryTypeIds(dlFileEntryTypes);
        long defaultFileEntryTypeId = this.getDefaultFileEntryTypeId(dlFolder.getFolderId());
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(dlFolder.getCompanyId());
        serviceContext.setScopeGroupId(dlFolder.getGroupId());
        serviceContext.setUserId(userId);
        this.cascadeFileEntryTypes(userId, dlFolder.getGroupId(), dlFolder.getFolderId(), defaultFileEntryTypeId, fileEntryTypeIds, serviceContext);
    }

    public DLFileEntryType createBasicDocumentDLFileEntryType() {
        DLFileEntryType dlFileEntryType = this.dlFileEntryTypePersistence.create(0L);
        dlFileEntryType.setCompanyId(0L);
        dlFileEntryType.setFileEntryTypeKey(StringUtil.toUpperCase((String)"basic-document"));
        dlFileEntryType.setName("basic-document", LocaleUtil.getDefault());
        return (DLFileEntryType)this.dlFileEntryTypePersistence.update((BaseModel)dlFileEntryType);
    }

    @SystemEvent(action=1, type=1)
    public void deleteFileEntryType(DLFileEntryType dlFileEntryType) throws PortalException {
        int count = this.dlFileEntryPersistence.countByFileEntryTypeId(dlFileEntryType.getFileEntryTypeId());
        if (count > 0) {
            throw new RequiredFileEntryTypeException("There are file entries of file entry type " + dlFileEntryType.getFileEntryTypeId());
        }
        DDMStructureLinkManagerUtil.deleteStructureLinks((long)this.classNameLocalService.getClassNameId(DLFileEntryType.class), (long)dlFileEntryType.getFileEntryTypeId());
        DDMStructure ddmStructure = DDMStructureManagerUtil.fetchStructure((long)dlFileEntryType.getGroupId(), (long)this.classNameLocalService.getClassNameId(DLFileEntryMetadata.class), (String)DLUtil.getDDMStructureKey((DLFileEntryType)dlFileEntryType));
        if (ddmStructure == null) {
            ddmStructure = DDMStructureManagerUtil.fetchStructure((long)dlFileEntryType.getGroupId(), (long)this.classNameLocalService.getClassNameId(DLFileEntryMetadata.class), (String)DLUtil.getDeprecatedDDMStructureKey((DLFileEntryType)dlFileEntryType));
        }
        if (ddmStructure != null) {
            DDMStructureManagerUtil.deleteStructure((long)ddmStructure.getStructureId());
        }
        this.resourceLocalService.deleteResource(dlFileEntryType.getCompanyId(), DLFileEntryType.class.getName(), 4, dlFileEntryType.getFileEntryTypeId());
        this.dlFileEntryTypePersistence.remove((BaseModel)dlFileEntryType);
    }

    public void deleteFileEntryType(long fileEntryTypeId) throws PortalException {
        DLFileEntryType dlFileEntryType = this.dlFileEntryTypePersistence.findByPrimaryKey(fileEntryTypeId);
        this.dlFileEntryTypeLocalService.deleteFileEntryType(dlFileEntryType);
    }

    public void deleteFileEntryTypes(long groupId) throws PortalException {
        List dlFileEntryTypes = this.dlFileEntryTypePersistence.findByGroupId(groupId);
        for (DLFileEntryType dlFileEntryType : dlFileEntryTypes) {
            this.dlFileEntryTypeLocalService.deleteFileEntryType(dlFileEntryType);
        }
    }

    public DLFileEntryType fetchDataDefinitionFileEntryType(long groupId, long dataDefinitionId) {
        return this.dlFileEntryTypePersistence.fetchByG_DDI(groupId, dataDefinitionId);
    }

    public DLFileEntryType fetchFileEntryType(long fileEntryTypeId) {
        return this.dlFileEntryTypePersistence.fetchByPrimaryKey(fileEntryTypeId);
    }

    public DLFileEntryType fetchFileEntryType(long groupId, String fileEntryTypeKey) {
        fileEntryTypeKey = StringUtil.toUpperCase((String)StringUtil.trim((String)fileEntryTypeKey));
        return this.dlFileEntryTypePersistence.fetchByG_F(groupId, fileEntryTypeKey);
    }

    public DLFileEntryType getBasicDocumentDLFileEntryType() throws NoSuchFileEntryTypeException {
        DLFileEntryType dlFileEntryType = this.dlFileEntryTypePersistence.fetchByPrimaryKey(0L);
        if (dlFileEntryType != null) {
            return dlFileEntryType;
        }
        return this.dlFileEntryTypeLocalService.createBasicDocumentDLFileEntryType();
    }

    public long getDefaultFileEntryTypeId(long folderId) throws PortalException {
        if ((folderId = this._getFileEntryTypesPrimaryFolderId(folderId)) != 0L) {
            DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(folderId);
            return dlFolder.getDefaultFileEntryTypeId();
        }
        return 0L;
    }

    public DLFileEntryType getFileEntryType(long fileEntryTypeId) throws PortalException {
        return this.dlFileEntryTypePersistence.findByPrimaryKey(fileEntryTypeId);
    }

    public DLFileEntryType getFileEntryType(long groupId, String fileEntryTypeKey) throws PortalException {
        fileEntryTypeKey = StringUtil.toUpperCase((String)StringUtil.trim((String)fileEntryTypeKey));
        return this.dlFileEntryTypePersistence.findByG_F(groupId, fileEntryTypeKey);
    }

    @Deprecated
    public List<DLFileEntryType> getFileEntryTypes(long ddmStructureId) throws PortalException {
        ArrayList<DLFileEntryType> fileEntryTypes = new ArrayList<DLFileEntryType>();
        long classNameId = this.classNameLocalService.getClassNameId(DLFileEntryType.class);
        List ddmStructureLinks = DDMStructureLinkManagerUtil.getStructureLinks((long)ddmStructureId);
        for (DDMStructureLink ddmStructureLink : ddmStructureLinks) {
            if (classNameId != ddmStructureLink.getClassNameId()) continue;
            DLFileEntryType fileEntryType = this.getFileEntryType(ddmStructureLink.getClassPK());
            fileEntryTypes.add(fileEntryType);
        }
        return fileEntryTypes;
    }

    public List<DLFileEntryType> getFileEntryTypes(long[] groupIds) {
        return this.dlFileEntryTypePersistence.findByGroupId(groupIds);
    }

    public List<DLFileEntryType> getFolderFileEntryTypes(long[] groupIds, long folderId, boolean inherited) throws PortalException {
        if (!inherited) {
            return this.dlFolderPersistence.getDLFileEntryTypes(folderId);
        }
        if ((folderId = this._getFileEntryTypesPrimaryFolderId(folderId)) != 0L) {
            return this.dlFolderPersistence.getDLFileEntryTypes(folderId);
        }
        ArrayList<DLFileEntryType> dlFileEntryTypes = new ArrayList<DLFileEntryType>(this.getFileEntryTypes(groupIds));
        DLFileEntryType dlFileEntryType = this.dlFileEntryTypeLocalService.getBasicDocumentDLFileEntryType();
        dlFileEntryTypes.add(0, dlFileEntryType);
        return dlFileEntryTypes;
    }

    public List<DLFileEntryType> search(long companyId, long[] groupIds, String keywords, boolean includeBasicFileEntryType, int start, int end, OrderByComparator<DLFileEntryType> orderByComparator) {
        return this.dlFileEntryTypeFinder.findByKeywords(companyId, groupIds, keywords, includeBasicFileEntryType, start, end, orderByComparator);
    }

    public int searchCount(long companyId, long[] groupIds, String keywords, boolean includeBasicFileEntryType) {
        return this.dlFileEntryTypeFinder.countByKeywords(companyId, groupIds, keywords, includeBasicFileEntryType);
    }

    public void unsetFolderFileEntryTypes(long folderId) {
        List dlFileEntryTypes = this.dlFolderPersistence.getDLFileEntryTypes(folderId);
        for (DLFileEntryType dlFileEntryType : dlFileEntryTypes) {
            this.dlFolderPersistence.removeDLFileEntryType(folderId, dlFileEntryType);
        }
    }

    public void updateDDMStructureLinks(long fileEntryTypeId, Set<Long> ddmStructureIds) throws PortalException {
        Set<Long> existingDDMStructureLinkStructureIds = this.getExistingDDMStructureLinkStructureIds(fileEntryTypeId);
        this.deleteDDMStructureLinks(fileEntryTypeId, this.getStaleDDMStructureLinkStructureIds(ddmStructureIds, existingDDMStructureLinkStructureIds));
        this.addDDMStructureLinks(fileEntryTypeId, this.getMissingDDMStructureLinkStructureIds(ddmStructureIds, existingDDMStructureLinkStructureIds));
    }

    public DLFileEntry updateFileEntryFileEntryType(DLFileEntry dlFileEntry, ServiceContext serviceContext) throws PortalException {
        List<DLFileEntryType> dlFileEntryTypes;
        List<Long> fileEntryTypeIds;
        long groupId = serviceContext.getScopeGroupId();
        long folderId = 0L;
        DLFolder dlFolder = this.dlFolderPersistence.fetchByPrimaryKey(dlFileEntry.getFolderId());
        if (dlFolder != null) {
            groupId = dlFolder.getGroupId();
            folderId = dlFolder.getFolderId();
        }
        if ((fileEntryTypeIds = this.getFileEntryTypeIds(dlFileEntryTypes = this.getFolderFileEntryTypes(PortalUtil.getCurrentAndAncestorSiteGroupIds((long)groupId), folderId, true))).contains(dlFileEntry.getFileEntryTypeId())) {
            return dlFileEntry;
        }
        long defaultFileEntryTypeId = this.getDefaultFileEntryTypeId(folderId);
        DLFileVersion dlFileVersion = this.dlFileVersionLocalService.getLatestFileVersion(dlFileEntry.getFileEntryId(), true);
        if (dlFileVersion.isPending()) {
            this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(dlFileVersion.getCompanyId(), dlFileEntry.getGroupId(), DLFileEntry.class.getName(), dlFileVersion.getFileVersionId());
        }
        return this.dlFileEntryLocalService.updateFileEntry(serviceContext.getUserId(), dlFileEntry.getFileEntryId(), null, null, null, null, null, DLVersionNumberIncrease.fromMajorVersion((boolean)false), defaultFileEntryTypeId, null, null, null, 0L, null, null, serviceContext);
    }

    @Deprecated
    public void updateFileEntryType(long userId, long fileEntryTypeId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, long[] ddmStructureIds, ServiceContext serviceContext) throws PortalException {
        DLFileEntryType dlFileEntryType = this.dlFileEntryTypePersistence.findByPrimaryKey(fileEntryTypeId);
        ddmStructureIds = this._updateDDMStructure(userId, dlFileEntryType.getUuid(), fileEntryTypeId, dlFileEntryType.getGroupId(), nameMap, descriptionMap, ddmStructureIds, serviceContext);
        this._validateDDMStructures(dlFileEntryType.getFileEntryTypeKey(), ddmStructureIds);
        dlFileEntryType.setNameMap(nameMap);
        dlFileEntryType.setDescriptionMap(descriptionMap);
        this.dlFileEntryTypePersistence.update((BaseModel)dlFileEntryType);
        this.updateDDMStructureLinks(fileEntryTypeId, SetUtil.fromArray((long[])ddmStructureIds));
    }

    @Deprecated
    public void updateFileEntryType(long userId, long fileEntryTypeId, String name, String description, long[] ddmStructureIds, ServiceContext serviceContext) throws PortalException {
        this.updateFileEntryType(userId, fileEntryTypeId, HashMapBuilder.put((Object)LocaleUtil.getSiteDefault(), (Object)name).build(), HashMapBuilder.put((Object)LocaleUtil.getSiteDefault(), (Object)description).build(), ddmStructureIds, serviceContext);
    }

    public DLFileEntryType updateFileEntryType(long fileEntryTypeId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap) throws PortalException {
        DLFileEntryType dlFileEntryType = this.dlFileEntryTypePersistence.findByPrimaryKey(fileEntryTypeId);
        dlFileEntryType.setNameMap(nameMap);
        dlFileEntryType.setDescriptionMap(descriptionMap);
        return (DLFileEntryType)this.dlFileEntryTypePersistence.update((BaseModel)dlFileEntryType);
    }

    public void updateFolderFileEntryTypes(DLFolder dlFolder, List<Long> fileEntryTypeIds, long defaultFileEntryTypeId, ServiceContext serviceContext) {
        List<Long> originalFileEntryTypeIds = this.getFileEntryTypeIds(this.dlFolderPersistence.getDLFileEntryTypes(dlFolder.getFolderId()));
        if (fileEntryTypeIds.equals(originalFileEntryTypeIds)) {
            return;
        }
        for (Long fileEntryTypeId : fileEntryTypeIds) {
            if (originalFileEntryTypeIds.contains(fileEntryTypeId) || fileEntryTypeId == -1L) continue;
            DLFileEntryType dlFileEntryType = DLFileEntryTypeLocalServiceUtil.fetchDLFileEntryType((long)fileEntryTypeId);
            if (dlFileEntryType == null) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Document library file entry type " + fileEntryTypeId + " does not exist"));
                continue;
            }
            this.dlFolderPersistence.addDLFileEntryType(dlFolder.getFolderId(), fileEntryTypeId.longValue());
        }
        for (Long originalFileEntryTypeId : originalFileEntryTypeIds) {
            if (fileEntryTypeIds.contains(originalFileEntryTypeId)) continue;
            this.dlFolderPersistence.removeDLFileEntryType(dlFolder.getFolderId(), originalFileEntryTypeId.longValue());
            this.workflowDefinitionLinkLocalService.deleteWorkflowDefinitionLink(dlFolder.getCompanyId(), dlFolder.getGroupId(), DLFolder.class.getName(), dlFolder.getFolderId(), originalFileEntryTypeId.longValue());
        }
    }

    @Deprecated
    protected static long getDefaultFileEntryTypeId(DLFolderPersistence dlFolderPersistence, long folderId) throws PortalException {
        return DLFileEntryTypeLocalServiceUtil.getDefaultFileEntryTypeId((long)folderId);
    }

    @Deprecated
    protected static long getFileEntryTypesPrimaryFolderId(DLFolderPersistence dlFolderPersistence, long folderId) throws NoSuchFolderException {
        DLFolder dlFolder;
        while (folderId != 0L && (dlFolder = dlFolderPersistence.findByPrimaryKey(folderId)).getRestrictionType() != 1) {
            folderId = dlFolder.getParentFolderId();
        }
        return folderId;
    }

    protected void addFileEntryTypeResources(DLFileEntryType dlFileEntryType, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this.resourceLocalService.addResources(dlFileEntryType.getCompanyId(), dlFileEntryType.getGroupId(), dlFileEntryType.getUserId(), DLFileEntryType.class.getName(), dlFileEntryType.getFileEntryTypeId(), false, addGroupPermissions, addGuestPermissions);
    }

    protected void addFileEntryTypeResources(DLFileEntryType dlFileEntryType, ModelPermissions modelPermissions) throws PortalException {
        this.resourceLocalService.addModelResources(dlFileEntryType.getCompanyId(), dlFileEntryType.getGroupId(), dlFileEntryType.getUserId(), DLFileEntryType.class.getName(), dlFileEntryType.getFileEntryTypeId(), modelPermissions);
    }

    protected void cascadeFileEntryTypes(long userId, long groupId, long folderId, long defaultFileEntryTypeId, List<Long> fileEntryTypeIds, ServiceContext serviceContext) throws PortalException {
        List dlFileEntries = this.dlFileEntryPersistence.findByG_F(groupId, folderId);
        for (DLFileEntry dlFileEntry : dlFileEntries) {
            if (fileEntryTypeIds.contains(dlFileEntry.getFileEntryTypeId())) continue;
            DLFileVersion dlFileVersion = this.dlFileVersionLocalService.getLatestFileVersion(dlFileEntry.getFileEntryId(), true);
            if (dlFileVersion.isPending()) {
                this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(dlFileVersion.getCompanyId(), groupId, DLFileEntry.class.getName(), dlFileVersion.getFileVersionId());
            }
            this.dlFileEntryLocalService.updateFileEntryType(userId, dlFileEntry.getFileEntryId(), defaultFileEntryTypeId, serviceContext);
            this.dlAppHelperLocalService.updateAsset(userId, (FileEntry)new LiferayFileEntry(dlFileEntry), (FileVersion)new LiferayFileVersion(dlFileVersion), serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        }
        List subfolders = this.dlFolderPersistence.findByG_M_P_H(groupId, false, folderId, false);
        for (DLFolder subfolder : subfolders) {
            if (subfolder.getRestrictionType() == 0) continue;
            this.cascadeFileEntryTypes(userId, groupId, subfolder.getFolderId(), defaultFileEntryTypeId, fileEntryTypeIds, serviceContext);
        }
    }

    protected void deleteDDMStructureLinks(long fileEntryTypeId, Set<Long> ddmStructureIds) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(DLFileEntryType.class);
        for (long ddmStructureId : ddmStructureIds) {
            DDMStructureLinkManagerUtil.deleteStructureLink((long)classNameId, (long)fileEntryTypeId, (long)ddmStructureId);
        }
    }

    protected void fixDDMStructureKey(String fileEntryTypeUuid, long fileEntryTypeId, long groupId) throws PortalException {
        DDMStructure ddmStructure = DDMStructureManagerUtil.fetchStructure((long)groupId, (long)this.classNameLocalService.getClassNameId(DLFileEntryMetadata.class), (String)DLUtil.getDeprecatedDDMStructureKey((long)fileEntryTypeId));
        if (ddmStructure != null) {
            DDMStructureManagerUtil.updateStructureKey((long)ddmStructure.getStructureId(), (String)DLUtil.getDDMStructureKey((String)fileEntryTypeUuid));
        }
    }

    protected Set<Long> getExistingDDMStructureLinkStructureIds(long fileEntryTypeId) {
        long classNameId = this.classNameLocalService.getClassNameId(DLFileEntryType.class);
        HashSet<Long> existingDDMStructureLinkStructureIds = new HashSet<Long>();
        List structureLinks = DDMStructureLinkManagerUtil.getStructureLinks((long)classNameId, (long)fileEntryTypeId);
        for (DDMStructureLink structureLink : structureLinks) {
            existingDDMStructureLinkStructureIds.add(structureLink.getStructureId());
        }
        return existingDDMStructureLinkStructureIds;
    }

    protected List<Long> getFileEntryTypeIds(List<DLFileEntryType> dlFileEntryTypes) {
        SortedArrayList fileEntryTypeIds = new SortedArrayList();
        for (DLFileEntryType dlFileEntryType : dlFileEntryTypes) {
            fileEntryTypeIds.add(dlFileEntryType.getFileEntryTypeId());
        }
        return fileEntryTypeIds;
    }

    protected Set<Long> getMissingDDMStructureLinkStructureIds(Set<Long> ddmStructureIds, Set<Long> existingDDMStructureIds) {
        HashSet<Long> missingDDMStructureLinkStructureIds = new HashSet<Long>(ddmStructureIds);
        missingDDMStructureLinkStructureIds.removeAll(existingDDMStructureIds);
        return missingDDMStructureLinkStructureIds;
    }

    protected Set<Long> getStaleDDMStructureLinkStructureIds(Set<Long> ddmStructureIds, Set<Long> existingDDMStructureIds) {
        HashSet<Long> staleDDMStructureLinkStructureIds = new HashSet<Long>(existingDDMStructureIds);
        staleDDMStructureLinkStructureIds.removeAll(ddmStructureIds);
        return staleDDMStructureLinkStructureIds;
    }

    private void _deleteDDMStructure(long fileEntryTypeId, long ddmStructureId) throws PortalException {
        this.deleteDDMStructureLinks(fileEntryTypeId, Collections.singleton(ddmStructureId));
        DDMStructureManagerUtil.deleteStructure((long)ddmStructureId);
    }

    private DDMForm _getDDMForm(DDMStructure ddmStructure, ServiceContext serviceContext) {
        DDMForm ddmForm = (DDMForm)serviceContext.getAttribute("ddmForm");
        if (ddmForm != null) {
            return ddmForm;
        }
        if (ddmStructure != null) {
            return ddmStructure.getDDMForm();
        }
        return null;
    }

    private long _getFileEntryTypesPrimaryFolderId(long folderId) throws NoSuchFolderException {
        DLFolder dlFolder;
        while (folderId != 0L && (dlFolder = this.dlFolderPersistence.findByPrimaryKey(folderId)).getRestrictionType() != 1) {
            folderId = dlFolder.getParentFolderId();
        }
        return folderId;
    }

    private boolean _isEmptyDDMForm(DDMForm ddmForm) {
        if (ddmForm == null) {
            return true;
        }
        List ddmFormFields = ddmForm.getDDMFormFields();
        return ddmFormFields.isEmpty();
    }

    private long[] _updateDDMStructure(long userId, String fileEntryTypeUuid, long fileEntryTypeId, long groupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, long[] ddmStructureIds, ServiceContext serviceContext) throws PortalException {
        DDMStructure ddmStructure = null;
        try {
            this.fixDDMStructureKey(fileEntryTypeUuid, fileEntryTypeId, groupId);
            String ddmStructureKey = DLUtil.getDDMStructureKey((String)fileEntryTypeUuid);
            ddmStructure = DDMStructureManagerUtil.fetchStructure((long)groupId, (long)this.classNameLocalService.getClassNameId(DLFileEntryMetadata.class), (String)ddmStructureKey);
            DDMForm ddmForm = this._getDDMForm(ddmStructure, serviceContext);
            if (this._isEmptyDDMForm(ddmForm)) {
                if (ddmStructure != null) {
                    this._deleteDDMStructure(fileEntryTypeId, ddmStructure.getStructureId());
                    return ArrayUtil.remove((long[])ddmStructureIds, (long)ddmStructure.getStructureId());
                }
                return ddmStructureIds;
            }
            ddmStructure = ddmStructure == null ? DDMStructureManagerUtil.addStructure((long)userId, (long)groupId, null, (long)this.classNameLocalService.getClassNameId(DLFileEntryMetadata.class), (String)ddmStructureKey, nameMap, descriptionMap, (DDMForm)ddmForm, (String)"json", (int)1, (ServiceContext)serviceContext) : DDMStructureManagerUtil.updateStructure((long)userId, (long)ddmStructure.getStructureId(), (long)ddmStructure.getParentStructureId(), nameMap, descriptionMap, (DDMForm)ddmForm, (ServiceContext)serviceContext);
            return ArrayUtil.append((long[])ddmStructureIds, (long)ddmStructure.getStructureId());
        }
        catch (StructureDefinitionException structureDefinitionException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)structureDefinitionException, (Throwable)structureDefinitionException);
            }
            if (ddmStructure != null) {
                long ddmStructureId = ddmStructure.getStructureId();
                this._deleteDDMStructure(fileEntryTypeId, ddmStructureId);
                return ArrayUtil.remove((long[])ddmStructureIds, (long)ddmStructureId);
            }
            return ddmStructureIds;
        }
    }

    private void _validateDDMStructures(String fileEntryTypeKey, long[] ddmStructureIds) throws NoSuchMetadataSetException {
        if (ddmStructureIds.length == 0) {
            throw new NoSuchMetadataSetException("DDM structure IDs is empty for file entry type " + fileEntryTypeKey);
        }
        for (long ddmStructureId : ddmStructureIds) {
            DDMStructure ddmStructure = DDMStructureManagerUtil.fetchStructure((long)ddmStructureId);
            if (ddmStructure != null) continue;
            throw new NoSuchMetadataSetException("{ddmStructureId=" + ddmStructureId + "}");
        }
    }

    private void _validateFileEntryTypeKey(long groupId, String fileEntryTypeKey) throws DuplicateFileEntryTypeException {
        DLFileEntryType dlFileEntryType = this.dlFileEntryTypePersistence.fetchByG_F(groupId, fileEntryTypeKey);
        if (dlFileEntryType != null) {
            throw new DuplicateFileEntryTypeException("A file entry type already exists for key " + fileEntryTypeKey);
        }
    }
}

