/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.store;

import com.liferay.document.library.kernel.store.Store;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.change.tracking.store.CTStoreFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class StoreFactory {
    private static final Log _log = LogFactoryUtil.getLog(StoreFactory.class);
    private static StoreFactory _storeFactory;
    private static final StoreServiceTrackerMapHolder _storeServiceTrackerMapHolder;
    private static boolean _warned;

    public static StoreFactory getInstance() {
        if (_storeFactory == null) {
            _storeFactory = new StoreFactory();
        }
        return _storeFactory;
    }

    public void checkProperties() {
        if (_warned) {
            return;
        }
        String dlHookImpl = PropsUtil.get("dl.hook.impl");
        if (Validator.isNull((String)dlHookImpl)) {
            _warned = true;
            return;
        }
        boolean found = false;
        for (String key : _storeServiceTrackerMapHolder.keySet()) {
            Store store = this.getStore(key);
            Class<?> clazz = store.getClass();
            String className = clazz.getName();
            if (!dlHookImpl.equals(className)) continue;
            PropsValues.DL_STORE_IMPL = className;
            found = true;
            break;
        }
        if (!found) {
            PropsValues.DL_STORE_IMPL = dlHookImpl;
        }
        if (_log.isWarnEnabled()) {
            StringBundler sb = new StringBundler(11);
            sb.append("Liferay is configured with the legacy property ");
            sb.append("\"dl.hook.impl=");
            sb.append(dlHookImpl);
            sb.append("\" in portal-ext.properties. Please reconfigure to ");
            sb.append("use the new property \"");
            sb.append("dl.store.impl");
            sb.append("\". Liferay will attempt to temporarily set \"");
            sb.append("dl.store.impl");
            sb.append("=");
            sb.append(PropsValues.DL_STORE_IMPL);
            sb.append("\".");
            _log.warn((Object)sb.toString());
        }
        _warned = true;
    }

    public Store getStore() {
        Store store = _storeServiceTrackerMapHolder.getService(PropsValues.DL_STORE_IMPL);
        if (store == null) {
            throw new IllegalStateException("Store is not available");
        }
        return store;
    }

    public Store getStore(String key) {
        return _storeServiceTrackerMapHolder.getService(key);
    }

    public String[] getStoreTypes() {
        Set<String> storeTypes = _storeServiceTrackerMapHolder.keySet();
        return storeTypes.toArray(new String[0]);
    }

    @Deprecated
    public void setStore(String key) {
    }

    static {
        _storeServiceTrackerMapHolder = new StoreServiceTrackerMapHolder();
    }

    private static class StoreTypeServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<Store, Store> {
        private final CTStoreFactory _ctStoreFactory;
        private ServiceRegistration<StoreFactory> _serviceRegistration;

        public StoreTypeServiceTrackerCustomizer(CTStoreFactory ctStoreFactory) {
            this._ctStoreFactory = ctStoreFactory;
        }

        public Store addingService(ServiceReference<Store> serviceReference) {
            String storeType = GetterUtil.getString((Object)serviceReference.getProperty("store.type"));
            final Store store = this._getStore(serviceReference, storeType);
            if (StringUtil.equals((String)storeType, (String)PropsValues.DL_STORE_IMPL)) {
                HashMap properties = HashMapBuilder.put((Object)"dl.store.impl.enabled", (Object)GetterUtil.getObject((Object)"true")).build();
                Registry registry = RegistryUtil.getRegistry();
                this._serviceRegistration = registry.registerService(StoreFactory.class, (Object)new StoreFactory(){

                    @Override
                    public Store getStore() {
                        return store;
                    }
                }, (Map)properties);
            }
            return store;
        }

        public void modifiedService(ServiceReference<Store> serviceReference, Store service) {
        }

        public void removedService(ServiceReference<Store> serviceReference, Store service) {
            String storeType = GetterUtil.getString((Object)serviceReference.getProperty("store.type"));
            if (StringUtil.equals((String)storeType, (String)PropsValues.DL_STORE_IMPL)) {
                this._serviceRegistration.unregister();
            }
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
        }

        private Store _getStore(ServiceReference<Store> serviceReference, String storeType) {
            Registry registry = RegistryUtil.getRegistry();
            Store store = (Store)registry.getService(serviceReference);
            if (!GetterUtil.getBoolean((Object)serviceReference.getProperty("ct.aware"))) {
                store = this._ctStoreFactory.createCTStore(store, storeType);
            }
            return store;
        }
    }

    private static class StoreServiceTrackerMapHolder {
        private final ServiceTracker<CTStoreFactory, ServiceTrackerMap<String, Store>> _serviceTracker;

        public StoreServiceTrackerMapHolder() {
            Registry registry = RegistryUtil.getRegistry();
            this._serviceTracker = registry.trackServices(CTStoreFactory.class, (ServiceTrackerCustomizer)new CTStoreFactoryServiceTrackerCustomizer());
            this._serviceTracker.open();
        }

        public Store getService(String key) {
            ServiceTrackerMap serviceTrackerMap = (ServiceTrackerMap)this._serviceTracker.getService();
            if (serviceTrackerMap == null) {
                return null;
            }
            return (Store)serviceTrackerMap.getService((Object)key);
        }

        public Set<String> keySet() {
            ServiceTrackerMap serviceTrackerMap = (ServiceTrackerMap)this._serviceTracker.getService();
            if (serviceTrackerMap == null) {
                return Collections.emptySet();
            }
            return serviceTrackerMap.keySet();
        }
    }

    private static class CTStoreFactoryServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<CTStoreFactory, ServiceTrackerMap<String, Store>> {
        private CTStoreFactoryServiceTrackerCustomizer() {
        }

        public ServiceTrackerMap<String, Store> addingService(ServiceReference<CTStoreFactory> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            CTStoreFactory ctStoreFactory = (CTStoreFactory)registry.getService(serviceReference);
            return ServiceTrackerCollections.openSingleValueMap(Store.class, (String)"store.type", (ServiceTrackerCustomizer)new StoreTypeServiceTrackerCustomizer(ctStoreFactory));
        }

        public void modifiedService(ServiceReference<CTStoreFactory> serviceReference, ServiceTrackerMap<String, Store> serviceTrackerMap) {
        }

        public void removedService(ServiceReference<CTStoreFactory> serviceReference, ServiceTrackerMap<String, Store> serviceTrackerMap) {
            serviceTrackerMap.close();
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
        }
    }
}

